/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.postprocess.util.FullscreenMesh;
import gaiasky.render.util.ShaderLoader;
import gaiasky.util.gdx.loader.PFMData;
import gaiasky.util.gdx.loader.WarpMeshReader;

public final class WarpingMeshFilter
extends Filter<WarpingMeshFilter> {
    private final FullscreenMesh mesh;
    private Texture blendTexture;
    private final Vector2 viewport;
    private int blend;

    public WarpingMeshFilter(PFMData warpData, float rw, float rh) {
        super(ShaderLoader.fromFile("screenspace", "geometrywarp"));
        this.blend = 0;
        this.mesh = new FullscreenMesh(warpData.data, warpData.width, warpData.height);
        this.viewport = new Vector2(rw, rh);
        this.rebind();
    }

    public WarpingMeshFilter(PFMData warpData, Texture blend) {
        super(ShaderLoader.fromFile("screenspace", "geometrywarp"));
        this.mesh = new FullscreenMesh(warpData.data, warpData.width, warpData.height);
        this.viewport = new Vector2();
        this.rebind();
        this.setBlendTexture(blend);
    }

    public WarpingMeshFilter(WarpMeshReader.WarpMesh warpMesh, int rw, int rh) {
        super(ShaderLoader.fromFile("screenspace-alpha", "geometrywarp-alpha"));
        this.mesh = new FullscreenMesh(warpMesh);
        this.viewport = new Vector2((float)rw, (float)rh);
        this.rebind();
    }

    public void setBlendTexture(Texture tex) {
        this.blendTexture = tex;
        this.setParam((Filter.Parameter)Param.Blend, 1);
        this.blend = tex == null ? 0 : 1;
        this.setParam((Filter.Parameter)Param.BlendState, this.blend);
    }

    public void setViewportSize(int width, int height) {
        this.viewport.set((float)width, (float)height);
        this.setParam((Filter.Parameter)Param.Viewport, this.viewport);
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
        if (this.blendTexture != null) {
            this.blendTexture.bind(1);
        }
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture0, 0);
        this.setParams((Filter.Parameter)Param.Blend, 1);
        this.setParams((Filter.Parameter)Param.Viewport, this.viewport);
        this.setParams((Filter.Parameter)Param.BlendState, this.blend);
        this.endParams();
    }

    @Override
    protected void realRender() {
        this.onBeforeRender();
        this.program.bind();
        this.mesh.render(this.program);
    }

    public static enum Param implements Filter.Parameter
    {
        Texture0("u_texture0", 0),
        Blend("u_texture1", 0),
        Viewport("u_viewport", 2),
        BlendState("u_blend", 0);

        private final String mnemonic;
        private final int elementSize;

        private Param(String m, int elementSize) {
            this.mnemonic = m;
            this.elementSize = elementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

