/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.filters;

import com.badlogic.gdx.math.Vector2;
import gaiasky.render.postprocess.filters.Filter;
import gaiasky.render.util.ShaderLoader;

public class XBRZUpscaleFilter
extends Filter<XBRZUpscaleFilter> {
    private final Vector2 inputSize;
    private final Vector2 outputSize;

    public XBRZUpscaleFilter() {
        this(new Vector2(), new Vector2());
    }

    public XBRZUpscaleFilter(Vector2 inputSize, Vector2 outputSize) {
        super(ShaderLoader.fromFile("screenspace", "xbrz-freescale"));
        this.inputSize = new Vector2(inputSize);
        this.outputSize = new Vector2(outputSize);
        this.rebind();
    }

    public void setInputSize(float width, float height) {
        this.inputSize.set(width, height);
        this.setParam((Filter.Parameter)Param.InputSize, this.inputSize);
    }

    public void setOutputSize(float width, float height) {
        this.outputSize.set(width, height);
        this.setParam((Filter.Parameter)Param.OutputSize, this.outputSize);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture, 0);
        this.setParams((Filter.Parameter)Param.InputSize, this.inputSize);
        this.setParams((Filter.Parameter)Param.OutputSize, this.outputSize);
        this.endParams();
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
    }

    public static enum Param implements Filter.Parameter
    {
        Texture("u_texture0", 0),
        InputSize("u_inputSize", 2),
        OutputSize("u_outputSize", 2);

        private final String mnemonic;
        private final int elementSize;

        private Param(String mnemonic, int arrayElementSize) {
            this.mnemonic = mnemonic;
            this.elementSize = arrayElementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

