/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.postprocess.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.render.util.GaiaSkyFrameBuffer;
import gaiasky.util.Settings;

public final class PingPongBuffer
implements Disposable {
    public final boolean ownResources;
    private final GaiaSkyFrameBuffer ownedMain;
    private final GaiaSkyFrameBuffer owned1;
    private final GaiaSkyFrameBuffer owned2;
    public Texture texture1;
    public Texture texture2;
    public int width;
    public int height;
    private GaiaSkyFrameBuffer buffer1;
    private GaiaSkyFrameBuffer buffer2;
    private Texture texResult;
    private Texture texSrc;
    private GaiaSkyFrameBuffer bufResult;
    private GaiaSkyFrameBuffer bufSrc;
    private boolean writeState;
    private boolean pending1;
    private boolean pending2;
    private GaiaSkyFrameBuffer ownedResult;
    private GaiaSkyFrameBuffer ownedSource;
    private int ownedW;
    private int ownedH;

    public PingPongBuffer(int width, int height, Pixmap.Format pixmapFormat, boolean hasDepth, boolean hasNormal, boolean hasReflectionMask, boolean preventFloatBuffer) {
        this.ownResources = true;
        this.ownedMain = PingPongBuffer.createMainFrameBuffer(width, height, hasDepth, hasNormal, hasReflectionMask, pixmapFormat, preventFloatBuffer);
        GLFrameBuffer.FrameBufferBuilder frameBufferBuilder = new GLFrameBuffer.FrameBufferBuilder(width, height);
        PingPongBuffer.addColorRenderTarget(frameBufferBuilder, pixmapFormat, preventFloatBuffer);
        this.owned1 = new GaiaSkyFrameBuffer((GLFrameBuffer.GLFrameBufferBuilder<? extends GLFrameBuffer<Texture>>)frameBufferBuilder, 0);
        this.owned2 = new GaiaSkyFrameBuffer((GLFrameBuffer.GLFrameBufferBuilder<? extends GLFrameBuffer<Texture>>)frameBufferBuilder, 0);
        this.set(this.owned1, this.owned2);
    }

    public static GaiaSkyFrameBuffer createMainFrameBuffer(int width, int height, boolean hasDepth, boolean hasNormal, boolean hasReflectionMask, Pixmap.Format frameBufferFormat, boolean preventFloatBuffer) {
        GLFrameBuffer.FrameBufferBuilder frameBufferBuilder = new GLFrameBuffer.FrameBufferBuilder(width, height);
        int depthIndex = -1;
        int layerIndex = -1;
        int normalIndex = -1;
        int reflectionMaskIndex = -1;
        int idx = 0;
        PingPongBuffer.addColorRenderTarget(frameBufferBuilder, frameBufferFormat, preventFloatBuffer);
        int colorIndex = idx++;
        PingPongBuffer.addColorRenderTarget(frameBufferBuilder, frameBufferFormat, preventFloatBuffer);
        layerIndex = idx++;
        if (hasNormal) {
            PingPongBuffer.addColorRenderTarget(frameBufferBuilder, frameBufferFormat, preventFloatBuffer);
            normalIndex = idx++;
        }
        if (hasReflectionMask) {
            PingPongBuffer.addColorRenderTarget(frameBufferBuilder, frameBufferFormat, preventFloatBuffer);
            reflectionMaskIndex = idx++;
        }
        if (hasDepth) {
            PingPongBuffer.addDepthRenderTarget(frameBufferBuilder, preventFloatBuffer);
            if (!preventFloatBuffer) {
                depthIndex = idx;
            }
        }
        return new GaiaSkyFrameBuffer((GLFrameBuffer.GLFrameBufferBuilder<? extends GLFrameBuffer<Texture>>)frameBufferBuilder, colorIndex, depthIndex, layerIndex, normalIndex, reflectionMaskIndex);
    }

    private static void addColorRenderTarget(GLFrameBuffer.FrameBufferBuilder builder, Pixmap.Format pixmapFormat, boolean preventFloatBuffer) {
        if (Gdx.graphics.isGL30Available() && !preventFloatBuffer) {
            if (pixmapFormat == Pixmap.Format.RGBA8888 || pixmapFormat == Pixmap.Format.RGBA4444) {
                PingPongBuffer.addFloatRenderTarget(builder, Settings.settings.graphics.useSRGB ? 35907 : 34842);
            } else {
                PingPongBuffer.addFloatRenderTarget(builder, Settings.settings.graphics.useSRGB ? 35905 : 34843);
            }
        } else {
            PingPongBuffer.addColorRenderTarget(builder, pixmapFormat);
        }
    }

    private static void addFloatRenderTarget(GLFrameBuffer.FrameBufferBuilder builder, int internalFormat) {
        builder.addFloatAttachment(internalFormat, 6408, 5126, true);
    }

    private static void addColorRenderTarget(GLFrameBuffer.FrameBufferBuilder builder, Pixmap.Format pixmapFormat) {
        builder.addBasicColorTextureAttachment(pixmapFormat);
    }

    private static void addDepthRenderTarget(GLFrameBuffer.FrameBufferBuilder builder, boolean preventFloatBuffer) {
        if (Gdx.graphics.isGL30Available() && !preventFloatBuffer) {
            builder.addDepthTextureAttachment(33190, 5126);
        } else {
            builder.addBasicDepthRenderBuffer();
        }
    }

    public void set(GaiaSkyFrameBuffer buffer1, GaiaSkyFrameBuffer buffer2) {
        if (this.ownResources) {
            this.ownedResult = this.bufResult;
            this.ownedSource = this.bufSrc;
            this.ownedW = this.width;
            this.ownedH = this.height;
        }
        this.buffer1 = buffer1;
        this.buffer2 = buffer2;
        this.width = this.buffer1.getWidth();
        this.height = this.buffer1.getHeight();
        this.rebind();
    }

    public void reset() {
        if (this.ownResources) {
            this.buffer1 = this.owned1;
            this.buffer2 = this.owned2;
            this.width = this.ownedW;
            this.height = this.ownedH;
            this.bufResult = this.ownedResult;
            this.bufSrc = this.ownedSource;
        }
    }

    public void dispose() {
        if (this.ownResources) {
            this.owned2.dispose();
            this.owned1.dispose();
        }
    }

    public void rebind() {
        this.texture1 = this.buffer1.getColorBufferTexture();
        this.texture2 = this.buffer2.getColorBufferTexture();
    }

    public void begin() {
        this.pending1 = false;
        this.pending2 = false;
        this.writeState = true;
        this.texSrc = this.texture1;
        this.bufSrc = this.buffer1;
        this.texResult = this.texture2;
        this.bufResult = this.buffer2;
    }

    public Texture capture() {
        this.endPending();
        if (this.writeState) {
            this.texSrc = this.texture1;
            this.bufSrc = this.buffer1;
            this.texResult = this.texture2;
            this.bufResult = this.buffer2;
            this.pending2 = true;
            this.buffer2.begin();
        } else {
            this.texSrc = this.texture2;
            this.bufSrc = this.buffer2;
            this.texResult = this.texture1;
            this.bufResult = this.buffer1;
            this.pending1 = true;
            this.buffer1.begin();
        }
        this.writeState = !this.writeState;
        return this.texSrc;
    }

    public void end() {
        this.endPending();
    }

    public Texture getSouceTexture() {
        return this.texSrc;
    }

    public GaiaSkyFrameBuffer getSourceBuffer() {
        return this.bufSrc;
    }

    public Texture getResultTexture() {
        return this.texResult;
    }

    public GaiaSkyFrameBuffer getResultBuffer() {
        return this.bufResult;
    }

    public GaiaSkyFrameBuffer getMainBuffer() {
        return this.ownedMain;
    }

    private void endPending() {
        if (this.pending1) {
            this.buffer1.end();
            this.pending1 = false;
        }
        if (this.pending2) {
            this.buffer2.end();
            this.pending2 = false;
        }
    }
}

