/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.process;

import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.viewport.ExtendViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.RenderingContext;
import gaiasky.render.api.IPostProcessor;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.Settings;
import java.util.function.BooleanSupplier;

public class RenderModeAbstract {
    protected FrameBuffer resultBuffer;
    protected RenderingContext rc = new RenderingContext();
    protected Viewport extendViewport = new ExtendViewport(200.0f, 200.0f);

    protected boolean postProcessCapture(IPostProcessor.PostProcessBean ppb, FrameBuffer fb, int rw, int rh, BooleanSupplier captureFunction) {
        boolean postProcess = captureFunction.getAsBoolean();
        this.rc.ppb = postProcess ? ppb : null;
        this.rc.fb = fb;
        this.rc.set(rw, rh);
        return postProcess;
    }

    protected void postProcessRender(IPostProcessor.PostProcessBean ppb, FrameBuffer fb, boolean postproc, ICamera camera, int rw, int rh) {
        ppb.render(fb);
        if (!Settings.settings.runtime.openXr) {
            if (fb != null && postproc) {
                fb.begin();
            }
            camera.render(rw, rh);
            if (fb != null && postproc) {
                fb.end();
            }
        }
        this.resultBuffer = fb != null ? fb : ppb.pp.getCombinedBuffer().getResultBuffer();
    }

    public RenderingContext getRenderingContext() {
        return this.rc;
    }

    public FrameBuffer getResultBuffer() {
        return this.resultBuffer;
    }

    protected void sendOrientationUpdate(PerspectiveCamera cam, int w, int h) {
        EventManager.publish(Event.CAMERA_ORIENTATION_UPDATE, this, cam, w, h);
    }
}

