/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.process;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.viewport.StretchViewport;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.RenderingContext;
import gaiasky.render.api.IPostProcessor;
import gaiasky.render.api.ISceneRenderer;
import gaiasky.render.postprocess.effects.Mosaic;
import gaiasky.render.process.RenderModeAbstract;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.Settings;
import java.util.HashMap;
import java.util.Map;

public abstract class RenderModeCubemap
extends RenderModeAbstract {
    private final Mosaic mosaic;
    protected Vector3 aux1 = new Vector3();
    protected Vector3 aux2;
    protected Vector3 aux3 = new Vector3();
    protected Vector3 dirEffective;
    protected Vector3 upEffective;
    protected Vector3 dirBackup;
    protected Vector3 upBackup;
    protected Vector3 dirUpCrs;
    protected StretchViewport stretchViewport;
    protected Map<Integer, FrameBuffer> frameBufferCubeMap;
    protected float fovBackup;
    protected FrameBuffer zPosFb;
    protected FrameBuffer zNegFb;
    protected FrameBuffer xPosFb;
    protected FrameBuffer xNegFb;
    protected FrameBuffer yPosFb;
    protected FrameBuffer yNegFb;
    protected boolean zPosFlag = true;
    protected boolean zNegFlag = true;
    protected boolean xPosFlag = true;
    protected boolean xNegFlag = true;
    protected boolean yPosFlag = true;
    protected boolean yNegFlag = true;
    protected float angleFromZenith = 0.0f;

    protected RenderModeCubemap() {
        this.aux2 = new Vector3();
        this.dirEffective = new Vector3();
        this.dirBackup = new Vector3();
        this.upEffective = new Vector3();
        this.upBackup = new Vector3();
        this.dirUpCrs = new Vector3();
        this.stretchViewport = new StretchViewport((float)Gdx.graphics.getHeight(), (float)Gdx.graphics.getHeight());
        this.mosaic = new Mosaic(0.0f, 0.0f);
        this.frameBufferCubeMap = new HashMap<Integer, FrameBuffer>();
    }

    protected void renderCubemapSides(ISceneRenderer sgr, ICamera camera, double t, int rw, int rh, IPostProcessor.PostProcessBean ppb) {
        PerspectiveCamera cam = camera.getCamera();
        this.dirBackup.set(cam.direction);
        this.upBackup.set(cam.direction);
        this.fovBackup = cam.fieldOfView;
        this.dirEffective.set(cam.direction);
        this.upEffective.set(cam.up);
        this.dirUpCrs.set(cam.direction).crs(cam.up).nor().scl(-1.0f);
        if (this.angleFromZenith != 0.0f) {
            this.dirEffective.rotate(this.dirUpCrs, -this.angleFromZenith);
            this.upEffective.rotate(this.dirUpCrs, -this.angleFromZenith);
        }
        EventManager.publish(Event.FOV_CHANGED_CMD, this, Float.valueOf(90.0f));
        int wh = Settings.settings.program.modeCubemap.faceResolution;
        this.zPosFb = this.getFrameBuffer(wh, wh, 0);
        this.zNegFb = this.getFrameBuffer(wh, wh, 1);
        this.xPosFb = this.getFrameBuffer(wh, wh, 2);
        this.xNegFb = this.getFrameBuffer(wh, wh, 3);
        this.yPosFb = this.getFrameBuffer(wh, wh, 4);
        this.yNegFb = this.getFrameBuffer(wh, wh, 5);
        StretchViewport viewport = this.stretchViewport;
        viewport.setCamera((Camera)cam);
        viewport.setWorldSize((float)wh, (float)wh);
        viewport.setScreenBounds(0, 0, wh, wh);
        viewport.apply();
        if (this.xPosFlag) {
            this.rc.cubemapSide = RenderingContext.CubemapSide.SIDE_RIGHT;
            cam.up.set(this.upEffective);
            cam.direction.set(this.dirEffective).rotate(cam.up, -90.0f);
            cam.update();
            this.renderFace(this.xPosFb, camera, sgr, ppb, rw, rh, wh, t);
        }
        if (this.xNegFlag) {
            this.rc.cubemapSide = RenderingContext.CubemapSide.SIDE_LEFT;
            cam.up.set(this.upEffective);
            cam.direction.set(this.dirEffective).rotate(cam.up, 90.0f);
            cam.update();
            this.renderFace(this.xNegFb, camera, sgr, ppb, rw, rh, wh, t);
        }
        if (this.yPosFlag) {
            this.rc.cubemapSide = RenderingContext.CubemapSide.SIDE_UP;
            cam.direction.set(this.dirEffective).rotate(this.dirUpCrs, 90.0f);
            cam.up.set(this.upEffective).rotate(this.dirUpCrs, 90.0f);
            cam.update();
            this.renderFace(this.yPosFb, camera, sgr, ppb, rw, rh, wh, t);
        }
        if (this.yNegFlag) {
            this.rc.cubemapSide = RenderingContext.CubemapSide.SIDE_DOWN;
            cam.direction.set(this.dirEffective).rotate(this.dirUpCrs, -90.0f);
            cam.up.set(this.upEffective).rotate(this.dirUpCrs, -90.0f);
            cam.update();
            this.renderFace(this.yNegFb, camera, sgr, ppb, rw, rh, wh, t);
        }
        if (this.zPosFlag) {
            this.rc.cubemapSide = RenderingContext.CubemapSide.SIDE_FRONT;
            cam.direction.set(this.dirEffective);
            cam.up.set(this.upEffective);
            cam.update();
            this.renderFace(this.zPosFb, camera, sgr, ppb, rw, rh, wh, t);
        }
        if (this.zNegFlag) {
            this.rc.cubemapSide = RenderingContext.CubemapSide.SIDE_BACK;
            cam.up.set(this.upEffective);
            cam.direction.set(this.dirEffective).rotate(this.upEffective, -180.0f);
            cam.update();
            this.renderFace(this.zNegFb, camera, sgr, ppb, rw, rh, wh, t);
        }
        cam.direction.set(this.dirBackup);
        cam.up.set(this.upBackup);
        this.rc.cubemapSide = RenderingContext.CubemapSide.SIDE_NONE;
    }

    protected void postRender(FrameBuffer fb) {
        if (fb != null) {
            fb.end();
        }
        Gdx.gl.glActiveTexture(33984);
        EventManager.publish(Event.FOV_CHANGED_CMD, this, Float.valueOf(this.fovBackup));
    }

    protected void renderFace(FrameBuffer fb, ICamera camera, ISceneRenderer sgr, IPostProcessor.PostProcessBean ppb, int rw, int rh, int wh, double t) {
        this.renderRegularFace90(fb, camera, sgr, ppb, rw, rh, wh, t);
    }

    protected void renderRegularFace45(FrameBuffer fb, ICamera camera, ISceneRenderer sgr, IPostProcessor.PostProcessBean ppb, int rw, int rh, int wh, double t) {
        FrameBuffer tlFb = this.getFrameBuffer(wh /= 2, wh, 10);
        FrameBuffer blFb = this.getFrameBuffer(wh, wh, 11);
        FrameBuffer trFb = this.getFrameBuffer(wh, wh, 12);
        FrameBuffer brFb = this.getFrameBuffer(wh, wh, 13);
        float fov = 45.0f;
        float fov2 = fov / 2.0f;
        EventManager.publish(Event.FOV_CHANGED_CMD, this, Float.valueOf(fov));
        PerspectiveCamera cam = camera.getCamera();
        Vector3 upBak = this.aux2.set(cam.up);
        Vector3 dirBak = this.aux3.set(cam.direction);
        cam.direction.rotate(upBak, fov2);
        Vector3 dirUpX = this.aux1.set(cam.direction).crs(upBak);
        cam.direction.rotate(dirUpX, fov2);
        cam.up.rotate(dirUpX, fov2);
        cam.update();
        this.renderFacePart(tlFb, camera, sgr, ppb, rw, rh, wh, t);
        cam.direction.rotate(dirUpX, -fov);
        cam.up.rotate(dirUpX, -fov);
        cam.update();
        this.renderFacePart(blFb, camera, sgr, ppb, rw, rh, wh, t);
        cam.direction.set(dirBak);
        cam.up.set(upBak);
        cam.direction.rotate(upBak, -fov2);
        dirUpX = this.aux1.set(cam.direction).crs(upBak);
        cam.direction.rotate(dirUpX, fov2);
        cam.up.rotate(dirUpX, fov2);
        cam.update();
        this.renderFacePart(trFb, camera, sgr, ppb, rw, rh, wh, t);
        cam.direction.rotate(dirUpX, -fov);
        cam.up.rotate(dirUpX, -fov);
        cam.update();
        this.renderFacePart(brFb, camera, sgr, ppb, rw, rh, wh, t);
        this.mosaic.setViewportSize(wh, wh);
        this.mosaic.setTiles(tlFb, blFb, trFb, brFb);
        this.mosaic.render(null, fb, null);
        cam.direction.set(dirBak);
        cam.up.set(upBak);
        cam.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFacePart(FrameBuffer fb, ICamera camera, ISceneRenderer sgr, IPostProcessor.PostProcessBean ppb, int rw, int rh, int wh, double t) {
        sgr.getLightGlowPass().render(camera, new Object[0]);
        boolean postProcess = this.postProcessCapture(ppb, fb, wh, wh, ppb::captureCubemap);
        try {
            sgr.renderScene(camera, t, this.rc);
        }
        finally {
            this.sendOrientationUpdate(camera.getCamera(), rw, rh);
            this.postProcessRender(ppb, fb, postProcess, camera, rw, rh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderRegularFace90(FrameBuffer fb, ICamera camera, ISceneRenderer sgr, IPostProcessor.PostProcessBean ppb, int rw, int rh, int wh, double t) {
        sgr.getLightGlowPass().render(camera, new Object[0]);
        boolean postProcess = this.postProcessCapture(ppb, fb, wh, wh, ppb::captureCubemap);
        try {
            sgr.renderScene(camera, t, this.rc);
        }
        finally {
            this.sendOrientationUpdate(camera.getCamera(), rw, rh);
            this.postProcessRender(ppb, fb, postProcess, camera, rw, rh);
        }
    }

    protected int getKey(int w, int h, int extra) {
        return w * 100 + h * 10 + extra;
    }

    protected FrameBuffer getFrameBuffer(int w, int h) {
        return this.getFrameBuffer(w, h, 0);
    }

    protected FrameBuffer getFrameBuffer(int w, int h, int extra) {
        int key = this.getKey(w, h, extra);
        if (!this.frameBufferCubeMap.containsKey(key)) {
            this.frameBufferCubeMap.put(key, new FrameBuffer(Pixmap.Format.RGB888, w, h, true));
        }
        return this.frameBufferCubeMap.get(key);
    }
}

