/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.process;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.api.IPostProcessor;
import gaiasky.render.api.IRenderMode;
import gaiasky.render.api.ISceneRenderer;
import gaiasky.render.postprocess.effects.CubmeapProjectionEffect;
import gaiasky.render.postprocess.effects.WarpingMesh;
import gaiasky.render.postprocess.filters.CopyFilter;
import gaiasky.render.process.RenderModeCubemap;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.gdx.loader.WarpMeshReader;
import gaiasky.util.i18n.I18n;
import gaiasky.util.screenshot.ImageRenderer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;

public class RenderModeCubemapProjections
extends RenderModeCubemap
implements IRenderMode,
IObserver {
    private static final Logger.Log logger = Logger.getLogger(RenderModeCubemapProjections.class);
    private final CubmeapProjectionEffect cubemapProjection;
    private WarpingMesh geometryWarp;
    private final CopyFilter copyFilter;

    public RenderModeCubemapProjections() {
        Settings.ProgramSettings.ModeCubemapSettings cubemapSettings = Settings.settings.program.modeCubemap;
        this.initializeGeometryWarp(cubemapSettings.planetarium.sphericalMirrorWarp);
        this.cubemapProjection = new CubmeapProjectionEffect(0.0f, 0.0f);
        this.setPlanetariumAngle(Settings.settings.program.modeCubemap.planetarium.angle);
        this.setPlanetariumAperture(Settings.settings.program.modeCubemap.planetarium.aperture);
        this.setProjection(Settings.settings.program.modeCubemap.projection);
        this.setCelestialSphereIndexOfRefraction(Settings.settings.program.modeCubemap.celestialSphereIndexOfRefraction);
        this.copyFilter = new CopyFilter();
        EventManager.instance.subscribe((IObserver)this, Event.CUBEMAP_RESOLUTION_CMD, Event.CUBEMAP_PROJECTION_CMD, Event.PLANETARIUM_PROJECTION_CMD, Event.CUBEMAP_CMD, Event.PLANETARIUM_APERTURE_CMD, Event.PLANETARIUM_ANGLE_CMD, Event.INDEXOFREFRACTION_CMD, Event.PLANETARIUM_GEOMETRYWARP_FILE_CMD, Event.SCREENSHOT_CUBEMAP_CMD);
    }

    private void setProjection(CubmeapProjectionEffect.CubemapProjection projection) {
        if (this.cubemapProjection != null) {
            this.cubemapProjection.setProjection(projection);
        }
        if (projection.isPlanetarium()) {
            this.xPosFlag = true;
            this.xNegFlag = true;
            this.yPosFlag = true;
            this.yNegFlag = true;
            this.zPosFlag = true;
            assert (this.cubemapProjection != null);
            this.zNegFlag = this.cubemapProjection.getPlanetariumAperture() > 180.0f;
            this.setPlanetariumAngle(Settings.settings.program.modeCubemap.planetarium.angle);
        } else {
            this.xPosFlag = true;
            this.xNegFlag = true;
            this.yPosFlag = true;
            this.yNegFlag = true;
            this.zPosFlag = true;
            this.zNegFlag = true;
            this.setPlanetariumAngle(0.0f);
        }
    }

    private void setPlanetariumAngle(float planetariumAngle) {
        this.angleFromZenith = planetariumAngle;
    }

    private void setPlanetariumAperture(float planetariumAperture) {
        this.cubemapProjection.setPlanetariumAperture(planetariumAperture);
    }

    private void setCelestialSphereIndexOfRefraction(float ior) {
        this.cubemapProjection.setCelestialSphereIndexOfRefraction(ior);
    }

    @Override
    public void render(ISceneRenderer sgr, ICamera camera, double t, int rw, int rh, int tw, int th, FrameBuffer fb, IPostProcessor.PostProcessBean ppb) {
        super.renderCubemapSides(sgr, camera, t, rw, rh, ppb);
        if (this.cubemapProjection.getProjection().isSphericalMirror() && this.geometryWarp != null) {
            FrameBuffer middleBuffer = this.getFrameBuffer(rw, rh, 1);
            this.resultBuffer = fb == null ? this.getFrameBuffer(rw, rh, 0) : fb;
            this.cubemapProjection.setViewportSize(tw, th);
            this.cubemapProjection.setSides(this.xPosFb, this.xNegFb, this.yPosFb, this.yNegFb, this.zPosFb, this.zNegFb);
            this.cubemapProjection.render(null, middleBuffer, null);
            this.geometryWarp.setViewportSize(tw, th);
            this.geometryWarp.render(middleBuffer, this.resultBuffer, null);
        } else {
            this.resultBuffer = fb == null ? this.getFrameBuffer(rw, rh, 0) : fb;
            this.cubemapProjection.setViewportSize(tw, th);
            this.cubemapProjection.setSides(this.xPosFb, this.xNegFb, this.yPosFb, this.yNegFb, this.zPosFb, this.zNegFb);
            this.cubemapProjection.render(null, this.resultBuffer, null);
        }
        if (fb == null) {
            ((CopyFilter)((CopyFilter)this.copyFilter.setInput(this.resultBuffer)).setOutput(null)).render();
        }
        super.postRender(fb);
    }

    @Override
    public void resize(int rw, int rh, int tw, int th) {
        if (this.geometryWarp != null) {
            this.geometryWarp.setViewportSize(rw, rh);
        }
    }

    public void dispose() {
        Set keySet = this.frameBufferCubeMap.keySet();
        for (Integer key : keySet) {
            ((FrameBuffer)this.frameBufferCubeMap.get(key)).dispose();
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (!Settings.settings.runtime.openXr) {
            switch (event) {
                case CUBEMAP_CMD: {
                    CubmeapProjectionEffect.CubemapProjection projection = (CubmeapProjectionEffect.CubemapProjection)((Object)data[1]);
                    GaiaSky.postRunnable(() -> this.setProjection(projection));
                    break;
                }
                case CUBEMAP_PROJECTION_CMD: 
                case PLANETARIUM_PROJECTION_CMD: {
                    CubmeapProjectionEffect.CubemapProjection projection = (CubmeapProjectionEffect.CubemapProjection)((Object)data[0]);
                    GaiaSky.postRunnable(() -> this.setProjection(projection));
                    break;
                }
                case CUBEMAP_RESOLUTION_CMD: {
                    int res = (Integer)data[0];
                    GaiaSky.postRunnable(() -> {
                        if (!this.frameBufferCubeMap.containsKey(this.getKey(res, res, 0))) {
                            this.dispose();
                            this.frameBufferCubeMap.clear();
                        }
                    });
                    break;
                }
                case PLANETARIUM_APERTURE_CMD: {
                    GaiaSky.postRunnable(() -> {
                        this.setPlanetariumAperture(((Float)data[0]).floatValue());
                        this.setProjection(Settings.settings.program.modeCubemap.projection);
                    });
                    break;
                }
                case PLANETARIUM_ANGLE_CMD: {
                    this.setPlanetariumAngle(((Float)data[0]).floatValue());
                    break;
                }
                case INDEXOFREFRACTION_CMD: {
                    GaiaSky.postRunnable(() -> this.setCelestialSphereIndexOfRefraction(((Float)data[0]).floatValue()));
                    break;
                }
                case PLANETARIUM_GEOMETRYWARP_FILE_CMD: {
                    GaiaSky.postRunnable(() -> this.initializeGeometryWarp((Path)data[0]));
                    break;
                }
                case SCREENSHOT_CUBEMAP_CMD: {
                    if (GaiaSky.instance.sceneRenderer.isCubemapRenderMode()) {
                        Path directory = Path.of((String)data[0], new String[0]);
                        String date = RenderModeCubemapProjections.getCurrentTimeStamp();
                        String name = "_cubemap_";
                        GaiaSky.postRunnable(() -> {
                            this.saveFrameBufferToImage(this.zPosFb, directory, date + name + "zp");
                            this.saveFrameBufferToImage(this.zNegFb, directory, date + name + "zm");
                            this.saveFrameBufferToImage(this.xPosFb, directory, date + name + "xp");
                            this.saveFrameBufferToImage(this.xNegFb, directory, date + name + "xm");
                            this.saveFrameBufferToImage(this.yPosFb, directory, date + name + "yp");
                            this.saveFrameBufferToImage(this.yNegFb, directory, date + name + "ym");
                            Logger.getLogger(RenderModeCubemap.class).info(I18n.msg("gui.360.screenshot.ok", directory.resolve(date + name + "[...]")));
                        });
                        break;
                    }
                    Logger.getLogger(RenderModeCubemap.class).warn(I18n.msg("gui.360.screenshot.nomode"));
                    break;
                }
            }
        }
    }

    private static String getCurrentTimeStamp() {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date now = new Date();
        return sdfDate.format(now);
    }

    private void saveFrameBufferToImage(FrameBuffer fb, Path location, String filename) {
        Settings settings = Settings.settings;
        fb.begin();
        ImageRenderer.renderToImageGl20(location.toString(), filename, fb.getWidth(), fb.getHeight(), settings.screenshot.format, settings.screenshot.quality);
        fb.end();
    }

    private void initializeGeometryWarp(Path file) {
        if (file != null && Files.exists(file, new LinkOption[0])) {
            WarpMeshReader.WarpMesh warp = WarpMeshReader.readWarpMeshAscii(Gdx.files.absolute(file.toString()));
            this.geometryWarp = new WarpingMesh(warp, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            logger.info("Spherical mirror geometry warp initialized with: " + file.toString());
        }
    }
}

