/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.process;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.api.IPostProcessor;
import gaiasky.render.api.IRenderMode;
import gaiasky.render.api.ISceneRenderer;
import gaiasky.render.process.RenderModeAbstract;
import gaiasky.scene.Archetype;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.VRDevice;
import gaiasky.scene.record.ModelComponent;
import gaiasky.util.RenderUtils;
import gaiasky.util.gdx.g2d.ExtSpriteBatch;
import gaiasky.util.gdx.graphics.TextureView;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.vr.openxr.XrDriver;
import gaiasky.vr.openxr.XrRenderer;
import gaiasky.vr.openxr.XrViewManager;
import gaiasky.vr.openxr.input.XrControllerDevice;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.GL30;
import org.lwjgl.openxr.XrCompositionLayerProjectionView;
import org.lwjgl.openxr.XrSwapchainImageOpenGLKHR;

public class RenderModeOpenXR
extends RenderModeAbstract
implements IRenderMode,
XrRenderer {
    private final Scene scene;
    private final XrDriver driver;
    private final XrViewManager viewManager;
    public Array<Entity> controllerObjects;
    private final Map<XrControllerDevice, Entity> vrDeviceToModel;
    private Environment controllersEnvironment;
    private TextureView textureView;
    private ExtSpriteBatch sbScreen;
    private Vector2 lastSize;
    private ISceneRenderer sgr;
    private ICamera camera;
    private IPostProcessor.PostProcessBean ppb;
    private int rw;
    private int rh;
    private double t;

    public RenderModeOpenXR(Scene scene, XrDriver xrDriver, ExtSpriteBatch spriteBatch) {
        this.scene = scene;
        this.driver = xrDriver;
        this.viewManager = new XrViewManager();
        this.vrDeviceToModel = new HashMap<XrControllerDevice, Entity>();
        if (xrDriver != null) {
            this.textureView = new TextureView(0, xrDriver.getWidth(), xrDriver.getHeight());
            this.lastSize = new Vector2();
            Array<XrControllerDevice> controllers = xrDriver.getControllerDevices();
            this.controllersEnvironment = new Environment();
            this.controllersEnvironment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, 0.6f, 0.6f, 0.6f, 1.0f));
            DirectionalLight directionalLight = new DirectionalLight();
            directionalLight.color.set(1.0f, 1.0f, 1.0f, 1.0f);
            directionalLight.direction.set(0.0f, -0.3f, -4.0f);
            this.controllersEnvironment.add(directionalLight);
            this.controllerObjects = new Array(false, controllers.size);
            for (XrControllerDevice controller : controllers) {
                if (!controller.isInitialized()) {
                    controller.initialize(xrDriver);
                }
                this.addVRController(controller);
            }
            this.sbScreen = spriteBatch;
            this.driver.setRenderer(this);
        }
    }

    @Override
    public void render(ISceneRenderer sgr, ICamera camera, double t, int rw, int rh, int tw, int th, FrameBuffer fb, IPostProcessor.PostProcessBean ppb) {
        if (this.driver != null && !this.driver.getLastPollEventsResult()) {
            this.rc.ppb = null;
            for (Entity controller : this.controllerObjects) {
                Model model = (Model)Mapper.model.get(controller);
                if (model.model.instance == null) continue;
                this.scene.extractEntity(controller);
            }
            if (this.driver.isRunning() && this.driver.hasRenderer()) {
                this.sgr = sgr;
                this.camera = camera;
                this.ppb = ppb;
                this.rw = rw;
                this.rh = rh;
                this.t = t;
                this.driver.renderFrameOpenXR();
            }
        }
    }

    @Override
    public void renderOpenXRView(XrCompositionLayerProjectionView layerView, XrSwapchainImageOpenGLKHR swapchainImage, FrameBuffer frameBuffer, int viewIndex) {
        this.rc.ppb = null;
        this.sgr.getLightGlowPass().render(this.camera, this.sgr.getGlowFrameBuffer());
        this.viewManager.updateCamera(layerView, this.camera.getCamera(), (NaturalCamera)this.camera.getCurrent(), this.rc);
        boolean postProcess = this.postProcessCapture(this.ppb, frameBuffer, this.rw, this.rh, this.ppb::captureVR);
        this.sgr.renderScene(this.camera, this.t, this.rc);
        this.camera.render(this.rw, this.rh);
        this.sendOrientationUpdate(this.camera.getCamera(), this.rw, this.rh);
        frameBuffer.begin();
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)swapchainImage.image(), (int)0);
        frameBuffer.end();
        this.postProcessRender(this.ppb, frameBuffer, postProcess, this.camera, this.rw, this.rh);
        if (viewIndex == 0) {
            this.textureView.setTexture(swapchainImage.image(), this.driver.getWidth(), this.driver.getHeight());
            Gdx.gl.glEnable(36281);
            RenderUtils.renderKeepAspect(this.textureView, this.sbScreen, Gdx.graphics, this.lastSize);
            Gdx.gl.glDisable(36281);
        }
    }

    @Override
    public void resize(int rw, int rh, int tw, int th) {
        if (this.lastSize != null) {
            this.lastSize.set(-1.0f, -1.0f);
        }
    }

    private Entity newVRDeviceModelEntity(XrControllerDevice device, Environment environment) {
        Archetype archetype = this.scene.archetypes().get("gaiasky.scenegraph.VRDeviceModel");
        Entity entity = archetype.createEntity();
        VRDevice vr = (VRDevice)Mapper.vr.get(entity);
        vr.device = device;
        Model model = (Model)Mapper.model.get(entity);
        model.model = new ModelComponent();
        model.model.env = environment;
        this.scene.initializeEntity(entity);
        this.scene.setUpEntity(entity);
        this.scene.engine.addEntity(entity);
        EventManager.publish(Event.SCENE_ADD_OBJECT_CMD, this, entity, false);
        return entity;
    }

    private void addVRController(XrControllerDevice device) {
        if (!this.vrDeviceToModel.containsKey(device)) {
            Entity entity = this.newVRDeviceModelEntity(device, this.controllersEnvironment);
            this.controllerObjects.add((Object)entity);
            this.vrDeviceToModel.put(device, entity);
        }
    }

    private void removeVRController(XrControllerDevice device) {
        if (this.vrDeviceToModel.containsKey(device)) {
            Entity entity = this.vrDeviceToModel.get(device);
            this.controllerObjects.removeValue((Object)entity, true);
            this.vrDeviceToModel.remove(device);
        }
    }

    public Map<XrControllerDevice, Entity> getXRControllerToModel() {
        return this.vrDeviceToModel;
    }

    public void dispose() {
    }
}

