/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.process;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.viewport.StretchViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.api.IPostProcessor;
import gaiasky.render.api.IRenderMode;
import gaiasky.render.api.ISceneRenderer;
import gaiasky.render.postprocess.effects.AnaglyphEffect;
import gaiasky.render.postprocess.filters.CopyFilter;
import gaiasky.render.process.RenderModeAbstract;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.math.Vector3D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jafama.FastMath;

public class RenderModeStereoscopic
extends RenderModeAbstract
implements IRenderMode,
IObserver {
    private static final double EYE_ANGLE_DEG = 1.5;
    private final Viewport stretchViewport = new StretchViewport((float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
    private final SpriteBatch sb;
    private final AnaglyphEffect anaglyphEffect;
    private final CopyFilter copyFilter;
    private final Vector3 aux1;
    private final Vector3 aux2;
    private final Vector3 aux3;
    private final Vector3D aux1d;
    private final Vector3D aux2d;
    private final Vector3D aux3d;
    private final Vector3D aux4d;
    private final Vector3D aux5d;
    Map<Integer, FrameBuffer> fb3D;

    public RenderModeStereoscopic(SpriteBatch spriteBatch) {
        this.sb = spriteBatch;
        this.fb3D = new HashMap<Integer, FrameBuffer>();
        this.fb3D.put(this.getKey(Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight()), new FrameBuffer(Pixmap.Format.RGB888, Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight(), true));
        this.anaglyphEffect = new AnaglyphEffect();
        this.updateAnaglyphMode();
        this.copyFilter = new CopyFilter();
        this.aux1 = new Vector3();
        this.aux2 = new Vector3();
        this.aux3 = new Vector3();
        this.aux1d = new Vector3D();
        this.aux2d = new Vector3D();
        this.aux3d = new Vector3D();
        this.aux4d = new Vector3D();
        this.aux5d = new Vector3D();
        EventManager.instance.subscribe((IObserver)this, Event.FRAME_SIZE_UPDATE, Event.SCREENSHOT_SIZE_UPDATE);
    }

    public void updateAnaglyphMode() {
        if (this.anaglyphEffect != null) {
            this.anaglyphEffect.setAnaglyphMode(Settings.settings.program.modeStereo.profile.getAnaglyphModeInteger());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(ISceneRenderer sgr, ICamera camera, double t, int rw, int rh, int tw, int th, FrameBuffer fb, IPostProcessor.PostProcessBean ppb) {
        double separationCapped;
        boolean moveCam = camera.getMode() == CameraManager.CameraMode.FREE_MODE || camera.getMode() == CameraManager.CameraMode.FOCUS_MODE || camera.getMode() == CameraManager.CameraMode.SPACECRAFT_MODE;
        PerspectiveCamera perspectiveCam = camera.getCamera();
        double separation = Constants.M_TO_U * (double)Settings.settings.program.modeStereo.eyeSeparation;
        double dirAngleDeg = 0.0;
        IFocus currentFocus = null;
        if (camera.getMode() == CameraManager.CameraMode.FOCUS_MODE) {
            currentFocus = camera.getFocus();
        } else if (camera.getCurrent().getClosestBody() != null) {
            currentFocus = camera.getCurrent().getClosestBody();
        }
        if (currentFocus != null) {
            double distToFocus = currentFocus.getDistToCamera() - currentFocus.getRadius();
            separation = FastMath.tan((double)Math.toRadians(1.5)) * distToFocus;
            separationCapped = FastMath.min((double)separation, (double)(10.0 * Constants.M_TO_U));
            dirAngleDeg = 1.5;
        } else {
            separationCapped = FastMath.min((double)separation, (double)(10.0 * Constants.M_TO_U));
        }
        this.aux5d.set(camera.getDirection()).crs(camera.getUp()).nor();
        Vector3D side = this.aux4d.set(this.aux5d).nor().scl(separation);
        Vector3D sideRemainder = this.aux2d.set(this.aux5d).scl(separation - separationCapped);
        Vector3D sideCapped = this.aux3d.set(this.aux5d).nor().scl(separationCapped);
        Vector3 backupPos = this.aux2.set(perspectiveCam.position);
        Vector3 backupDir = this.aux3.set(perspectiveCam.direction);
        Vector3D backupPosd = this.aux1d.set(camera.getPos());
        if (Settings.settings.program.modeStereo.profile.isAnaglyph()) {
            this.extendViewport.setCamera((Camera)camera.getCamera());
            this.extendViewport.setWorldSize((float)rw, (float)rh);
            this.extendViewport.setScreenBounds(0, 0, rw, rh);
            this.extendViewport.apply();
            if (moveCam) {
                this.moveCamera(camera, sideRemainder, side, sideCapped, dirAngleDeg, false);
            }
            camera.setCameraStereoLeft(perspectiveCam);
            sgr.getLightGlowPass().render(camera, new Object[0]);
            FrameBuffer fb1 = this.getFrameBuffer(rw, rh, 1);
            boolean postProcess = this.postProcessCapture(ppb, fb1, tw, th, ppb::capture);
            try {
                sgr.renderScene(camera, t, this.rc);
            }
            finally {
                this.sendOrientationUpdate(perspectiveCam, rw, rh);
                this.postProcessRender(ppb, fb1, postProcess, camera, rw, rh);
            }
            Texture texLeft = (Texture)fb1.getColorBufferTexture();
            if (moveCam) {
                this.restoreCameras(camera, perspectiveCam, backupPosd, backupPos, backupDir);
                this.moveCamera(camera, sideRemainder, side, sideCapped, dirAngleDeg, true);
            }
            camera.setCameraStereoRight(perspectiveCam);
            sgr.getLightGlowPass().render(camera, new Object[0]);
            FrameBuffer fb2 = this.getFrameBuffer(rw, rh, 2);
            postProcess = this.postProcessCapture(ppb, fb2, tw, th, ppb::capture);
            try {
                sgr.renderScene(camera, t, this.rc);
            }
            finally {
                this.sendOrientationUpdate(perspectiveCam, rw, rh);
                this.postProcessRender(ppb, fb2, postProcess, camera, rw, rh);
            }
            Texture texRight = (Texture)fb2.getColorBufferTexture();
            this.updateAnaglyphMode();
            this.anaglyphEffect.setTextureLeft(texLeft);
            this.anaglyphEffect.setTextureRight(texRight);
            this.anaglyphEffect.render(null, this.resultBuffer, null);
            this.resultBuffer.end();
            Gdx.gl.glActiveTexture(33984);
        } else {
            double start2h;
            double start2w;
            double boundsh;
            double boundsw;
            double srh;
            double srw;
            boolean changeSides;
            float unitsPerPixel = GaiaSky.instance.getUnitsPerPixel();
            boolean stretch = Settings.settings.program.modeStereo.profile == Settings.StereoProfile.HORIZONTAL_3DTV || Settings.settings.program.modeStereo.profile == Settings.StereoProfile.VERTICAL_3DTV;
            boolean bl = changeSides = Settings.settings.program.modeStereo.profile == Settings.StereoProfile.CROSSEYE;
            if (Settings.settings.program.modeStereo.profile.isHorizontal()) {
                srw = stretch ? (double)rw : (double)(rw / 2);
                srh = rh;
                boundsw = rw / 2;
                boundsh = rh;
                start2w = boundsw;
                start2h = 0.0;
            } else {
                srh = stretch ? (double)rh : (double)(rh / 2);
                srw = rw;
                boundsw = rw;
                boundsh = rh / 2;
                start2w = 0.0;
                start2h = boundsh;
            }
            boundsw *= (double)unitsPerPixel;
            boundsh *= (double)unitsPerPixel;
            start2w *= (double)unitsPerPixel;
            start2h *= (double)unitsPerPixel;
            boundsw /= Settings.settings.graphics.backBufferScale;
            boundsh /= Settings.settings.graphics.backBufferScale;
            start2w /= Settings.settings.graphics.backBufferScale;
            start2h /= Settings.settings.graphics.backBufferScale;
            Viewport viewport = stretch ? this.stretchViewport : this.extendViewport;
            viewport.setCamera((Camera)camera.getCamera());
            viewport.setWorldSize((float)srw, (float)srh);
            viewport.setScreenBounds(0, 0, (int)boundsw, (int)boundsh);
            viewport.apply();
            if (moveCam) {
                this.moveCamera(camera, sideRemainder, side, sideCapped, dirAngleDeg, changeSides);
            }
            camera.setCameraStereoLeft(perspectiveCam);
            sgr.getLightGlowPass().render(camera, new Object[0]);
            FrameBuffer fb3d = this.getFrameBuffer((int)boundsw, (int)boundsh, 3);
            boolean postProcess = this.postProcessCapture(ppb, fb3d, (int)boundsw, (int)boundsh, ppb::capture);
            sgr.renderScene(camera, t, this.rc);
            this.sendOrientationUpdate(perspectiveCam, rw, rh);
            this.postProcessRender(ppb, fb3d, postProcess, camera, (int)boundsw, (int)boundsh);
            Texture tex = (Texture)fb3d.getColorBufferTexture();
            this.resultBuffer = fb == null ? this.getFrameBuffer(rw, rh, 0) : fb;
            this.resultBuffer.begin();
            this.sb.begin();
            this.sb.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.sb.draw(tex, 0.0f, 0.0f, 0.0f, 0.0f, (float)boundsw, (float)boundsh, 1.0f, 1.0f, 0.0f, 0, 0, (int)boundsw, (int)boundsh, false, true);
            this.sb.end();
            this.resultBuffer.end();
            viewport.setScreenBounds((int)start2w, (int)start2h, (int)boundsw, (int)boundsh);
            viewport.apply();
            if (moveCam) {
                this.restoreCameras(camera, perspectiveCam, backupPosd, backupPos, backupDir);
                this.moveCamera(camera, sideRemainder, side, sideCapped, dirAngleDeg, !changeSides);
            }
            camera.setCameraStereoRight(perspectiveCam);
            sgr.getLightGlowPass().render(camera, new Object[0]);
            postProcess = this.postProcessCapture(ppb, fb3d, (int)boundsw, (int)boundsh, ppb::capture);
            sgr.renderScene(camera, t, this.rc);
            this.sendOrientationUpdate(perspectiveCam, rw, rh);
            this.postProcessRender(ppb, fb3d, postProcess, camera, (int)boundsw, (int)boundsh);
            tex = (Texture)fb3d.getColorBufferTexture();
            this.resultBuffer = fb == null ? this.getFrameBuffer(rw, rh, 0) : fb;
            this.resultBuffer.begin();
            this.sb.begin();
            this.sb.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.sb.draw(tex, (float)start2w, (float)start2h, 0.0f, 0.0f, (float)boundsw, (float)boundsh, 1.0f, 1.0f, 0.0f, 0, 0, (int)boundsw, (int)boundsh, false, true);
            this.sb.end();
            this.resultBuffer.end();
            viewport.setScreenBounds(0, 0, rw, rh);
        }
        this.restoreCameras(camera, perspectiveCam, backupPosd, backupPos, backupDir);
        if (fb == null) {
            ((CopyFilter)((CopyFilter)this.copyFilter.setInput(this.resultBuffer)).setOutput(null)).render();
        }
    }

    private void restoreCameras(ICamera camera, PerspectiveCamera cam, Vector3D backupPosd, Vector3 backupPos, Vector3 backupDir) {
        camera.setPos(backupPosd);
        cam.position.set(backupPos);
        cam.direction.set(backupDir);
    }

    private void moveCamera(ICamera camera, Vector3D sideRemainder, Vector3D side, Vector3D sideCapped, double angle, boolean switchSides) {
        PerspectiveCamera cam = camera.getCamera();
        Vector3 sideFloat = sideCapped.put(this.aux1);
        if (switchSides) {
            cam.position.add(sideFloat);
            cam.direction.rotate(cam.up, (float)(-angle));
            camera.getPos().add(sideRemainder);
        } else {
            cam.position.sub(sideFloat);
            cam.direction.rotate(cam.up, (float)angle);
            camera.getPos().sub(sideRemainder);
        }
        cam.update();
    }

    private int getKey(int w, int h) {
        return this.getKey(w, h, 0);
    }

    private int getKey(int w, int h, int extra) {
        return 31 * (31 * h + w) + extra;
    }

    private FrameBuffer getFrameBuffer(int w, int h, int extra) {
        int key = this.getKey(w, h, extra);
        if (!this.fb3D.containsKey(key)) {
            this.fb3D.put(key, new FrameBuffer(Pixmap.Format.RGB888, w, h, true));
        }
        return this.fb3D.get(key);
    }

    private FrameBuffer getFrameBuffer(int w, int h) {
        return this.getFrameBuffer(w, h, 0);
    }

    @Override
    public void resize(int rw, int rh, int tw, int th) {
        if (Settings.settings.program.modeStereo.active) {
            this.extendViewport.update(tw, th);
            this.stretchViewport.update(tw, th);
            int keyHalf = this.getKey(tw / 2, th);
            int keyFull = this.getKey(tw, th);
            if (!this.fb3D.containsKey(keyHalf)) {
                this.fb3D.put(keyHalf, new FrameBuffer(Pixmap.Format.RGB888, tw / 2, th, true));
            }
            if (!this.fb3D.containsKey(keyFull)) {
                this.fb3D.put(keyFull, new FrameBuffer(Pixmap.Format.RGB888, tw, th, true));
            }
            Iterator<Map.Entry<Integer, FrameBuffer>> iterator = this.fb3D.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, FrameBuffer> entry = iterator.next();
                if (entry.getKey() == keyHalf || entry.getKey() == keyFull) continue;
                entry.getValue().dispose();
                iterator.remove();
            }
        }
    }

    private void clearFrameBufferMap() {
        Set<Integer> keySet = this.fb3D.keySet();
        for (Integer key : keySet) {
            FrameBuffer fb = this.fb3D.get(key);
            fb.dispose();
        }
        this.fb3D.clear();
    }

    public void dispose() {
        this.clearFrameBufferMap();
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case SCREENSHOT_SIZE_UPDATE: 
            case FRAME_SIZE_UPDATE: {
                GaiaSky.postRunnable(this::clearFrameBufferMap);
                break;
            }
        }
    }
}

