/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.system;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderGroup;
import gaiasky.render.RenderingContext;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.IRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gravwaves.RelativisticEffectsManager;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3D;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractRenderSystem
implements IRenderSystem,
Comparable<IRenderSystem> {
    private final RenderGroup renderGroup;
    protected final SceneRenderer sceneRenderer;
    protected final ExtShaderProgram[] programs;
    protected final float[] alphas;
    public RenderingContext rc;
    protected Comparator<IRenderable> comp;
    protected Array<RenderSystemRunnable> preRunners;
    protected Array<RenderSystemRunnable> postRunners;
    private boolean vrScaleFlag = false;
    private boolean depthBufferFlag = false;
    private boolean unitsFlag = false;
    protected final Vector3 aux3f = new Vector3();
    private final Vector3D smoothedCamVel = new Vector3D(0.0, 0.0, 0.0);

    protected AbstractRenderSystem(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] programs) {
        this.sceneRenderer = sceneRenderer;
        this.renderGroup = rg;
        this.alphas = alphas;
        this.programs = programs;
        this.preRunners = new Array(false, 1);
        this.postRunners = new Array(false, 1);
    }

    @Override
    public RenderGroup getRenderGroup() {
        return this.renderGroup;
    }

    @Override
    public void render(List<IRenderable> renderables, ICamera camera, double t, RenderingContext rc) {
        if (renderables != null && !renderables.isEmpty()) {
            this.rc = rc;
            this.run(this.preRunners, renderables, camera);
            this.renderStud(renderables, camera, t);
            this.run(this.postRunners, renderables, camera);
        }
    }

    public abstract void renderStud(List<IRenderable> var1, ICamera var2, double var3);

    public void addPreRunnables(RenderSystemRunnable ... r) {
        this.preRunners.addAll((Object[])r);
    }

    public void addPostRunnables(RenderSystemRunnable ... r) {
        this.postRunners.addAll((Object[])r);
    }

    protected void run(Array<RenderSystemRunnable> runnables, List<IRenderable> renderables, ICamera camera) {
        if (runnables != null) {
            for (RenderSystemRunnable runnable : runnables) {
                runnable.run(this, renderables, camera);
            }
        }
    }

    public float getAlpha(IRenderable renderable) {
        return this.getAlpha(renderable.getComponentType());
    }

    public float getAlpha(Entity entity) {
        return this.getAlpha(((Base)Mapper.base.get((Entity)entity)).ct);
    }

    public float getAlpha(ComponentTypes ct) {
        int idx = -1;
        float alpha = 1.0f;
        while ((idx = ct.nextSetBit(idx + 1)) >= 0) {
            alpha *= this.alphas[idx];
        }
        return alpha;
    }

    @Override
    public void resize(int w, int h) {
    }

    @Override
    public void updateBatchSize(int w, int h) {
    }

    protected void addEffectsUniforms(ExtShaderProgram shaderProgram, ICamera camera) {
        this.addRelativisticUniforms(shaderProgram, camera);
        this.addGravWaveUniforms(shaderProgram);
        this.addDepthBufferUniforms(shaderProgram, camera);
        this.addVRScale(shaderProgram);
    }

    private void updateCameraVelocity(Vector3D rawVel, double deltaTime) {
        double tau = 0.1;
        double alpha = 1.0 - Math.exp(-deltaTime / tau);
        this.smoothedCamVel.lerp(rawVel, alpha);
    }

    protected void addMotionTrailsUniforms(ExtShaderProgram shaderProgram, ICamera camera) {
        if (!this.unitsFlag) {
            shaderProgram.setUniformf("u_uToMpc", (float)(Constants.U_TO_PC * 1.0E-6));
            this.unitsFlag = true;
        }
        this.updateCameraVelocity(camera.getVelocity(), Gdx.graphics.getDeltaTime());
        if (Settings.settings.scene.particleGroups.motionTrails && !camera.isRotating() && this.smoothedCamVel.len() > 1.0E-6) {
            shaderProgram.setUniformf("u_camVel", this.smoothedCamVel);
        } else {
            shaderProgram.setUniformf("u_camVel", 0.0f, 0.0f, 0.0f);
        }
        shaderProgram.setUniformf("u_dt", MathUtilsDouble.clamp(Gdx.graphics.getDeltaTime(), 0.01f, 0.02f));
    }

    protected void addVRScale(ExtShaderProgram shaderProgram) {
        if (!this.vrScaleFlag) {
            shaderProgram.setUniformf("u_vrScale", (float)Constants.DISTANCE_SCALE_FACTOR);
            this.vrScaleFlag = true;
        }
    }

    protected void addRelativisticUniforms(ExtShaderProgram shaderProgram, ICamera camera) {
        if (Settings.settings.runtime.relativisticAberration) {
            RelativisticEffectsManager rem = RelativisticEffectsManager.getInstance();
            shaderProgram.setUniformf("u_velDir", rem.velDir);
            shaderProgram.setUniformf("u_vc", rem.vc);
        }
    }

    protected void addGravWaveUniforms(ExtShaderProgram shaderProgram) {
        if (Settings.settings.runtime.gravitationalWaves) {
            RelativisticEffectsManager rem = RelativisticEffectsManager.getInstance();
            shaderProgram.setUniformf("u_ts", rem.gwtime);
            shaderProgram.setUniformf("u_omgw", rem.omgw);
            shaderProgram.setUniformf("u_gw", rem.gw);
            shaderProgram.setUniformMatrix("u_gwmat3", rem.gwmat3);
            shaderProgram.setUniform4fv("u_hterms", rem.hterms, 0, 4);
        }
    }

    public void addDepthBufferUniforms(ExtShaderProgram shaderProgram, ICamera camera) {
        if (!this.depthBufferFlag) {
            shaderProgram.setUniformf("u_zfar", (float)camera.getFar());
            shaderProgram.setUniformf("u_k", Constants.getCameraK());
            this.depthBufferFlag = true;
        }
    }

    protected void addCameraUpCubemapMode(ExtShaderProgram shaderProgram, ICamera camera) {
        if (Settings.settings.program.modeCubemap.active) {
            shaderProgram.setUniformf("u_camUp", this.aux3f.set(Float.NaN, 0.0f, 0.0f));
        } else {
            shaderProgram.setUniformf("u_camUp", camera.getUp());
        }
    }

    protected ExtShaderProgram getShaderProgram() {
        return this.getShaderProgram(this.programs);
    }

    protected ExtShaderProgram getShaderProgram(ExtShaderProgram[] programs) {
        boolean ssr;
        boolean ra;
        boolean gw = Settings.settings.runtime.gravitationalWaves;
        int num = (gw ? 4 : 0) + ((ra = Settings.settings.runtime.relativisticAberration) ? 2 : 0) + ((ssr = Settings.settings.postprocess.ssr.active) ? 1 : 0);
        ExtShaderProgram program = programs[num];
        if (!program.isCompiled()) {
            program.compile(program.getName());
            this.initShaderProgram();
        }
        return program;
    }

    protected void initShaderProgram() {
    }

    public void dispose() {
        this.preRunners.clear();
        this.preRunners = null;
        this.postRunners.clear();
        this.postRunners = null;
    }

    public void resetFlags() {
        this.vrScaleFlag = false;
        this.depthBufferFlag = false;
    }

    @Override
    public int compareTo(IRenderSystem o) {
        return Integer.compare(this.renderGroup.priority, o.getRenderGroup().priority);
    }

    public static interface RenderSystemRunnable {
        public void run(AbstractRenderSystem var1, List<IRenderable> var2, ICamera var3);
    }
}

