/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.system;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.AbstractRenderSystem;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class ImmediateModeRenderSystem
extends AbstractRenderSystem {
    private final Map<IRenderable, Integer> offsets;
    private final Map<IRenderable, Integer> counts;
    protected int meshIdx;
    protected Array<MeshData> meshes;
    protected MeshData curr;
    protected float[] tempVerts;
    protected int[] tempIndices;
    protected Set<IRenderable> inGpu;
    protected final Matrix4 auxMat = new Matrix4();

    protected ImmediateModeRenderSystem(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] programs) {
        this(sceneRenderer, rg, alphas, programs, -1);
    }

    protected ImmediateModeRenderSystem(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] programs, int tempVertsSize) {
        super(sceneRenderer, rg, alphas, programs);
        this.initShaderProgram();
        this.initVertices();
        this.meshIdx = 0;
        if (tempVertsSize > 0) {
            this.tempVerts = new float[tempVertsSize];
        }
        this.inGpu = new HashSet<IRenderable>();
        this.offsets = new HashMap<IRenderable, Integer>();
        this.counts = new HashMap<IRenderable, Integer>();
    }

    protected int createMeshData() {
        int mdi;
        for (mdi = 0; mdi < this.meshes.size && this.meshes.get(mdi) != null; ++mdi) {
        }
        if (mdi >= this.meshes.size) {
            this.meshes.setSize(mdi + 1);
        }
        this.meshes.set(mdi, (Object)new MeshData());
        return mdi;
    }

    public void clearMeshes() {
        if (this.meshes != null) {
            for (int i = 0; i < this.meshes.size; ++i) {
                this.clearMeshData(i);
            }
            this.meshes.clear();
        }
    }

    public void clearMeshData(int i) {
        try {
            MeshData md = (MeshData)this.meshes.get(i);
            if (md != null && md.mesh != null) {
                md.dispose();
                this.meshes.set(i, null);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected abstract void initVertices();

    protected boolean inGpu(IRenderable renderable) {
        return this.inGpu != null && this.inGpu.contains(renderable);
    }

    protected void setInGpu(IRenderable renderable, boolean state) {
        if (this.inGpu != null) {
            if (state) {
                this.inGpu.add(renderable);
            } else {
                this.inGpu.remove(renderable);
            }
        }
    }

    protected void setOffset(IRenderable renderable, int offset) {
        if (this.offsets != null) {
            if (offset >= 0) {
                this.offsets.put(renderable, offset);
            } else {
                this.offsets.remove(renderable);
            }
        }
    }

    protected int getOffset(IRenderable renderable) {
        if (this.offsets != null && this.offsets.containsKey(renderable)) {
            return this.offsets.get(renderable);
        }
        return -1;
    }

    protected void setCount(IRenderable renderable, int count) {
        if (this.counts != null) {
            this.counts.put(renderable, count);
        }
    }

    protected int getCount(IRenderable renderable) {
        if (this.counts != null && this.counts.containsKey(renderable)) {
            return this.counts.get(renderable);
        }
        return -1;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.inGpu.clear();
        this.offsets.clear();
        this.counts.clear();
        this.clearMeshes();
        this.tempVerts = null;
        this.curr = null;
    }

    protected void ensureTempVertsSize(int size) {
        if (this.tempVerts == null || this.tempVerts.length < size) {
            this.tempVerts = new float[size];
        }
    }

    protected void ensureTempIndicesSize(int size) {
        if (this.tempIndices == null || this.tempIndices.length < size) {
            this.tempIndices = new int[size];
        }
    }

    public void color(Color color) {
        this.curr.vertices[this.curr.vertexIdx + this.curr.colorOffset] = color.toFloatBits();
    }

    public void color(float r, float g, float b, float a) {
        this.curr.vertices[this.curr.vertexIdx + this.curr.colorOffset] = Color.toFloatBits((float)r, (float)g, (float)b, (float)a);
    }

    public void color(double r, double g, double b, double a) {
        this.curr.vertices[this.curr.vertexIdx + this.curr.colorOffset] = Color.toFloatBits((float)((float)r), (float)((float)g), (float)((float)b), (float)((float)a));
    }

    public void color(float colorBits) {
        this.curr.vertices[this.curr.vertexIdx + this.curr.colorOffset] = colorBits;
    }

    public void vertex(float x, float y, float z) {
        this.curr.vertices[this.curr.vertexIdx] = x;
        this.curr.vertices[this.curr.vertexIdx + 1] = y;
        this.curr.vertices[this.curr.vertexIdx + 2] = z;
        this.curr.vertexIdx += this.curr.vertexSize;
        ++this.curr.numVertices;
    }

    protected void addAffineTransformUniforms(ExtShaderProgram program, AffineTransformations affine) {
        if (affine != null && !affine.isEmpty()) {
            program.setUniformi("u_transformFlag", 1);
            affine.apply(this.auxMat.idt());
            program.setUniformMatrix("u_transform", this.auxMat);
        } else {
            program.setUniformi("u_transformFlag", 0);
        }
    }

    public static class MeshData {
        public IntMesh mesh;
        public int colorOffset;
        public int vertexIdx;
        public int vertexSize;
        public float[] vertices;
        public int instanceIdx;
        public int instanceSize;
        public float[] instance;
        public int indexIdx;
        public int numVertices;
        public int capacity;
        protected int indexVert;
        protected int[] indices;

        public void clear() {
            this.instanceIdx = 0;
            this.vertexIdx = 0;
            this.indexIdx = 0;
            this.indexVert = 0;
            this.numVertices = 0;
        }

        public void dispose() {
            if (this.mesh != null) {
                this.mesh.dispose();
            }
            this.vertices = null;
            this.indices = null;
        }
    }

    protected static class OwnUsage {
        public static final int Size = 512;
        public static final int TextureIndex = 612;
        public static final int NumVariablePoints = 1024;
        public static final int VariableMagnitudes = 2048;
        public static final int VariableTimes = 4096;
        public static final int ObjectPosition = 8192;
        public static final int ProperMotion = 16384;
        public static final int Additional = 20000;
        public static final int OrbitElems1 = 21000;
        public static final int OrbitElems2 = 22000;

        protected OwnUsage() {
        }
    }
}

