/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.system;

import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.event.IObserver;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.entity.ParticleUtils;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.util.Bits;
import gaiasky.util.ModelCache;
import gaiasky.util.Pair;
import gaiasky.util.gdx.IcoSphereCreator;
import gaiasky.util.gdx.ModelCreator;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gdx.shader.Material;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class InstancedRenderSystem
extends ImmediateModeRenderSystem
implements IObserver {
    protected Array<InstancedModel> models = new Array(50);
    protected final ParticleUtils utils;

    protected InstancedRenderSystem(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders) {
        super(sceneRenderer, rg, alphas, shaders);
        this.meshes = new Array(20);
        this.utils = new ParticleUtils();
    }

    @Override
    protected void initVertices() {
    }

    public boolean isWireframe(int primitive) {
        return primitive >= 1 && primitive <= 3;
    }

    protected void setModel(int offset, InstancedModel model) {
        if (offset >= 0) {
            this.models.insert(offset, (Object)model);
        }
    }

    protected InstancedModel getModel(ParticleSet set, int offset) {
        return this.getModel(set.model, set.modelType, set.modelParams, set.modelPrimitive, offset);
    }

    protected InstancedModel getModel(IntModel modelFile, String modelType, Map<String, Object> modelParams, int primitive, int offset) {
        InstancedModel model;
        int primitivePlus;
        if (offset >= 0 && this.models.size > offset && this.models.get(offset) != null) {
            return (InstancedModel)this.models.get(offset);
        }
        boolean wireframe = this.isWireframe(primitive);
        int n = primitivePlus = wireframe ? 0 : 2;
        if (modelFile != null) {
            IntMesh mesh = (IntMesh)modelFile.meshes.get(0);
            model = new InstancedModel(mesh);
        } else if (modelType.equalsIgnoreCase("sphere")) {
            float width = 1.0f;
            float height = 1.0f;
            float depth = 1.0f;
            int quality = 30;
            if (wireframe) {
                float angleU;
                float angleV;
                int iv;
                float angleUFrom = 0.0f;
                float angleUTo = 360.0f;
                float angleVFrom = 0.0f;
                float angleVTo = 180.0f;
                float hw = 0.5f;
                float hh = 0.5f;
                float hd = 0.5f;
                float auo = 0.0f;
                float stepU = 0.20943952f;
                float avo = 0.0f;
                float stepV = 0.10471976f;
                float us = 0.033333335f;
                float vs = 0.033333335f;
                model = new InstancedModel(3600, 3);
                int i = 0;
                for (iv = 0; iv < 30; ++iv) {
                    angleV = 0.0f + 0.10471976f * (float)iv;
                    float t = MathUtils.sin((float)angleV);
                    float h = MathUtils.cos((float)angleV) * 0.5f;
                    for (int iu = 0; iu < 30; ++iu) {
                        angleU = 0.0f + 0.20943952f * (float)iu;
                        model.vertices[i++] = MathUtils.cos((float)angleU) * 0.5f * t;
                        model.vertices[i++] = h;
                        model.vertices[i++] = MathUtils.sin((float)angleU) * 0.5f * t;
                        angleU = 0.0f + 0.20943952f * (float)(iu + 1);
                        model.vertices[i++] = MathUtils.cos((float)angleU) * 0.5f * t;
                        model.vertices[i++] = h;
                        model.vertices[i++] = MathUtils.sin((float)angleU) * 0.5f * t;
                    }
                }
                for (iv = 0; iv < 30; ++iv) {
                    for (int iu = 0; iu < 30; ++iu) {
                        angleV = 0.0f + 0.10471976f * (float)iv;
                        float t = MathUtils.sin((float)angleV);
                        float h = MathUtils.cos((float)angleV) * 0.5f;
                        angleU = 0.0f + 0.20943952f * (float)iu;
                        model.vertices[i++] = MathUtils.cos((float)angleU) * 0.5f * t;
                        model.vertices[i++] = h;
                        model.vertices[i++] = MathUtils.sin((float)angleU) * 0.5f * t;
                        angleV = 0.0f + 0.10471976f * (float)(iv + 1);
                        t = MathUtils.sin((float)angleV);
                        h = MathUtils.cos((float)angleV) * 0.5f;
                        angleU = 0.0f + 0.20943952f * (float)iu;
                        model.vertices[i++] = MathUtils.cos((float)angleU) * 0.5f * t;
                        model.vertices[i++] = h;
                        model.vertices[i++] = MathUtils.sin((float)angleU) * 0.5f * t;
                    }
                }
            } else {
                if (modelParams == null) {
                    modelParams = new HashMap<String, Object>();
                    modelParams.put("diameter", 1.0);
                    modelParams.put("quality", 30L);
                }
                Pair<IntModel, Map<String, Material>> modelPair = ModelCache.cache.getModel(modelType, modelParams, Bits.indices(1, 16), primitive);
                IntModel intModel = modelPair.getFirst();
                IntMesh mesh = (IntMesh)intModel.meshes.get(0);
                model = new InstancedModel(mesh);
            }
        } else if (modelType.equalsIgnoreCase("icosphere")) {
            long recursion = 3L;
            double diameter = 1.0;
            if (wireframe) {
                IcoSphereCreator ico = new IcoSphereCreator();
                ico.create(0.5f, 3);
                int nFaces = ico.faces.size();
                List v = ico.vertices;
                model = new InstancedModel(nFaces * 6, 3);
                int i = 0;
                for (ModelCreator.IFace face : ico.faces) {
                    Vector3 v1 = (Vector3)v.get(face.v()[0] - 1);
                    Vector3 v2 = (Vector3)v.get(face.v()[1] - 1);
                    Vector3 v3 = (Vector3)v.get(face.v()[2] - 1);
                    model.vertices[i++] = v1.x;
                    model.vertices[i++] = v1.y;
                    model.vertices[i++] = v1.z;
                    model.vertices[i++] = v2.x;
                    model.vertices[i++] = v2.y;
                    model.vertices[i++] = v2.z;
                    model.vertices[i++] = v2.x;
                    model.vertices[i++] = v2.y;
                    model.vertices[i++] = v2.z;
                    model.vertices[i++] = v3.x;
                    model.vertices[i++] = v3.y;
                    model.vertices[i++] = v3.z;
                    model.vertices[i++] = v3.x;
                    model.vertices[i++] = v3.y;
                    model.vertices[i++] = v3.z;
                    model.vertices[i++] = v1.x;
                    model.vertices[i++] = v1.y;
                    model.vertices[i++] = v1.z;
                }
            } else {
                if (modelParams == null) {
                    modelParams = new HashMap<String, Object>();
                    modelParams.put("recursion", 3L);
                    modelParams.put("diameter", 1.0);
                }
                Pair<IntModel, Map<String, Material>> modelPair = ModelCache.cache.getModel(modelType, modelParams, Bits.indices(1, 16), primitive);
                IntModel intModel = modelPair.getFirst();
                IntMesh mesh = (IntMesh)intModel.meshes.get(0);
                model = new InstancedModel(mesh);
            }
        } else if (modelType.equalsIgnoreCase("quad")) {
            model = new InstancedModel(6, 2 + primitivePlus);
            int i = 0;
            model.vertices[i++] = 1.0f;
            model.vertices[i++] = 1.0f;
            if (!wireframe) {
                model.vertices[i++] = 1.0f;
                model.vertices[i++] = 1.0f;
            }
            model.vertices[i++] = 1.0f;
            model.vertices[i++] = -1.0f;
            if (!wireframe) {
                model.vertices[i++] = 1.0f;
                model.vertices[i++] = 0.0f;
            }
            model.vertices[i++] = -1.0f;
            model.vertices[i++] = -1.0f;
            if (!wireframe) {
                model.vertices[i++] = 0.0f;
                model.vertices[i++] = 0.0f;
            }
            model.vertices[i++] = -1.0f;
            model.vertices[i++] = -1.0f;
            if (!wireframe) {
                model.vertices[i++] = 0.0f;
                model.vertices[i++] = 0.0f;
            }
            model.vertices[i++] = -1.0f;
            model.vertices[i++] = 1.0f;
            if (!wireframe) {
                model.vertices[i++] = 0.0f;
                model.vertices[i++] = 1.0f;
            }
            model.vertices[i++] = 1.0f;
            model.vertices[i++] = 1.0f;
            if (!wireframe) {
                model.vertices[i++] = 1.0f;
                model.vertices[i] = 1.0f;
            }
        } else {
            Pair<IntModel, Map<String, Material>> modelPair = ModelCache.cache.getModel(modelType, modelParams, Bits.indices(1, 16), primitive);
            IntModel intModel = modelPair.getFirst();
            IntMesh mesh = (IntMesh)intModel.meshes.get(0);
            model = new InstancedModel(mesh);
        }
        this.setModel(offset, model);
        return model;
    }

    protected void addAttributesDivisor0(Array<VertexAttribute> attributes, int posArraySize, boolean useNormals, boolean useTexCoords) {
        attributes.add((Object)new VertexAttribute(1, posArraySize, "a_position"));
        if (useNormals) {
            attributes.add((Object)new VertexAttribute(8, 3, "a_normal"));
        }
        if (useTexCoords) {
            attributes.add((Object)new VertexAttribute(16, 2, "a_texCoord0"));
        }
    }

    protected abstract void addAttributesDivisor1(Array<VertexAttribute> var1, int var2);

    protected VertexAttribute[] buildAttributesDivisor0(int posArraySize, boolean useNormals, boolean useTexCoords) {
        Array attributes = new Array();
        this.addAttributesDivisor0((Array<VertexAttribute>)attributes, posArraySize, useNormals, useTexCoords);
        VertexAttribute[] array = new VertexAttribute[attributes.size];
        for (int i = 0; i < attributes.size; ++i) {
            array[i] = (VertexAttribute)attributes.get(i);
        }
        return array;
    }

    protected VertexAttribute[] buildAttributesDivisor1(int primitive) {
        Array attributes = new Array();
        this.addAttributesDivisor1((Array<VertexAttribute>)attributes, primitive);
        VertexAttribute[] array = new VertexAttribute[attributes.size];
        for (int i = 0; i < attributes.size; ++i) {
            array[i] = (VertexAttribute)attributes.get(i);
        }
        return array;
    }

    protected abstract void offsets0(ImmediateModeRenderSystem.MeshData var1, InstancedModel var2);

    protected abstract void offsets1(ImmediateModeRenderSystem.MeshData var1, InstancedModel var2);

    protected int addMeshData(InstancedModel model, int maxVerts, int maxInstances, int maxIndices, String modelFile, String modelType, int primitive) {
        int mdi = this.createMeshData();
        this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(mdi);
        VertexAttribute[] attributes0 = this.buildAttributesDivisor0(modelFile == null && modelType.equalsIgnoreCase("quad") ? 2 : 3, modelFile != null, !this.isWireframe(primitive));
        VertexAttribute[] attributes1 = this.buildAttributesDivisor1(primitive);
        this.curr.mesh = new IntMesh(true, maxVerts, maxInstances, maxIndices, attributes0, attributes1);
        this.curr.vertexSize = this.curr.mesh.getVertexAttributes().vertexSize / 4;
        this.curr.instanceSize = this.curr.mesh.getInstanceAttributes().vertexSize / 4;
        this.offsets0(this.curr, model);
        this.offsets1(this.curr, model);
        return mdi;
    }

    protected void preRenderObjects(ExtShaderProgram shaderProgram, ICamera camera) {
    }

    protected void renderObject(ExtShaderProgram shaderProgram, IRenderable renderable) {
    }

    protected void postRenderObjects(ExtShaderProgram shaderProgram, ICamera camera) {
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        if (!renderables.isEmpty()) {
            ExtShaderProgram shaderProgram = this.getShaderProgram();
            shaderProgram.begin();
            this.preRenderObjects(shaderProgram, camera);
            renderables.forEach(r -> this.renderObject(shaderProgram, (IRenderable)r));
            this.postRenderObjects(shaderProgram, camera);
            shaderProgram.end();
        }
    }

    public static class InstancedModel {
        public int sizeOffset;
        public int particlePosOffset;
        public int properMotionOffset;
        public int textureIndexOffset;
        public int nVariOffset;
        public int variMagsOffset;
        public int variTimesOffset;
        public int numVertices;
        public int modelVertexSize;
        public int numIndices = 0;
        public float[] vertices;
        public int[] indices;
        public float[] instanceAttributes;

        public InstancedModel(IntMesh mesh) {
            this(mesh.getNumVertices(), mesh.getVertexSize() / 4, mesh.getNumIndices());
            if (this.numVertices > 0) {
                mesh.getVertices(this.vertices);
            }
            if (this.numIndices > 0) {
                mesh.getIndices(this.indices);
            }
        }

        public InstancedModel(int numModelVertices, int modelVertexSize, int numIndices) {
            this.numVertices = numModelVertices;
            this.modelVertexSize = modelVertexSize;
            this.numIndices = numIndices;
            this.initializeLists();
        }

        public InstancedModel(int numModelVertices, int modelVertexSize) {
            this.numVertices = numModelVertices;
            this.modelVertexSize = modelVertexSize;
            this.initializeLists();
        }

        public void ensureInstanceAttribsSize(int size) {
            if (this.instanceAttributes == null || this.instanceAttributes.length < size) {
                this.instanceAttributes = new float[size];
            }
        }

        protected void initializeLists() {
            int size = this.numVertices * this.modelVertexSize;
            if (this.vertices == null || this.vertices.length < size) {
                this.vertices = new float[size];
            }
            if (this.numIndices > 0 && (this.indices == null || this.indices.length < this.numIndices)) {
                this.indices = new int[this.numIndices];
            }
        }
    }
}

