/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.system;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector3;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.AbstractRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.StarSet;
import gaiasky.util.GlobalResources;
import gaiasky.util.Settings;
import gaiasky.util.camera.Proximity;
import gaiasky.util.gravwaves.RelativisticEffectsManager;
import gaiasky.util.math.Vector3D;
import java.util.Arrays;
import java.util.List;

public class LightPositionUpdater
implements AbstractRenderSystem.RenderSystemRunnable {
    private final Object lock = new Object();
    private final Vector3 auxV;
    private final Vector3D auxD;
    private int nLights;
    private float[] positions;
    private float[] solidAngles;
    private float[] colors;
    private Texture occlusionTexture;

    public LightPositionUpdater() {
        this.reinitialize(Settings.settings.graphics.quality.getGlowNLights());
        this.auxV = new Vector3();
        this.auxD = new Vector3D();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize(int nLights) {
        Object object = this.lock;
        synchronized (object) {
            this.nLights = nLights;
            this.positions = this.initializeList(null, nLights * 2);
            this.solidAngles = this.initializeList(null, nLights);
            this.colors = this.initializeList(null, nLights * 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] initializeList(float[] list, int size) {
        if (list == null) {
            return new float[size];
        }
        if (list.length == size) {
            return list;
        }
        float[] fArray = list;
        synchronized (list) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Arrays.copyOf(list, size);
        }
    }

    public void setOcclusionTexture(Texture tex) {
        this.occlusionTexture = tex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(AbstractRenderSystem renderSystem, List<IRenderable> renderables, ICamera camera) {
        Object object = this.lock;
        synchronized (object) {
            int size = renderables.size();
            Settings settings = Settings.settings;
            if (GaiaSky.instance.getPostProcessor().isLightScatterEnabled() || GaiaSky.instance.getPostProcessor().isLensFlareEnabled()) {
                int lightIndex = 0;
                float angleEdgeDeg = camera.getAngleEdge() * 57.295776f;
                for (int i = size - 1; i >= 0; --i) {
                    Proximity.NearbyRecord[] proximityArray;
                    IRenderable s = renderables.get(i);
                    if (!(s instanceof Render)) continue;
                    Render p = (Render)s;
                    Entity entity = p.getEntity();
                    if (Mapper.hip.has(entity)) {
                        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
                        double angle = GaiaSky.instance.cameraManager.getDirection().angle(graph.translation);
                        if (lightIndex >= this.nLights || !settings.program.modeCubemap.active && !settings.runtime.openXr && !(angle < (double)angleEdgeDeg)) continue;
                        Vector3D pos3d = graph.translation.put(this.auxD);
                        GlobalResources.applyRelativisticAberration(pos3d, camera);
                        RelativisticEffectsManager.getInstance().gravitationalWavePos(pos3d);
                        Vector3 pos3 = pos3d.put(this.auxV);
                        float w = settings.graphics.resolution[0];
                        float h = settings.graphics.resolution[1];
                        camera.getCamera().project(pos3, 0.0f, 0.0f, w, h);
                        Body body = (Body)Mapper.body.get(entity);
                        this.positions[lightIndex * 2] = this.auxV.x / w;
                        this.positions[lightIndex * 2 + 1] = this.auxV.y / h;
                        this.solidAngles[lightIndex] = (float)body.solidAngleApparent;
                        this.colors[lightIndex * 3] = body.color[0];
                        this.colors[lightIndex * 3 + 1] = body.color[1];
                        this.colors[lightIndex * 3 + 2] = body.color[2];
                        ++lightIndex;
                        continue;
                    }
                    if (!Mapper.starSet.has(entity)) continue;
                    StarSet starSet = (StarSet)Mapper.starSet.get(entity);
                    for (Proximity.NearbyRecord record : proximityArray = starSet.proximity.updating) {
                        if (record == null) continue;
                        Vector3D pos3d = this.auxD.set(record.absolutePos).sub(camera.getPos());
                        double angle = GaiaSky.instance.cameraManager.getDirection().angle(pos3d);
                        if (lightIndex >= this.nLights || !settings.program.modeCubemap.active && !settings.runtime.openXr && !(angle < (double)angleEdgeDeg)) continue;
                        GlobalResources.applyRelativisticAberration(pos3d, camera);
                        RelativisticEffectsManager.getInstance().gravitationalWavePos(pos3d);
                        Vector3 pos3 = pos3d.put(this.auxV);
                        float w = settings.graphics.resolution[0];
                        float h = settings.graphics.resolution[1];
                        camera.getCamera().project(pos3, 0.0f, 0.0f, w, h);
                        Body body = (Body)Mapper.body.get(entity);
                        this.positions[lightIndex * 2] = this.auxV.x / w;
                        this.positions[lightIndex * 2 + 1] = this.auxV.y / h;
                        this.solidAngles[lightIndex] = (float)starSet.getSolidAngleApparent(record.index);
                        this.colors[lightIndex * 3] = record.col[0];
                        this.colors[lightIndex * 3 + 1] = record.col[1];
                        this.colors[lightIndex * 3 + 2] = record.col[2];
                        ++lightIndex;
                    }
                }
                EventManager.publish(Event.LIGHT_POS_2D_UPDATE, this, lightIndex, this.positions, this.solidAngles, this.colors, this.occlusionTexture);
            } else {
                EventManager.publish(Event.LIGHT_POS_2D_UPDATE, this, 0, this.positions, this.solidAngles, this.colors, this.occlusionTexture);
            }
        }
    }
}

