/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.system;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.ILineRenderable;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import java.util.Comparator;
import java.util.List;

public class LineRenderSystem
extends ImmediateModeRenderSystem {
    protected static final Logger.Log logger = Logger.getLogger(LineRenderSystem.class);
    protected ICamera camera;
    protected Vector3 aux2 = new Vector3();
    private ExtShaderProgram shaderProgram;

    public LineRenderSystem(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders) {
        super(sceneRenderer, rg, alphas, shaders);
    }

    @Override
    protected void initShaderProgram() {
        Gdx.gl.glEnable(2848);
        Gdx.gl.glHint(3154, 4354);
    }

    @Override
    protected void initVertices() {
        this.meshes = new Array();
        this.initVertices(this.meshIdx++);
    }

    protected void initVertices(int index) {
        if (index >= this.meshes.size) {
            this.meshes.setSize(index + 1);
        }
        if (this.meshes.get(index) == null) {
            if (index > 0) {
                logger.info("Capacity too small, creating new buffer: " + this.curr.capacity);
            }
            this.curr = new ImmediateModeRenderSystem.MeshData();
            this.meshes.set(index, (Object)this.curr);
            this.curr.capacity = 10000;
            VertexAttribute[] attributes = this.buildVertexAttributes();
            this.curr.mesh = new IntMesh(false, this.curr.capacity, 0, attributes);
            this.curr.vertexSize = this.curr.mesh.getVertexAttributes().vertexSize / 4;
            this.curr.vertices = new float[this.curr.capacity * this.curr.vertexSize];
            this.curr.colorOffset = this.curr.mesh.getVertexAttribute(4) != null ? this.curr.mesh.getVertexAttribute((int)4).offset / 4 : 0;
        } else {
            this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(index);
        }
    }

    protected VertexAttribute[] buildVertexAttributes() {
        Array attributes = new Array();
        attributes.add((Object)new VertexAttribute(1, 3, "a_position"));
        attributes.add((Object)new VertexAttribute(4, 4, "a_color"));
        VertexAttribute[] array = new VertexAttribute[attributes.size];
        for (int i = 0; i < attributes.size; ++i) {
            array[i] = (VertexAttribute)attributes.get(i);
        }
        return array;
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        this.shaderProgram = this.getShaderProgram();
        this.shaderProgram.begin();
        this.shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
        this.shaderProgram.setUniformf("u_alpha", 1.0f);
        this.addEffectsUniforms(this.shaderProgram, camera);
        this.camera = camera;
        renderables.forEach(r -> {
            ILineRenderable renderable = (ILineRenderable)r;
            renderable.render(this, camera, this.getAlpha(renderable));
            Gdx.gl.glLineWidth(renderable.getLineWidth() * 1.5f * Settings.settings.scene.renderer.line.width + Settings.settings.scene.renderer.line.glWidthBias);
            for (int md = 0; md < this.meshIdx; ++md) {
                ImmediateModeRenderSystem.MeshData meshDouble = (ImmediateModeRenderSystem.MeshData)this.meshes.get(md);
                meshDouble.mesh.setVertices(meshDouble.vertices, 0, meshDouble.vertexIdx);
                meshDouble.mesh.render(this.shaderProgram, renderable.getGlPrimitive());
                meshDouble.clear();
            }
        });
        this.shaderProgram.end();
        this.meshIdx = 1;
        this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(0);
    }

    public void breakLine() {
    }

    public void addPoint(ILineRenderable lr, double x, double y, double z, float r, float g, float b, float a) {
        if (this.curr.numVertices + 1 >= this.curr.capacity) {
            this.initVertices(this.meshIdx++);
        }
        this.color(r, g, b, a);
        this.vertex((float)x, (float)y, (float)z);
    }

    public void addLine(ILineRenderable lr, double x0, double y0, double z0, double x1, double y1, double z1, Color col0, Color col1) {
        this.addLinePostproc(x0, y0, z0, x1, y1, z1, col0.r, col0.g, col0.b, col0.a, col1.r, col1.g, col1.b, col1.a);
    }

    public void addLine(ILineRenderable lr, double x0, double y0, double z0, double x1, double y1, double z1, Color col) {
        this.addLinePostproc(x0, y0, z0, x1, y1, z1, col.r, col.g, col.b, col.a);
    }

    public void addLine(ILineRenderable lr, double x0, double y0, double z0, double x1, double y1, double z1, float r0, float g0, float b0, float a0, float r1, float g1, float b1, float a1) {
        this.addLinePostproc(x0, y0, z0, x1, y1, z1, r0, g0, b0, a0, r1, g1, b1, a1);
    }

    public void addLine(ILineRenderable lr, double x0, double y0, double z0, double x1, double y1, double z1, float r, float g, float b, float a) {
        this.addLinePostproc(x0, y0, z0, x1, y1, z1, r, g, b, a);
    }

    public void addLinePostproc(double x0, double y0, double z0, double x1, double y1, double z1, double r, double g, double b, double a) {
        if (this.curr.numVertices + 2 >= this.curr.capacity) {
            this.initVertices(this.meshIdx++);
        }
        this.color(r, g, b, a);
        this.vertex((float)x0, (float)y0, (float)z0);
        this.color(r, g, b, a);
        this.vertex((float)x1, (float)y1, (float)z1);
    }

    public void addLinePostproc(double x0, double y0, double z0, double x1, double y1, double z1, double r0, double g0, double b0, double a0, double r1, double g1, double b1, double a1) {
        if (this.curr.numVertices + 2 >= this.curr.capacity) {
            this.initVertices(this.meshIdx++);
        }
        this.color(r0, g0, b0, a0);
        this.vertex((float)x0, (float)y0, (float)z0);
        this.color(r1, g1, b1, a1);
        this.vertex((float)x1, (float)y1, (float)z1);
    }

    protected static class LineArraySorter
    implements Comparator<double[]> {
        private final int idx;

        public LineArraySorter(int idx) {
            this.idx = idx;
        }

        @Override
        public int compare(double[] o1, double[] o2) {
            double f = o1[this.idx] - o2[this.idx];
            if (f == 0.0) {
                return 0;
            }
            if (f < 0.0) {
                return 1;
            }
            return -1;
        }
    }
}

