/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.system;

import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.utils.Array;
import gaiasky.event.IObserver;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import java.util.List;

public abstract class PointCloudRenderSystem
extends ImmediateModeRenderSystem
implements IObserver {
    public PointCloudRenderSystem(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders) {
        super(sceneRenderer, rg, alphas, shaders);
    }

    @Override
    protected void initVertices() {
        this.meshes = new Array();
    }

    protected abstract void addVertexAttributes(Array<VertexAttribute> var1);

    protected VertexAttribute[] buildVertexAttributes() {
        Array attributes = new Array();
        this.addVertexAttributes((Array<VertexAttribute>)attributes);
        VertexAttribute[] array = new VertexAttribute[attributes.size];
        for (int i = 0; i < attributes.size; ++i) {
            array[i] = (VertexAttribute)attributes.get(i);
        }
        return array;
    }

    protected abstract void offsets(ImmediateModeRenderSystem.MeshData var1);

    protected int addMeshData(int maxVerts) {
        return this.addMeshData(maxVerts, 0);
    }

    protected int addMeshData(int maxVerts, int maxIndices) {
        int mdi = this.createMeshData();
        this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(mdi);
        VertexAttribute[] attributes = this.buildVertexAttributes();
        this.curr.mesh = new IntMesh(false, maxVerts, maxIndices, attributes);
        this.curr.vertexSize = this.curr.mesh.getVertexAttributes().vertexSize / 4;
        this.offsets(this.curr);
        return mdi;
    }

    protected void preRenderObjects(ExtShaderProgram shaderProgram, ICamera camera) {
    }

    protected void renderObject(ExtShaderProgram shaderProgram, IRenderable renderable) {
    }

    protected void postRenderObjects(ExtShaderProgram shaderProgram, ICamera camera) {
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        if (!renderables.isEmpty()) {
            ExtShaderProgram shaderProgram = this.getShaderProgram();
            shaderProgram.begin();
            this.preRenderObjects(shaderProgram, camera);
            for (IRenderable r : renderables) {
                this.renderObject(shaderProgram, r);
            }
            this.postRenderObjects(shaderProgram, camera);
            shaderProgram.end();
        }
    }
}

