/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.util;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;

public class GaiaSkyFrameBuffer
extends FrameBuffer {
    private int colorIndex = -1;
    private int depthIndex = -1;
    private int layerIndex = -1;
    private int normalIndex = -1;
    private int reflectionMaskIndex = -1;

    public GaiaSkyFrameBuffer(GLFrameBuffer.GLFrameBufferBuilder<? extends GLFrameBuffer<Texture>> bufferBuilder, int ... indices) {
        super(bufferBuilder);
        if (indices.length > 0) {
            this.colorIndex = indices[0];
        }
        if (indices.length > 1) {
            this.depthIndex = indices[1];
        }
        if (indices.length > 2) {
            this.layerIndex = indices[2];
        }
        if (indices.length > 3) {
            this.normalIndex = indices[3];
        }
        if (indices.length > 4) {
            this.reflectionMaskIndex = indices[4];
        }
    }

    public Texture getColorBufferTexture() {
        if (this.colorIndex >= 0) {
            return (Texture)this.textureAttachments.get(this.colorIndex);
        }
        return null;
    }

    public Texture getDepthBufferTexture() {
        if (this.depthIndex >= 0) {
            return (Texture)this.textureAttachments.get(this.depthIndex);
        }
        return null;
    }

    public Texture getLayerBufferTexture() {
        if (this.layerIndex >= 0) {
            return (Texture)this.textureAttachments.get(this.layerIndex);
        }
        return null;
    }

    public Texture getNormalBufferTexture() {
        if (this.normalIndex >= 0) {
            return (Texture)this.textureAttachments.get(this.normalIndex);
        }
        return null;
    }

    public Texture getReflectionMaskBufferTexture() {
        if (this.reflectionMaskIndex >= 0) {
            return (Texture)this.textureAttachments.get(this.reflectionMaskIndex);
        }
        return null;
    }

    public Texture getTextureAttachment(int index) {
        if (this.textureAttachments.size > index) {
            return (Texture)this.textureAttachments.get(index);
        }
        return null;
    }
}

