/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.util;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import java.util.Iterator;

public class ItemsManager<T extends Disposable>
implements Iterable<T>,
Disposable {
    private static final int ItemNotFound = -1;
    protected final Array<Boolean> owned = new Array();
    private final Array<T> items = new Array();

    public void dispose() {
        for (int i = 0; i < this.items.size; ++i) {
            if (!((Boolean)this.owned.get(i)).booleanValue()) continue;
            ((Disposable)this.items.get(i)).dispose();
        }
        this.items.clear();
        this.owned.clear();
    }

    public void add(T item, boolean own) {
        if (item == null) {
            return;
        }
        this.items.add(item);
        this.owned.add((Object)own);
    }

    public void add(T item) {
        this.add(item, true);
    }

    public T get(int index) {
        return (T)((Disposable)this.items.get(index));
    }

    public int count() {
        return this.items.size;
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    public void remove(T item) {
        int index = this.items.indexOf(item, true);
        if (index == -1) {
            return;
        }
        if (((Boolean)this.owned.get(index)).booleanValue()) {
            ((Disposable)this.items.get(index)).dispose();
        }
        this.items.removeIndex(index);
        this.owned.removeIndex(index);
        this.items.removeValue(item, true);
    }
}

