/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.render.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.gdx.shader.loader.ShaderTemplatingLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class ShaderLoader {
    private static final Logger.Log logger = Logger.getLogger(ShaderLoader.class);
    public static String BasePath = "";
    public static boolean Pedantic = true;

    private ShaderLoader() {
    }

    public static ShaderProgram fromFile(String vertexFileName, String fragmentFileName) {
        return ShaderLoader.fromFile(vertexFileName, fragmentFileName, "");
    }

    public static ShaderProgram fromFile(String vertexFileName, String fragmentFileName, String defines) throws RuntimeException {
        String log = "\"" + vertexFileName + " / " + fragmentFileName + "\"";
        if (defines == null) {
            defines = "";
        }
        if (!defines.isEmpty()) {
            log = log + " w/ (" + defines.replace("\n", ", ") + ")";
        }
        log = log + "...";
        logger.debug("Compiling " + log);
        String vpSrc = ShaderLoader.loadShaderCode(vertexFileName, "", "glsl", "vert.glsl", "vert", "vertex", "vsh", "glslv");
        String fpSrc = ShaderLoader.loadShaderCode(fragmentFileName, "", "glsl", "frag.glsl", "frag", "fragment", "fsh", "glslf");
        vpSrc = ShaderTemplatingLoader.resolveIncludes(vpSrc);
        fpSrc = ShaderTemplatingLoader.resolveIncludes(fpSrc);
        return ShaderLoader.fromString(vpSrc, fpSrc, vertexFileName, fragmentFileName, defines);
    }

    private static String loadShaderCode(String fileName, String ... extensions) {
        for (String extension : extensions) {
            String file = fileName + (String)(extension.isBlank() ? "" : "." + extension);
            try {
                return Gdx.files.internal(BasePath + file).readString();
            }
            catch (Exception e0) {
                Path path = Settings.settings.data.dataPath(file);
                if (!Files.exists(path, new LinkOption[0]) || !Files.isReadable(path)) continue;
                try {
                    return Files.readString(path);
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static ShaderProgram fromString(String vertex, String fragment, String vertexName, String fragmentName) throws RuntimeException {
        return ShaderLoader.fromString(vertex, fragment, vertexName, fragmentName, "");
    }

    public static ShaderProgram fromString(String vertex, String fragment, String vertexName, String fragmentName, String defines) throws RuntimeException {
        ShaderProgram.pedantic = Pedantic;
        ShaderProgram shader = new ShaderProgram(ShaderLoader.insertDefines(vertex, defines), ShaderLoader.insertDefines(fragment, defines));
        if (!shader.isCompiled()) {
            logger.error("Compile error: " + vertexName + " / " + fragmentName);
            logger.error(shader.getLog());
            throw new RuntimeException("Compile error: " + vertexName + " / " + fragmentName);
        }
        return shader;
    }

    private static String insertDefines(String shader, String defines) {
        if (shader.contains("#version ")) {
            String[] lines = shader.split("\n");
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line).append("\n");
                if (!line.trim().startsWith("#version ")) continue;
                sb.append(defines).append("\n");
            }
            return sb.toString();
        }
        return defines + "\n" + shader;
    }
}

