/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.rest;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import gaiasky.GaiaSky;
import gaiasky.script.EventScriptingInterface;
import gaiasky.script.IScriptingInterface;
import gaiasky.script.v2.impl.APIv2;
import gaiasky.script.v2.meta.ModuleDesc;
import gaiasky.util.Logger;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import spark.Request;
import spark.Response;
import spark.Spark;

public class RESTServer {
    private static final Logger.Log logger = Logger.getLogger(RESTServer.class);
    private static boolean shutdownTriggered = false;
    private static boolean activated = false;

    private static void printStartupInfo() {
        String s = System.getProperty("org.slf4j.simpleLogger.defaultLogLevel");
        logger.debug("Simple Logger defaultLogLevel = " + s);
        logger.warn("*** Warning: REST API server may permit remote code execution! Only use this functionality in a trusted environment! ***");
    }

    private static String responseData(Request request, Response response, Map<String, Object> ret, boolean success) {
        response.type("application/json");
        ret.putIfAbsent("value", null);
        ret.put("success", success);
        if (success) {
            response.status(200);
            ret.putIfAbsent("text", "OK");
        } else {
            response.status(400);
            ret.putIfAbsent("text", "Failed");
        }
        Json json = new Json(JsonWriter.OutputType.json);
        String responseString = json.toJson(ret);
        logger.debug("HTTP response body: {}.", responseString);
        return responseString;
    }

    private static void loggerRequestInfo(Request request) {
        logger.debug("======== Handling API call via HTTP {}: ========", request.requestMethod());
        logger.debug("* Parameter extracted:");
        logger.debug("  command = ", request.params(":cmd"));
        logger.debug("* Request:");
        logger.debug("  client IP = {}", request.ip());
        logger.debug("  host = {}", request.host());
        logger.debug("  userAgent = {}", request.userAgent());
        logger.debug("  pathInfo = {}", request.pathInfo());
        logger.debug("  servletPath = {}", request.servletPath());
        logger.debug("  contextPath = {}", request.contextPath());
        logger.debug("  url = {}", request.url());
        logger.debug("  uri = {}", request.uri());
        logger.debug("  protocol = {}", request.protocol());
        logger.debug("* Body");
        logger.debug("  contentType() = '{}'", request.contentType());
        logger.debug("  params() = '{}'", request.params());
        logger.debug("  body contentLenght() = {}", request.contentLength());
        logger.debug("* Query parameters");
        logger.debug("  queryString() = '{}'", request.queryString());
        logger.debug("  queryParams = {}", request.queryParams());
        for (String s : request.queryParams()) {
            logger.debug("    '{}' => '{}'", s, request.queryParams(s));
        }
    }

    private static String methodDeclarationString(Method method) {
        Parameter[] methodParams = method.getParameters();
        StringBuilder ret = new StringBuilder(method.getName());
        for (int i = 0; i < methodParams.length; ++i) {
            Parameter p = methodParams[i];
            ret.append(String.format("%s%s=(%s)", i == 0 ? "?" : "&", p.getName(), p.getType().getSimpleName()));
        }
        ret.append(String.format(" \u27f6 %s", method.getReturnType().getSimpleName()));
        return ret.toString();
    }

    private static String[] getMethodDeclarationStrings(String methodName) {
        Method[] allMethods = IScriptingInterface.class.getDeclaredMethods();
        ArrayList<String> matchMethodsDeclarations = new ArrayList<String>();
        for (Method allMethod : allMethods) {
            if (!methodName.isEmpty() && !methodName.equals(allMethod.getName())) continue;
            String declaration = RESTServer.methodDeclarationString(allMethod);
            matchMethodsDeclarations.add(declaration);
        }
        Collections.sort(matchMethodsDeclarations);
        return matchMethodsDeclarations.toArray(new String[0]);
    }

    private static String[] getMethodDeclarationStrings(String methodName, ModuleDesc module) {
        Method[] allMethods = module.clazz().getDeclaredMethods();
        ArrayList<String> matchMethodsDeclarations = new ArrayList<String>();
        for (Method allMethod : allMethods) {
            if (!methodName.isEmpty() && !methodName.equals(allMethod.getName()) || !Modifier.isPublic(allMethod.getModifiers())) continue;
            String declaration = RESTServer.methodDeclarationString(allMethod);
            matchMethodsDeclarations.add(declaration);
        }
        Collections.sort(matchMethodsDeclarations);
        return matchMethodsDeclarations.toArray(new String[0]);
    }

    private static String[] getModuleDeclarations(ModuleDesc module) {
        ArrayList<String> result = new ArrayList<String>();
        for (ModuleDesc m : module.modules()) {
            result.add(m.name());
        }
        Collections.sort(result);
        return result.toArray(new String[0]);
    }

    private static String[] splitArrayString(String arrayString) {
        int len = arrayString.length();
        if (len >= 2 && "[".equals(arrayString.substring(0, 1)) && "]".equals(arrayString.substring(len - 1, len))) {
            return arrayString.substring(1, len - 1).split(",");
        }
        logger.warn("splitArrayString: '{}' is parsed as empty array!", arrayString);
        throw new IllegalArgumentException();
    }

    private static String handleAPIv1Call(Request request, Response response, Map<String, Array<Method>> apiv1Methods) {
        String msg;
        RESTServer.loggerRequestInfo(request);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (!activated) {
            String msg2 = "GUI not yet initialized. Please wait...";
            logger.warn(msg2);
            ret.put("text", msg2);
            return RESTServer.responseData(request, response, ret, false);
        }
        String cmd = request.params(":cmd");
        Set queryParams = request.queryParams();
        if ("help".equals(cmd)) {
            logger.debug("Help command received");
            ret.put("text", "Help: see 'cmd_syntax' for command reference. Vectors are comma-separated.");
            ret.put("cmd_syntax", RESTServer.getMethodDeclarationStrings(""));
            return RESTServer.responseData(request, response, ret, true);
        }
        if ("debugCall".equals(cmd)) {
            logger.debug("debugCall received. What to do now?");
            ret.put("text", "debugCall data");
            return RESTServer.responseData(request, response, ret, true);
        }
        logger.debug("Method matching...");
        Executable matchMethod = null;
        boolean methodNameMatches = false;
        if (!apiv1Methods.containsKey(cmd)) {
            logger.debug("No suitable method found.");
            String msg3 = String.format("Failed: command name '%s' not found. See syntax in 'cmd_syntax'.", cmd);
            ret.put("cmd_syntax", RESTServer.getMethodDeclarationStrings(""));
            logger.warn(msg3);
            ret.put("text", msg3);
            return RESTServer.responseData(request, response, ret, false);
        }
        Array<Method> matchMethods = apiv1Methods.get(cmd);
        for (int i = 0; i < matchMethods.size; ++i) {
            boolean numParametersMatch;
            Method m = (Method)matchMethods.get(i);
            logger.debug("match check cmd={} with method={}...", cmd, m.getName());
            if (!m.getName().equals(cmd)) continue;
            logger.debug("  [+] name matches");
            methodNameMatches = true;
            Parameter[] methodParams = ((Method)matchMethods.get(i)).getParameters();
            boolean bl = numParametersMatch = methodParams.length == queryParams.size();
            if (!numParametersMatch) {
                logger.debug(" [+] number of parameters does not match");
                continue;
            }
            boolean allMethodParamsFullfilled = true;
            int pi = 0;
            for (Parameter p : methodParams) {
                if (!queryParams.contains(p.getName()) && !queryParams.contains("arg" + pi)) {
                    allMethodParamsFullfilled = false;
                    logger.debug("  [+] method parameters not present");
                    break;
                }
                ++pi;
            }
            if (!allMethodParamsFullfilled) continue;
            logger.debug("  [+] all method parameters present");
            matchMethod = m;
            break;
        }
        if (matchMethod != null) {
            logger.debug("Suitable method found: {}", RESTServer.methodDeclarationString(matchMethod));
            Parameter[] matchParameters = matchMethod.getParameters();
            Class<?> matchReturnType = ((Method)matchMethod).getReturnType();
            Object[] arguments = new Object[matchParameters.length];
            Class[] types = new Class[matchParameters.length];
            logger.debug("Preparing method arguments...");
            for (int i = 0; i < matchParameters.length; ++i) {
                Parameter p = matchParameters[i];
                Object paramName = p.getName();
                String stringValue = request.queryParams((String)paramName);
                if (stringValue == null) {
                    paramName = "arg" + i;
                    stringValue = request.queryParams((String)paramName);
                }
                logger.debug("  [+] handling parameter '{}'", paramName);
                types[i] = p.getType();
                logger.debug("  [+] parameter getType = '{}', isPrimitive = {}", p.getType().getSimpleName(), p.getType().isPrimitive());
                try {
                    int vi;
                    Object[] dvec;
                    if (Integer.TYPE.equals(types[i]) || Integer.class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type int");
                        arguments[i] = Integer.parseInt(stringValue);
                        continue;
                    }
                    if (Long.TYPE.equals(types[i]) || Long.class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type long");
                        arguments[i] = Long.parseLong(stringValue);
                        continue;
                    }
                    if (Float.TYPE.equals(types[i]) || Float.class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type float");
                        arguments[i] = Float.valueOf(Float.parseFloat(stringValue));
                        continue;
                    }
                    if (Double.TYPE.equals(types[i]) || Double.class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type double");
                        arguments[i] = Double.parseDouble(stringValue);
                        continue;
                    }
                    if (Boolean.TYPE.equals(types[i]) || Boolean.class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type boolean");
                        arguments[i] = Boolean.parseBoolean(stringValue);
                        continue;
                    }
                    if (int[].class.equals((Object)types[i]) || Integer[].class.equals((Object)types[i])) {
                        logger.debug("handling parameter as type int[]");
                        String[] svec = RESTServer.splitArrayString(stringValue);
                        dvec = new int[svec.length];
                        for (vi = 0; vi < svec.length; ++vi) {
                            dvec[vi] = Integer.parseInt(svec[vi]);
                        }
                        arguments[i] = dvec;
                        logger.debug("  [+] argument={}", Arrays.toString(dvec));
                        continue;
                    }
                    if (float[].class.equals((Object)types[i]) || Float[].class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type float[]");
                        String[] svec = RESTServer.splitArrayString(stringValue);
                        dvec = new float[svec.length];
                        for (vi = 0; vi < svec.length; ++vi) {
                            dvec[vi] = (int)Float.parseFloat(svec[vi]);
                        }
                        arguments[i] = dvec;
                        logger.debug("  [+] argument={}", Arrays.toString((float[])dvec));
                        continue;
                    }
                    if (double[].class.equals((Object)types[i]) || Double[].class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type double[]");
                        String[] svec = RESTServer.splitArrayString(stringValue);
                        dvec = new double[svec.length];
                        for (vi = 0; vi < svec.length; ++vi) {
                            dvec[vi] = (int)Double.parseDouble(svec[vi]);
                        }
                        arguments[i] = dvec;
                        logger.debug("  [+] argument={}", Arrays.toString((double[])dvec));
                        continue;
                    }
                    if (String[].class.equals((Object)types[i])) {
                        Object[] svec;
                        logger.debug("  [+] handling parameter as type String[]");
                        arguments[i] = svec = RESTServer.splitArrayString(stringValue);
                        logger.debug("  [+] argument={}", Arrays.toString(svec));
                        continue;
                    }
                    logger.debug("  [+] handling parameter as type String");
                    arguments[i] = stringValue;
                    continue;
                }
                catch (IllegalArgumentException e) {
                    String msg4 = String.format("Argument failure with parameter '%s'", p.getName());
                    logger.warn(msg4);
                    ret.put("text", msg4);
                    ret.put("cmd_syntax", RESTServer.getMethodDeclarationStrings(cmd));
                    return RESTServer.responseData(request, response, ret, false);
                }
            }
            try {
                logger.debug("Invoking method...");
                Object returnObject = ((Method)matchMethod).invoke(GaiaSky.instance.scripting(), arguments);
                if (returnObject == null) {
                    logger.debug("Method returned: '{}', return type is {}", returnObject, matchReturnType);
                } else {
                    logger.debug("Method returned: '{}', isArray={}", returnObject, returnObject.getClass().isArray());
                }
                ret.put("value", returnObject);
            }
            catch (Exception e) {
                logger.error(e);
            }
            return RESTServer.responseData(request, response, ret, true);
        }
        logger.debug("No suitable method found.");
        if (methodNameMatches) {
            msg = String.format("Failed: command name '%s' found, but arguments not compatible.See syntax in 'cmd_syntax'.", cmd);
            ret.put("cmd_syntax", RESTServer.getMethodDeclarationStrings(cmd));
        } else {
            msg = String.format("Failed: command name '%s' not found. See syntax in 'cmd_syntax'.", cmd);
            ret.put("cmd_syntax", RESTServer.getMethodDeclarationStrings(""));
        }
        logger.warn(msg);
        ret.put("text", msg);
        return RESTServer.responseData(request, response, ret, false);
    }

    private static String handleAPIv2Call(Request request, Response response, ModuleDesc module) {
        String msg;
        RESTServer.loggerRequestInfo(request);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (!activated) {
            String msg2 = "GUI not yet initialized. Please wait...";
            logger.warn(msg2);
            ret.put("text", msg2);
            return RESTServer.responseData(request, response, ret, false);
        }
        String cmd = request.params(":cmd");
        Set queryParams = request.queryParams();
        if ("help".equals(cmd)) {
            logger.debug("Help command received");
            if (module.path().getParent() == null) {
                ret.put("text", "Help: see 'modules' for information on the available modules. Use each module as a path to access its methods.");
                ret.put("modules", RESTServer.getModuleDeclarations(module));
            } else {
                ret.put("text", "Help: see 'cmd_syntax' for command reference. Vectors are comma-separated.");
                ret.put("cmd_syntax", RESTServer.getMethodDeclarationStrings("", module));
            }
            return RESTServer.responseData(request, response, ret, true);
        }
        if ("debugCall".equals(cmd)) {
            logger.debug("debugCall received. What to do now?");
            ret.put("text", "debugCall data");
            return RESTServer.responseData(request, response, ret, true);
        }
        logger.debug("Method matching...");
        Executable matchMethod = null;
        boolean methodNameMatches = false;
        if (module.methodMap() == null || !module.methodMap().containsKey(cmd)) {
            Array<ModuleDesc> innerModules = module.modules();
            for (ModuleDesc im : innerModules) {
                if (!cmd.equals(im.name())) continue;
                response.redirect(im.name() + "/help");
                return null;
            }
            logger.debug("No suitable method found.");
            String msg3 = String.format("Failed: command name '%s' not found. See syntax in 'cmd_syntax'.", cmd);
            ret.put("cmd_syntax", RESTServer.getMethodDeclarationStrings("", module));
            logger.warn(msg3);
            ret.put("text", msg3);
            return RESTServer.responseData(request, response, ret, false);
        }
        Array<Method> matchMethods = module.methodMap().get(cmd);
        for (int i = 0; i < matchMethods.size; ++i) {
            boolean numParametersMatch;
            Method m = (Method)matchMethods.get(i);
            logger.debug("match check cmd={} with method={}...", cmd, m.getName());
            if (!m.getName().equals(cmd)) continue;
            logger.debug("  [+] name matches");
            methodNameMatches = true;
            Parameter[] methodParams = ((Method)matchMethods.get(i)).getParameters();
            boolean bl = numParametersMatch = methodParams.length == queryParams.size();
            if (!numParametersMatch) {
                logger.debug(" [+] number of parameters does not match");
                continue;
            }
            boolean allMethodParamsFullfilled = true;
            int pi = 0;
            for (Parameter p : methodParams) {
                if (!queryParams.contains(p.getName()) && !queryParams.contains("arg" + pi)) {
                    allMethodParamsFullfilled = false;
                    logger.debug("  [+] method parameters not present");
                    break;
                }
                ++pi;
            }
            if (!allMethodParamsFullfilled) continue;
            logger.debug("  [+] all method parameters present");
            matchMethod = m;
            break;
        }
        if (matchMethod != null) {
            logger.debug("Suitable method found: {}", RESTServer.methodDeclarationString(matchMethod));
            Parameter[] matchParameters = matchMethod.getParameters();
            Class<?> matchReturnType = ((Method)matchMethod).getReturnType();
            Object[] arguments = new Object[matchParameters.length];
            Class[] types = new Class[matchParameters.length];
            logger.debug("Preparing method arguments...");
            for (int i = 0; i < matchParameters.length; ++i) {
                Parameter p = matchParameters[i];
                Object paramName = p.getName();
                String stringValue = request.queryParams((String)paramName);
                if (stringValue == null) {
                    paramName = "arg" + i;
                    stringValue = request.queryParams((String)paramName);
                }
                logger.debug("  [+] handling parameter '{}'", paramName);
                types[i] = p.getType();
                logger.debug("  [+] parameter getType = '{}', isPrimitive = {}", p.getType().getSimpleName(), p.getType().isPrimitive());
                try {
                    int vi;
                    Object[] dvec;
                    if (Integer.TYPE.equals(types[i]) || Integer.class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type int");
                        arguments[i] = Integer.parseInt(stringValue);
                        continue;
                    }
                    if (Long.TYPE.equals(types[i]) || Long.class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type long");
                        arguments[i] = Long.parseLong(stringValue);
                        continue;
                    }
                    if (Float.TYPE.equals(types[i]) || Float.class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type float");
                        arguments[i] = Float.valueOf(Float.parseFloat(stringValue));
                        continue;
                    }
                    if (Double.TYPE.equals(types[i]) || Double.class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type double");
                        arguments[i] = Double.parseDouble(stringValue);
                        continue;
                    }
                    if (Boolean.TYPE.equals(types[i]) || Boolean.class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type boolean");
                        arguments[i] = Boolean.parseBoolean(stringValue);
                        continue;
                    }
                    if (int[].class.equals((Object)types[i]) || Integer[].class.equals((Object)types[i])) {
                        logger.debug("handling parameter as type int[]");
                        String[] svec = RESTServer.splitArrayString(stringValue);
                        dvec = new int[svec.length];
                        for (vi = 0; vi < svec.length; ++vi) {
                            dvec[vi] = Integer.parseInt(svec[vi]);
                        }
                        arguments[i] = dvec;
                        logger.debug("  [+] argument={}", Arrays.toString(dvec));
                        continue;
                    }
                    if (float[].class.equals((Object)types[i]) || Float[].class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type float[]");
                        String[] svec = RESTServer.splitArrayString(stringValue);
                        dvec = new float[svec.length];
                        for (vi = 0; vi < svec.length; ++vi) {
                            dvec[vi] = (int)Float.parseFloat(svec[vi]);
                        }
                        arguments[i] = dvec;
                        logger.debug("  [+] argument={}", Arrays.toString((float[])dvec));
                        continue;
                    }
                    if (double[].class.equals((Object)types[i]) || Double[].class.equals((Object)types[i])) {
                        logger.debug("  [+] handling parameter as type double[]");
                        String[] svec = RESTServer.splitArrayString(stringValue);
                        dvec = new double[svec.length];
                        for (vi = 0; vi < svec.length; ++vi) {
                            dvec[vi] = (int)Double.parseDouble(svec[vi]);
                        }
                        arguments[i] = dvec;
                        logger.debug("  [+] argument={}", Arrays.toString((double[])dvec));
                        continue;
                    }
                    if (String[].class.equals((Object)types[i])) {
                        Object[] svec;
                        logger.debug("  [+] handling parameter as type String[]");
                        arguments[i] = svec = RESTServer.splitArrayString(stringValue);
                        logger.debug("  [+] argument={}", Arrays.toString(svec));
                        continue;
                    }
                    logger.debug("  [+] handling parameter as type String");
                    arguments[i] = stringValue;
                    continue;
                }
                catch (IllegalArgumentException e) {
                    String msg4 = String.format("Argument failure with parameter '%s'", p.getName());
                    logger.warn(msg4);
                    ret.put("text", msg4);
                    ret.put("cmd_syntax", RESTServer.getMethodDeclarationStrings(cmd, module));
                    return RESTServer.responseData(request, response, ret, false);
                }
            }
            try {
                logger.debug("Invoking method...");
                Object moduleInstance = RESTServer.getModuleInstance(module.clazz());
                Object returnObject = ((Method)matchMethod).invoke(moduleInstance, arguments);
                if (returnObject == null) {
                    logger.debug("Method returned: '{}', return type is {}", returnObject, matchReturnType);
                } else {
                    logger.debug("Method returned: '{}', isArray={}", returnObject, returnObject.getClass().isArray());
                }
                ret.put("value", returnObject);
            }
            catch (Exception e) {
                logger.error(e);
            }
            return RESTServer.responseData(request, response, ret, true);
        }
        logger.debug("No suitable method found.");
        if (methodNameMatches) {
            msg = String.format("Failed: command name '%s' found, but arguments not compatible.See syntax in 'cmd_syntax'.", cmd);
            ret.put("cmd_syntax", RESTServer.getMethodDeclarationStrings(cmd, module));
        } else {
            msg = String.format("Failed: command name '%s' not found. See syntax in 'cmd_syntax'.", cmd);
            ret.put("cmd_syntax", RESTServer.getMethodDeclarationStrings("", module));
        }
        logger.warn(msg);
        ret.put("text", msg);
        return RESTServer.responseData(request, response, ret, false);
    }

    private static Object getModuleInstance(Class<?> clazz) {
        APIv2 apiv2 = ((EventScriptingInterface)GaiaSky.instance.scripting()).apiv2;
        return apiv2.getModuleInstance(clazz);
    }

    public static void initialize(Integer rest_port) {
        if (rest_port < 1024) {
            logger.error("You are trying to bind a reserved port (" + rest_port + " < 1024). Please, choose a port greater than 1024 and try again.");
            logger.error("You need superuser permissions to bind reserved ports, but running Gaia Sky with root privileges is STRONGLY DISCOURAGED!");
            logger.error("Proceed at your own risk.");
        }
        if (rest_port > 49151) {
            logger.error("Your port (" + rest_port + ") is not in the user ports range [1024, 49151]. Please, choose a port in this range and try again.");
            logger.error("Proceed at your own risk.");
        }
        int port = rest_port;
        RESTServer.printStartupInfo();
        if (port < 0) {
            logger.error("Error: invalid port. REST API inactive.");
            return;
        }
        try {
            logger.info("Starting REST APIv1 server on http://localhost:{}/api/", port);
            logger.info("   See available calls at http://localhost:{}/api/help", port);
            logger.info("Starting REST APIv2 server on http://localhost:{}/apiv2/", port);
            logger.info("   See available calls at http://localhost:{}/apiv2/help", port);
            Spark.port((int)port);
            Map<String, Array<Method>> apiV1Methods = RESTServer.addAPIv1Methods();
            Spark.get((String)"/api", (request, response) -> {
                response.redirect("/api/help");
                return response;
            });
            Spark.get((String)"/api/:cmd", (request, response) -> RESTServer.handleAPIv1Call(request, response, apiV1Methods));
            Spark.post((String)"/api/:cmd", (request, response) -> RESTServer.handleAPIv1Call(request, response, apiV1Methods));
            ModuleDesc apiV2Modules = RESTServer.constructAPIv2Modules();
            RESTServer.apiv2Mappings(apiV2Modules);
            logger.info("Startup finished.");
        }
        catch (Exception e) {
            logger.error(e, "Caught an exception during initialization:");
        }
    }

    private static Map<String, Array<Method>> addAPIv1Methods() {
        Method[] allMethods;
        HashMap<String, Array<Method>> apiv1Methods = new HashMap<String, Array<Method>>();
        Class<IScriptingInterface> iScriptingInterfaceClass = IScriptingInterface.class;
        for (Method method : allMethods = iScriptingInterfaceClass.getDeclaredMethods()) {
            Array matches = apiv1Methods.containsKey(method.getName()) ? (Array)apiv1Methods.get(method.getName()) : new Array(false, 1);
            if (!matches.contains((Object)method, true)) {
                matches.add((Object)method);
            }
            apiv1Methods.put(method.getName(), (Array<Method>)matches);
        }
        return apiv1Methods;
    }

    private static ModuleDesc constructAPIv2Modules() {
        return ModuleDesc.of(Path.of("apiv2", new String[0]), APIv2.class);
    }

    private static void apiv2Mappings(ModuleDesc module) {
        Path path = module.path();
        Spark.get((String)("/" + String.valueOf(path)), (request, response) -> {
            response.redirect("/" + String.valueOf(path) + "/help");
            return response;
        });
        Spark.get((String)("/" + String.valueOf(path) + "/:cmd"), (request, response) -> RESTServer.handleAPIv2Call(request, response, module));
        Spark.post((String)("/" + String.valueOf(path) + "/:cmd"), (request, response) -> RESTServer.handleAPIv2Call(request, response, module));
        if (module.modules() != null && !module.modules().isEmpty()) {
            for (ModuleDesc child : module.modules()) {
                RESTServer.apiv2Mappings(child);
            }
        }
    }

    public static void activate() {
        activated = true;
    }

    public static void dispose() {
        try {
            if (!shutdownTriggered) {
                shutdownTriggered = true;
                logger.info("Stopping server gracefully...");
                Spark.stop();
                logger.info("Server now stopped.");
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
    }
}

