/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Archetype {
    private final Engine engine;
    private final Archetype parent;
    private final Family family;
    private final String name;
    private final Set<Class<? extends Component>> components;

    @SafeVarargs
    public Archetype(Engine engine, Archetype parent, String name, Class<? extends Component> ... componentClasses) {
        this.engine = engine;
        this.parent = parent;
        int lastIndex = name.lastIndexOf(46);
        this.name = lastIndex >= 0 ? name.substring(lastIndex + 1) : name;
        this.components = new HashSet<Class<? extends Component>>(componentClasses.length);
        Collections.addAll(this.components, componentClasses);
        this.family = Family.all((Class[])componentClasses).get();
    }

    @SafeVarargs
    public Archetype(Engine engine, String name, Class<? extends Component> ... componentClasses) {
        this(engine, null, name, componentClasses);
    }

    public Family getFamily() {
        return this.family;
    }

    public Entity createEntity() {
        Entity entity = this.engine.createEntity();
        this.addComponentsRecursive(entity);
        if (Mapper.base.has(entity)) {
            ((Base)Mapper.base.get((Entity)entity)).archetype = this;
        }
        return entity;
    }

    public void addComponentsRecursive(Entity entity) {
        if (this.parent != null) {
            this.parent.addComponentsRecursive(entity);
        }
        for (Class<? extends Component> component : this.components) {
            try {
                Component c = (Component)ClassReflection.newInstance(component);
                entity.add(c);
            }
            catch (ReflectionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int numComponents() {
        int n = 0;
        Archetype current = this;
        while (current != null) {
            n += current.components.size();
            current = current.parent;
        }
        return n;
    }

    public boolean hasComponent(Component component) {
        Archetype current = this;
        while (current != null) {
            for (Class<? extends Component> componentClass : current.components) {
                if (!component.getClass().equals(componentClass)) continue;
                return true;
            }
            current = current.parent;
        }
        return false;
    }

    public boolean matches(Entity entity) {
        ImmutableArray entityComponents = entity.getComponents();
        if (entityComponents.size() != this.numComponents()) {
            return false;
        }
        for (Component component : entityComponents) {
            if (this.hasComponent(component)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

