/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import gaiasky.scene.Archetype;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.util.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Archetypes {
    private static final Logger.Log logger = Logger.getLogger(Archetypes.class);
    protected Map<String, Archetype> archetypes;
    private Engine engine;

    public void initialize(Engine engine) {
        this.engine = engine;
        this.archetypes = this.initializeArchetypes();
    }

    public boolean contains(String key) {
        return this.archetypes.containsKey(key);
    }

    public Archetype get(String key) {
        return this.archetypes.get(key);
    }

    public Archetype get(Class archetypeClass) {
        return this.archetypes.get(archetypeClass.getName());
    }

    public Archetype findArchetype(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        if (base != null && base.archetype != null) {
            return base.archetype;
        }
        Collection<Archetype> archetypes = this.archetypes.values();
        for (Archetype archetype : archetypes) {
            if (!archetype.matches(entity)) continue;
            return archetype;
        }
        return null;
    }

    private String[] modelNames(String ... classNames) {
        String[] result = new String[classNames.length * 2];
        int i = 0;
        for (String name : classNames) {
            result[i++] = name;
            result[i++] = this.modelName(name);
        }
        return result;
    }

    private String modelName(String className) {
        return "gaiasky.scenegraph." + className;
    }

    public Map<String, Archetype> initializeArchetypes() {
        if (this.engine != null) {
            this.archetypes = new HashMap<String, Archetype>();
            JsonReader reader = new JsonReader();
            FileHandle attributeMapFile = Gdx.files.internal("archetypes/archetypes.json");
            JsonValue root = reader.parse(attributeMapFile);
            if (root.has("archetypes")) {
                int numArchetypes = 0;
                JsonValue archetypesElement = root.get("archetypes");
                for (JsonValue archetypeElement = archetypesElement.child; archetypeElement != null; archetypeElement = archetypeElement.next()) {
                    String[] aliases = archetypeElement.has("aliases") ? archetypeElement.get("aliases").asStringArray() : null;
                    int numNames = aliases != null ? aliases.length + 1 : 1;
                    String[] names = new String[numNames];
                    names[0] = archetypeElement.name;
                    if (aliases != null) {
                        System.arraycopy(aliases, 0, names, 1, aliases.length);
                    }
                    String parent = archetypeElement.getString("parent");
                    String[] componentsString = archetypeElement.get("components").asStringArray();
                    Class[] components = new Class[componentsString.length];
                    int j = 0;
                    for (String componentString : componentsString) {
                        componentString = componentString.replace("*", "");
                        try {
                            Class<?> clazz;
                            String packageName = componentString.startsWith("Tag") ? "gaiasky.scene.component.tag." : "gaiasky.scene.component.";
                            components[j] = clazz = Class.forName(packageName + componentString);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        ++j;
                    }
                    this.addArchetype(names, parent, components);
                    ++numArchetypes;
                }
                logger.debug("Initialized " + numArchetypes + " archetypes");
            }
            return this.archetypes;
        }
        throw new RuntimeException("Can't create archetypes: the engine is null!");
    }

    @SafeVarargs
    private void addArchetype(String archetypeName, String parentArchetypeName, Class<? extends Component> ... classes) {
        Archetype parent = null;
        if (parentArchetypeName != null && this.archetypes.containsKey(parentArchetypeName)) {
            parent = this.archetypes.get(parentArchetypeName);
        }
        this.archetypes.put(archetypeName, new Archetype(this.engine, parent, archetypeName, classes));
    }

    @SafeVarargs
    private void addArchetype(String[] archetypeNames, String parentArchetypeName, Class<? extends Component> ... classes) {
        for (String archetypeName : archetypeNames) {
            this.addArchetype(archetypeName, parentArchetypeName, classes);
        }
    }

    @SafeVarargs
    private void addArchetype(String archetypeName, Class<? extends Component> ... classes) {
        this.addArchetype(archetypeName, (String)null, classes);
    }

    @SafeVarargs
    private void addArchetype(String[] archetypeNames, Class<? extends Component> ... classes) {
        for (String archetypeName : archetypeNames) {
            this.addArchetype(archetypeName, classes);
        }
    }
}

