/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene;

import com.badlogic.ashley.core.Component;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import gaiasky.util.Logger;
import java.util.HashMap;
import java.util.Map;

public class AttributeMap {
    private static final Logger.Log logger = Logger.getLogger(AttributeMap.class);
    private final Map<String, Class<? extends Component>> attributeMap = new HashMap<String, Class<? extends Component>>();

    public Class<? extends Component> get(String key) {
        return this.attributeMap.get(key);
    }

    public boolean containsKey(String key) {
        return this.attributeMap.containsKey(key);
    }

    public Map<String, Class<? extends Component>> initialize() {
        JsonReader reader = new JsonReader();
        FileHandle attributeMapFile = Gdx.files.internal("archetypes/attributemap.json");
        JsonValue root = reader.parse(attributeMapFile);
        if (root.has("components")) {
            int numComponents = 0;
            JsonValue components = root.get("components");
            for (JsonValue component = components.child; component != null; component = component.next()) {
                String name = component.name;
                String className = "gaiasky.scene.component." + name;
                Array attributes = new Array();
                for (JsonValue attribute = component.child; attribute != null; attribute = attribute.next()) {
                    if (attribute.name.equalsIgnoreCase("description")) continue;
                    attributes.add((Object)attribute.name);
                    if (!attribute.hasChild("aliases")) continue;
                    Object[] aliases = attribute.get("aliases").asStringArray();
                    attributes.addAll(aliases);
                }
                try {
                    Class<?> clazz = Class.forName(className);
                    this.putAll(clazz, (Array<String>)attributes);
                }
                catch (ClassNotFoundException e) {
                    logger.error("Component Class not found: " + className);
                }
                catch (ClassCastException e) {
                    logger.error("Component Class does not implement gaiasky.scene.component.Component: " + className);
                }
                ++numComponents;
            }
            logger.debug("Initialized " + numComponents + " components");
        }
        return this.attributeMap;
    }

    private void putAll(Class<? extends Component> clazz, Array<String> attributes) {
        for (String attribute : attributes) {
            if (this.attributeMap.containsKey(attribute)) {
                logger.warn("Attribute already defined: " + attribute);
                throw new RuntimeException("Attribute already defined: " + attribute);
            }
            this.attributeMap.put(attribute, clazz);
        }
    }
}

