/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.IntMap;
import gaiasky.scene.Archetype;
import gaiasky.scene.Archetypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Focus;
import gaiasky.scene.component.Hip;
import gaiasky.scene.component.Id;
import gaiasky.scene.component.LocationMark;
import gaiasky.scene.component.Octree;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.Perimeter;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.record.Position;
import gaiasky.scene.view.PositionView;
import gaiasky.util.FastStringObjectMap;
import gaiasky.util.Logger;
import gaiasky.util.i18n.I18n;
import gaiasky.util.tree.IPosition;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class Index {
    private static final Logger.Log logger = Logger.getLogger(Index.class);
    protected final FastStringObjectMap<Entity> index;
    protected final IntMap<IPosition> hipMap;
    protected Archetypes archetypes;

    public Index(Archetypes archetypes, int numberEntities) {
        this.archetypes = archetypes;
        this.index = new FastStringObjectMap<Entity>((int)((double)numberEntities * 1.25), Entity.class);
        this.hipMap = new IntMap(151250, 0.9f);
    }

    public Entity getEntity(String name) {
        name = name.toLowerCase(Locale.ROOT).strip();
        return this.index.get(name);
    }

    public boolean containsEntity(String name) {
        return this.index.containsKey(name.toLowerCase(Locale.ROOT).trim());
    }

    public boolean addToIndex(Entity entity) {
        boolean ok = true;
        Base base = (Base)Mapper.base.get(entity);
        if (base != null && base.names != null) {
            Archetype starArchetype;
            if (this.mustAddToIndex(entity)) {
                for (String name : base.names) {
                    boolean same;
                    String nameLowerCase = name.toLowerCase(Locale.ROOT).trim();
                    if (!this.index.containsKey(nameLowerCase)) {
                        this.index.put(nameLowerCase, entity);
                        continue;
                    }
                    if (nameLowerCase.isEmpty()) continue;
                    Entity conflict = this.index.get(nameLowerCase);
                    Base conflictBase = (Base)Mapper.base.get(conflict);
                    Archetype entityArchetype = conflictBase.archetype;
                    Archetype conflictArchetype = ((Base)Mapper.base.get((Entity)conflict)).archetype;
                    logger.debug(I18n.msg("error.name.conflict", name + " (" + entityArchetype.getName().toLowerCase(Locale.ROOT) + ")", conflictBase.getName() + " (" + conflictArchetype.getName().toLowerCase(Locale.ROOT) + ")"));
                    String[] names1 = base.names;
                    String[] names2 = conflictBase.names;
                    boolean bl = same = names1.length == names2.length;
                    if (same) {
                        for (int i = 0; i < names1.length; ++i) {
                            same = same && names1[i].equals(names2[i]);
                        }
                    }
                    if (same) {
                        same = entityArchetype == conflictArchetype;
                    }
                    ok = !same;
                }
                Id id = (Id)Mapper.id.get(entity);
                if (id != null && id.id > 0L) {
                    String idString = String.valueOf(id.id);
                    this.index.put(idString, entity);
                }
            }
            if ((starArchetype = this.archetypes.get("gaiasky.scenegraph.Star")).matches(entity)) {
                Hip hip = (Hip)Mapper.hip.get(entity);
                if (hip.hip > 0) {
                    String hipid = "hip " + hip.hip;
                    this.index.put(hipid, entity);
                }
            }
            this.addParticleSet(entity, (ParticleSet)Mapper.particleSet.get(entity));
            this.addParticleSet(entity, (ParticleSet)Mapper.starSet.get(entity));
        }
        if (!ok) {
            logger.warn(I18n.msg("error.object.exists", base.getName() + "(" + this.archetypes.findArchetype(entity).getName() + ")"));
        }
        return ok;
    }

    private void addParticleSet(Entity entity, ParticleSet particleSet) {
        if (particleSet != null && particleSet.index != null) {
            String[] keys;
            for (String key : keys = particleSet.index.keys()) {
                if (key == null) continue;
                this.index.put(key, entity);
            }
        }
    }

    public IntMap<IPosition> getHipMap() {
        return this.hipMap;
    }

    public void addToHipMap(Entity entity) {
        block6: {
            block7: {
                block5: {
                    if (!Mapper.octree.has(entity)) break block5;
                    Octree octree = (Octree)Mapper.octree.get(entity);
                    Set<Entity> set = octree.parenthood.keySet();
                    for (Entity e : set) {
                        this.addToHipMap(e);
                    }
                    break block6;
                }
                Archetype starArchetype = this.archetypes.get("gaiasky.scenegraph.Star");
                if (!starArchetype.matches(entity)) break block7;
                Hip hip = (Hip)Mapper.hip.get(entity);
                if (hip.hip <= 0) break block6;
                if (this.hipMap.containsKey(hip.hip)) {
                    logger.debug(I18n.msg("error.id.hip.duplicate", hip.hip));
                } else {
                    this.hipMap.put(hip.hip, (Object)new PositionView(entity));
                }
                break block6;
            }
            if (Mapper.starSet.has(entity)) {
                StarSet starSet = (StarSet)Mapper.starSet.get(entity);
                List<IParticleRecord> stars = starSet.data();
                for (IParticleRecord pb : stars) {
                    if (pb.hip() <= 0) continue;
                    this.hipMap.put(pb.hip(), (Object)new Position(pb.x(), pb.y(), pb.z(), pb.vx(), pb.vy(), pb.vz()));
                }
            }
        }
    }

    private boolean mustAddToIndex(Entity entity) {
        return entity.getComponent(Perimeter.class) == null && entity.getComponent(LocationMark.class) == null && entity.getComponent(ParticleSet.class) == null && entity.getComponent(StarSet.class) == null;
    }

    public void remove(String key) {
        this.index.remove(key);
    }

    public void remove(String[] keys) {
        for (String key : keys) {
            this.index.remove(key);
        }
    }

    public void remove(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        if (base.names != null) {
            ParticleSet set;
            for (String name : base.names) {
                this.index.remove(name.toLowerCase(Locale.ROOT).trim());
            }
            if (base.id > 0L) {
                String id = String.valueOf(base.id);
                this.index.remove(id);
            }
            if (Mapper.hip.has(entity)) {
                Hip hip = (Hip)Mapper.hip.get(entity);
                this.hipMap.remove(hip.hip);
            }
            if (Mapper.particleSet.has(entity)) {
                set = (ParticleSet)Mapper.particleSet.get(entity);
                this.removeFromIndex(set);
            }
            if (Mapper.starSet.has(entity)) {
                set = (StarSet)Mapper.starSet.get(entity);
                this.removeFromIndex(set);
            }
        }
    }

    public void removeFromIndex(ParticleSet set) {
        if (set.index != null) {
            String[] keys;
            for (String key : keys = set.index.keys()) {
                if (key == null) continue;
                this.index.remove(key);
            }
        }
    }

    public void matchingFocusableNodes(String name, SortedSet<String> results, int maxResults, AtomicBoolean abort) {
        Focus focus;
        Entity entity;
        String[] keys = this.index.keys();
        name = name.toLowerCase(Locale.ROOT).trim();
        int i = 0;
        for (String key : keys) {
            if (key == null) continue;
            if (abort != null && abort.get()) {
                return;
            }
            entity = this.index.get(key);
            focus = (Focus)Mapper.focus.get(entity);
            if (focus != null && focus.focusable && key.startsWith(name)) {
                results.add(key);
                ++i;
            }
            if (i < maxResults) continue;
            return;
        }
        for (String key : keys) {
            if (key == null) continue;
            if (abort != null && abort.get()) {
                return;
            }
            entity = this.index.get(key);
            focus = (Focus)Mapper.focus.get(entity);
            if (focus != null && focus.focusable && key.contains(name)) {
                results.add(key);
                ++i;
            }
            if (i < maxResults) continue;
            return;
        }
    }
}

