/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.core.PooledEngine;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.ComponentTypes;
import gaiasky.render.api.ISceneRenderer;
import gaiasky.scene.Archetype;
import gaiasky.scene.Archetypes;
import gaiasky.scene.Families;
import gaiasky.scene.Index;
import gaiasky.scene.Mapper;
import gaiasky.scene.SceneObserver;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Coordinates;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.ICopy;
import gaiasky.scene.component.IDisposable;
import gaiasky.scene.component.Octant;
import gaiasky.scene.component.Octree;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.component.tag.TagCopy;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.initialize.AxesInitializer;
import gaiasky.scene.system.initialize.BackgroundModelInitializer;
import gaiasky.scene.system.initialize.BaseInitializer;
import gaiasky.scene.system.initialize.BillboardSetInitializer;
import gaiasky.scene.system.initialize.BoundariesInitializer;
import gaiasky.scene.system.initialize.ClusterInitializer;
import gaiasky.scene.system.initialize.ConstellationInitializer;
import gaiasky.scene.system.initialize.DatasetDescriptionInitializer;
import gaiasky.scene.system.initialize.ElementsSetInitializer;
import gaiasky.scene.system.initialize.FadeNodeInitializer;
import gaiasky.scene.system.initialize.GridRecInitializer;
import gaiasky.scene.system.initialize.IndexInitializer;
import gaiasky.scene.system.initialize.InvisibleInitializer;
import gaiasky.scene.system.initialize.KeyframeInitializer;
import gaiasky.scene.system.initialize.LocInitializer;
import gaiasky.scene.system.initialize.MeshInitializer;
import gaiasky.scene.system.initialize.ModelInitializer;
import gaiasky.scene.system.initialize.ParticleInitializer;
import gaiasky.scene.system.initialize.ParticleSetInitializer;
import gaiasky.scene.system.initialize.PerimeterInitializer;
import gaiasky.scene.system.initialize.RaymarchingInitializer;
import gaiasky.scene.system.initialize.RulerInitializer;
import gaiasky.scene.system.initialize.SceneGraphBuilderSystem;
import gaiasky.scene.system.initialize.ShapeInitializer;
import gaiasky.scene.system.initialize.TLEInitializer;
import gaiasky.scene.system.initialize.TrajectoryInitializer;
import gaiasky.scene.system.initialize.VRDeviceInitializer;
import gaiasky.scene.system.initialize.VertsInitializer;
import gaiasky.scene.system.initialize.VolumeInitializer;
import gaiasky.scene.system.render.extract.AbstractExtractSystem;
import gaiasky.scene.system.render.extract.AxesExtractor;
import gaiasky.scene.system.render.extract.BackgroundExtractor;
import gaiasky.scene.system.render.extract.BillboardSetExtractor;
import gaiasky.scene.system.render.extract.BoundariesExtractor;
import gaiasky.scene.system.render.extract.ClusterExtractor;
import gaiasky.scene.system.render.extract.ConstellationExtractor;
import gaiasky.scene.system.render.extract.ElementsSetExtractor;
import gaiasky.scene.system.render.extract.GridRecExtractor;
import gaiasky.scene.system.render.extract.InvisibleExtractor;
import gaiasky.scene.system.render.extract.KeyframeExtractor;
import gaiasky.scene.system.render.extract.LocExtractor;
import gaiasky.scene.system.render.extract.MeshExtractor;
import gaiasky.scene.system.render.extract.ModelExtractor;
import gaiasky.scene.system.render.extract.OctreeExtractor;
import gaiasky.scene.system.render.extract.ParticleExtractor;
import gaiasky.scene.system.render.extract.ParticleSetExtractor;
import gaiasky.scene.system.render.extract.PerimeterExtractor;
import gaiasky.scene.system.render.extract.RaymarchingExtractor;
import gaiasky.scene.system.render.extract.RulerExtractor;
import gaiasky.scene.system.render.extract.ShapeExtractor;
import gaiasky.scene.system.render.extract.TrajectoryExtractor;
import gaiasky.scene.system.render.extract.VRDeviceExtractor;
import gaiasky.scene.system.render.extract.VertsExtractor;
import gaiasky.scene.system.update.AxesUpdater;
import gaiasky.scene.system.update.BackgroundUpdater;
import gaiasky.scene.system.update.BillboardSetUpdater;
import gaiasky.scene.system.update.ClusterUpdater;
import gaiasky.scene.system.update.ConstellationUpdater;
import gaiasky.scene.system.update.DatasetDescriptionUpdater;
import gaiasky.scene.system.update.ElementsSetUpdater;
import gaiasky.scene.system.update.EntityUpdater;
import gaiasky.scene.system.update.GraphUpdater;
import gaiasky.scene.system.update.GridRecUpdater;
import gaiasky.scene.system.update.KeyframeUpdater;
import gaiasky.scene.system.update.LocUpdater;
import gaiasky.scene.system.update.MeshUpdater;
import gaiasky.scene.system.update.ModelUpdater;
import gaiasky.scene.system.update.OctreeUpdater;
import gaiasky.scene.system.update.ParticleSetUpdater;
import gaiasky.scene.system.update.PerimeterUpdater;
import gaiasky.scene.system.update.RaymarchingUpdater;
import gaiasky.scene.system.update.RulerUpdater;
import gaiasky.scene.system.update.ShapeUpdater;
import gaiasky.scene.system.update.TrajectoryUpdater;
import gaiasky.scene.system.update.VRDeviceUpdater;
import gaiasky.scene.system.update.VertsUpdater;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Logger;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.time.ITimeFrameProvider;
import gaiasky.util.tree.IOctreeObject;
import gaiasky.util.tree.OctreeNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class Scene {
    public static final String ROOT_NAME = "Universe";
    private static final Logger.Log logger = Logger.getLogger(Scene.class);
    public Engine engine;
    private Index index;
    private ThreadLocal<HashMap<String, Entity>> copyIndex;
    private Families families;
    private Archetypes archetypes;
    private FocusView focusView;
    private Array<AbstractInitSystem> initializers;
    private IndexInitializer indexInitializer;
    private Array<EntityUpdater> updaters;
    private Array<AbstractExtractSystem> extractors;
    private int numberObjects = -1;
    private final Vector3Q aux3b = new Vector3Q();

    public Index index() {
        return this.index;
    }

    public Archetypes archetypes() {
        return this.archetypes;
    }

    public void initialize() {
        this.engine = new PooledEngine();
        this.focusView = new FocusView(this);
        this.families = new Families();
        this.archetypes = new Archetypes();
        this.archetypes.initialize(this.engine);
        Archetype rootArchetype = this.archetypes.get(ROOT_NAME);
        Entity root = rootArchetype.createEntity();
        Base base = (Base)root.getComponent(Base.class);
        base.setName(ROOT_NAME);
        this.engine.addEntity(root);
        new SceneObserver();
    }

    public void runOnce(EntitySystem ... systems) {
        this.enable(systems);
        this.engine.update(0.0f);
        this.disable(systems);
    }

    public void runOnce(Array<? extends EntitySystem> array) {
        this.enable(array);
        this.engine.update(0.0f);
        this.disable(array);
    }

    public void enable(EntitySystem ... systems) {
        for (EntitySystem system : systems) {
            this.engine.addSystem(system);
        }
    }

    public void enable(Array<? extends EntitySystem> array) {
        array.forEach(system -> this.engine.addSystem(system));
    }

    public void disable(EntitySystem ... systems) {
        for (EntitySystem system : systems) {
            this.engine.removeSystem(system);
        }
    }

    public void disable(Array<? extends EntitySystem> array) {
        array.forEach(system -> this.engine.removeSystem(system));
    }

    public void initializeEntities() {
        this.initializeEntities(false);
    }

    public void setUpEntities() {
        this.initializeEntities(true);
    }

    public void addSystemsToEngine(Array<?> systems) {
        if (this.engine != null) {
            for (Object system : systems) {
                this.engine.addSystem((EntitySystem)system);
            }
        }
    }

    private void addInitializer(AbstractInitSystem system) {
        this.initializers.add((Object)system);
    }

    private void addUpdater(EntityUpdater system) {
        this.updaters.add((Object)system);
    }

    private void addExtractor(AbstractExtractSystem system) {
        this.extractors.add((Object)system);
    }

    private void initializeEntities(boolean setUp) {
        if (this.engine != null) {
            int priority = 0;
            this.initializers = new Array(26);
            this.addInitializer(new BaseInitializer(this, setUp, this.families.graphNodes, priority++));
            this.addInitializer(new FadeNodeInitializer(this.index, setUp, this.families.fadeNodes, priority++));
            this.addInitializer(new ParticleSetInitializer(setUp, this.families.particleSets, priority++));
            this.addInitializer(new ParticleInitializer(setUp, this.families.particles, priority++));
            this.addInitializer(new ModelInitializer(setUp, this.families.models, priority++));
            this.addInitializer(new TrajectoryInitializer(setUp, this.families.orbits, priority++));
            this.addInitializer(new TLEInitializer(this, setUp, this.families.orbitsTLE, priority++));
            this.addInitializer(new VertsInitializer(setUp, this.families.verts, priority++));
            this.addInitializer(new LocInitializer(setUp, this.families.locations, priority++));
            this.addInitializer(new BillboardSetInitializer(setUp, this.families.billboardSets, priority++));
            this.addInitializer(new AxesInitializer(setUp, this.families.axes, priority++));
            this.addInitializer(new RaymarchingInitializer(setUp, this.families.raymarchings, priority++));
            this.addInitializer(new InvisibleInitializer(setUp, this.families.invisibles, priority++));
            this.addInitializer(new BackgroundModelInitializer(setUp, this.families.backgroundModels, priority++));
            this.addInitializer(new ClusterInitializer(setUp, this.families.clusters, priority++));
            this.addInitializer(new ConstellationInitializer(this, setUp, this.families.constellations, priority++));
            this.addInitializer(new BoundariesInitializer(setUp, this.families.boundaries, priority++));
            this.addInitializer(new ElementsSetInitializer(setUp, this.families.orbitalElementSets, priority++));
            this.addInitializer(new MeshInitializer(setUp, this.families.meshes, priority++));
            this.addInitializer(new GridRecInitializer(setUp, this.families.gridRecs, priority++));
            this.addInitializer(new RulerInitializer(setUp, this.families.rulers, priority++));
            this.addInitializer(new KeyframeInitializer(this, setUp, this.families.keyframes, priority++));
            this.addInitializer(new ShapeInitializer(setUp, this.families.shapes, priority++));
            this.addInitializer(new LocInitializer(setUp, this.families.locations, priority++));
            this.addInitializer(new PerimeterInitializer(setUp, this.families.perimeters, priority++));
            this.addInitializer(new VRDeviceInitializer(setUp, this.families.vrdevices, priority++));
            this.addInitializer(new DatasetDescriptionInitializer(setUp, this.families.catalogInfos, priority));
            this.addInitializer(new VolumeInitializer(setUp, this.families.volumes, priority));
            this.runOnce(this.initializers);
        }
    }

    public void initializeIndex() {
        if (this.engine != null) {
            int numEntities = this.engine.getEntities().size();
            this.index = new Index(this.archetypes, numEntities);
            this.copyIndex = ThreadLocal.withInitial(HashMap::new);
            this.indexInitializer = new IndexInitializer(this.index, Family.all((Class[])new Class[]{Base.class}).get(), 0);
            this.runOnce(new EntitySystem[]{this.indexInitializer});
        }
    }

    public void addToIndex(Entity entity) {
        if (Mapper.base.has(entity)) {
            this.indexInitializer.initializeEntity(entity);
        }
    }

    public void buildSceneGraph() {
        if (this.engine != null) {
            SceneGraphBuilderSystem sceneGraphBuilderSystem = new SceneGraphBuilderSystem(this.index, this.families.graphNodes, 0);
            this.runOnce(new EntitySystem[]{sceneGraphBuilderSystem});
            GraphNode rootGraph = (GraphNode)Mapper.graph.get(this.index.getEntity(ROOT_NAME));
            logger.info(I18n.msg("notif.sg.init", rootGraph.numChildren + 1));
        }
    }

    public void prepareUpdateSystems(ISceneRenderer sceneRenderer) {
        if (this.engine != null) {
            int priority = 0;
            this.updaters = new Array(25);
            this.addUpdater(new ConstellationUpdater(this.families.constellations, priority++));
            GraphUpdater sceneGraphUpdateSystem = new GraphUpdater(this.families.roots, priority++, GaiaSky.instance.time);
            sceneGraphUpdateSystem.setCamera(GaiaSky.instance.getCameraManager());
            this.addUpdater(sceneGraphUpdateSystem);
            this.addUpdater(new OctreeUpdater(this, this.families.octrees, priority++));
            this.addUpdater(new DatasetDescriptionUpdater(this.families.datasets, priority++));
            this.addUpdater(new ElementsSetUpdater(this.families.orbitalElementSets, priority++));
            this.addUpdater(new ParticleSetUpdater(this.families.particleSets, priority++));
            this.addUpdater(new ModelUpdater(this.families.models, priority++));
            this.addUpdater(new TrajectoryUpdater(this.families.orbits, priority++));
            this.addUpdater(new VertsUpdater(this.families.verts, priority++));
            this.addUpdater(new BackgroundUpdater(this.families.backgroundModels, priority++));
            this.addUpdater(new ClusterUpdater(this.families.clusters, priority++));
            this.addUpdater(new RaymarchingUpdater(this.families.raymarchings, priority++));
            this.addUpdater(new BillboardSetUpdater(this.families.billboardSets, priority++));
            this.addUpdater(new MeshUpdater(this.families.meshes, priority++));
            this.addUpdater(new GridRecUpdater(this.families.gridRecs, priority++));
            this.addUpdater(new RulerUpdater(this.families.rulers, priority++));
            this.addUpdater(new AxesUpdater(this.families.axes, priority++));
            this.addUpdater(new KeyframeUpdater(this.families.keyframes, priority++));
            this.addUpdater(new ShapeUpdater(this.families.shapes, priority++));
            this.addUpdater(new LocUpdater(this.families.locations, priority++));
            this.addUpdater(new PerimeterUpdater(this.families.perimeters, priority++));
            this.addUpdater(new VRDeviceUpdater(this.families.vrdevices, priority++));
            this.extractors = new Array(23);
            this.addExtractor(this.newExtractor(VRDeviceExtractor.class, this.families.vrdevices, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(OctreeExtractor.class, this.families.octrees, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(ElementsSetExtractor.class, this.families.orbitalElementSets, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(ParticleSetExtractor.class, this.families.particleSets, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(ParticleExtractor.class, this.families.particles, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(ModelExtractor.class, this.families.models, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(TrajectoryExtractor.class, this.families.orbits, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(VertsExtractor.class, this.families.verts, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(BackgroundExtractor.class, this.families.backgroundModels, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(ClusterExtractor.class, this.families.clusters, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(BillboardSetExtractor.class, this.families.billboardSets, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(ConstellationExtractor.class, this.families.constellations, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(BoundariesExtractor.class, this.families.boundaries, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(MeshExtractor.class, this.families.meshes, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(GridRecExtractor.class, this.families.gridRecs, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(RulerExtractor.class, this.families.rulers, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(AxesExtractor.class, this.families.axes, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(KeyframeExtractor.class, this.families.keyframes, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(ShapeExtractor.class, this.families.shapes, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(LocExtractor.class, this.families.locations, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(PerimeterExtractor.class, this.families.perimeters, priority++, sceneRenderer));
            this.addExtractor(this.newExtractor(RaymarchingExtractor.class, this.families.raymarchings, priority, sceneRenderer));
            this.addExtractor(this.newExtractor(InvisibleExtractor.class, this.families.invisibles, priority, sceneRenderer));
            this.engine.removeAllSystems();
            this.addSystemsToEngine(this.updaters);
            this.addSystemsToEngine(this.extractors);
        }
    }

    public void initializeEntity(Entity entity) {
        if (this.initializers != null) {
            for (AbstractInitSystem system : this.initializers) {
                if (!system.getFamily().matches(entity)) continue;
                system.initializeEntity(entity);
            }
        }
    }

    public void setUpEntity(Entity entity) {
        if (this.initializers != null) {
            for (AbstractInitSystem system : this.initializers) {
                if (!system.getFamily().matches(entity)) continue;
                system.setUpEntity(entity);
            }
        }
    }

    public void updateEntity(Entity entity, float deltaTime) {
        block4: {
            if (this.updaters == null) break block4;
            if (Mapper.tagOctreeObject.has(entity) && Mapper.starSet.has(entity)) {
                for (EntityUpdater system : this.updaters) {
                    if (!(system instanceof ParticleSetUpdater)) continue;
                    system.updateEntity(entity, deltaTime);
                }
            } else {
                for (EntityUpdater system : this.updaters) {
                    if (!system.getFamily().matches(entity)) continue;
                    system.updateEntity(entity, deltaTime);
                }
            }
        }
    }

    public void extractEntity(Entity entity) {
        if (this.extractors != null) {
            for (AbstractExtractSystem system : this.extractors) {
                if (!system.getFamily().matches(entity)) continue;
                system.extract(entity);
            }
        }
    }

    public void updateEntityGraph(Entity entity, ITimeFrameProvider time, Vector3Q parentTranslation, float opacity) {
        GraphUpdater updater = this.findUpdater(GraphUpdater.class);
        if (updater != null) {
            updater.update(entity, time, parentTranslation, opacity);
        }
    }

    private <T extends EntityUpdater> T findUpdater(Class<T> updaterClass) {
        if (this.updaters != null) {
            for (EntityUpdater updater : this.updaters) {
                if (!updater.getClass().isAssignableFrom(updaterClass)) continue;
                return (T)updater;
            }
        }
        return null;
    }

    private <T extends AbstractExtractSystem> T newExtractor(Class<T> extractorClass, Family family, int priority, ISceneRenderer sceneRenderer) {
        try {
            Constructor<T> c = extractorClass.getDeclaredConstructor(Family.class, Integer.TYPE);
            AbstractExtractSystem system = (AbstractExtractSystem)((Object)c.newInstance(family, priority));
            system.setRenderer(sceneRenderer);
            return (T)((Object)system);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void update(ITimeFrameProvider time) {
        this.engine.update((float)time.getDt());
    }

    public void insert(Entity entity, boolean addToIndex) {
        Base base = (Base)Mapper.base.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Entity parent = this.getEntity(graph.parentName);
        boolean ok = true;
        if (addToIndex) {
            ok = this.index.addToIndex(entity);
        }
        if (!ok) {
            logger.warn(I18n.msg("error.object.exists", base.getName() + "(" + this.archetypes.findArchetype(entity).getName() + ")"));
        } else if (parent != null) {
            GraphNode parentGraph = (GraphNode)Mapper.graph.get(parent);
            parentGraph.addChild(parent, entity, true, 1);
        } else {
            throw new RuntimeException(I18n.msg("error.parent.notfound", base.getName(), graph.parentName));
        }
        try {
            this.engine.addEntity(entity);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Entity " + base.getName() + " already in engine.");
        }
        this.reportDebugObjects();
    }

    public void remove(Entity entity, boolean removeFromIndex) {
        this.remove(entity, true, removeFromIndex);
    }

    private void remove(Entity entity, boolean topLevelElement, boolean removeFromIndex) {
        CameraManager cam;
        if (entity != null && Mapper.graph.has(entity)) {
            GraphNode graph = (GraphNode)Mapper.graph.get(entity);
            if (graph.children != null) {
                for (Entity child : graph.children) {
                    this.remove(child, false, true);
                }
                graph.children.clear();
            }
            if (graph.parent != null && topLevelElement) {
                GraphNode parentGraph = (GraphNode)Mapper.graph.get(graph.parent);
                parentGraph.removeChild(entity, true);
            }
        } else {
            throw new RuntimeException("Given node is null");
        }
        if (removeFromIndex) {
            this.index.remove(entity);
        }
        if ((cam = GaiaSky.instance.getCameraManager()) != null && cam.hasFocus() && ((FocusView)cam.getFocus()).getEntity() == entity) {
            EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE});
        }
        ImmutableArray components = entity.getComponents();
        for (Component component : components) {
            if (!(component instanceof IDisposable)) continue;
            ((IDisposable)component).dispose(entity);
        }
        this.engine.removeEntity(entity);
        if (topLevelElement) {
            this.reportDebugObjects();
        }
    }

    public void updateLocalizedNames() {
        this.engine.getEntities().forEach(entity -> {
            Base base = (Base)Mapper.base.get(entity);
            base.updateLocalizedName();
        });
    }

    public Entity getEntity(String name) {
        return this.index.getEntity(name);
    }

    public Entity findFocus(String name) {
        Entity entity = this.getEntity(name);
        if (entity != null && Mapper.focus.has(entity)) {
            return entity;
        }
        return null;
    }

    public void matchingFocusableNodes(String name, SortedSet<String> results, int maxResults, AtomicBoolean abort) {
        this.index.matchingFocusableNodes(name, results, maxResults, abort);
    }

    public Array<Entity> findFocusableEntities() {
        Array list = new Array();
        this.engine.getEntities().forEach(entity -> {
            if (Mapper.focus.has(entity)) {
                list.add(entity);
            } else if (Mapper.octree.has(entity)) {
                Octree octree = (Octree)Mapper.octree.get(entity);
                Set<Entity> objects = octree.parenthood.keySet();
                objects.forEach(object -> {
                    if (Mapper.focus.has(object)) {
                        list.add(object);
                    }
                });
            }
        });
        return list;
    }

    public ImmutableArray<Entity> findEntitiesByFamily(Family family) {
        return this.engine.getEntitiesFor(family);
    }

    public void findEntitiesByComponentType(ComponentTypes.ComponentType componentType, Array<Entity> list) {
        this.engine.getEntities().forEach(entity -> {
            Base base = (Base)Mapper.base.get(entity);
            if (base.ct != null && base.ct.isEnabled(componentType)) {
                list.add(entity);
            }
        });
    }

    public double[] getObjectPosition(String name, double[] out) {
        if (out.length >= 3 && name != null && this.index.containsEntity(name = name.toLowerCase(Locale.ROOT).trim())) {
            Entity entity = this.index.getEntity(name);
            this.focusView.setEntity(entity);
            this.focusView.getAbsolutePosition(name, this.aux3b);
            out[0] = this.aux3b.x.doubleValue();
            out[1] = this.aux3b.y.doubleValue();
            out[2] = this.aux3b.z.doubleValue();
            return out;
        }
        return null;
    }

    public Families getFamilies() {
        return this.families;
    }

    public Entity getLineCopy(Entity entity) {
        Entity copy;
        HashMap<String, Entity> idx = this.copyIndex.get();
        idx.clear();
        Entity e = copy = this.getLineCopy(entity, idx);
        while (e != null) {
            if (Mapper.coordinates.has(e)) {
                Coordinates coordinates = (Coordinates)Mapper.coordinates.get(e);
                coordinates.coordinates.updateReferences(idx);
            }
            GraphNode g = (GraphNode)Mapper.graph.get(e);
            e = g.parent;
        }
        idx.clear();
        return copy;
    }

    public Entity getLineCopy(Entity entity, Map<String, Entity> index) {
        Entity copy = this.getSimpleCopy(entity);
        Base base = (Base)Mapper.base.get(copy);
        index.put(base.getName().toLowerCase(Locale.ROOT), copy);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        if (graph.parent != null) {
            Entity parentCopy = this.getLineCopy(graph.parent, index);
            GraphNode parentCopyGraph = (GraphNode)Mapper.graph.get(parentCopy);
            parentCopyGraph.addChild(parentCopy, copy, false, 1);
        }
        return copy;
    }

    public Entity getSimpleCopy(Entity entity) {
        Entity copy = this.engine.createEntity();
        for (Component component : entity.getComponents()) {
            if (component instanceof ICopy) {
                ICopy iCopy = (ICopy)component;
                componentCopy = iCopy.getCopy(this.engine);
                copy.add(componentCopy);
            } else {
                try {
                    componentCopy = (Component)component.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    copy.add(componentCopy);
                }
                catch (Exception e) {
                    logger.error("Could not create copy of component " + component.getClass().getSimpleName());
                }
            }
            copy.add((Component)new TagCopy());
        }
        return copy;
    }

    public void returnCopyObject(Entity copy) {
        Entity parent;
        Entity currentEntity = copy;
        do {
            GraphNode graph = (GraphNode)Mapper.graph.get(currentEntity);
            parent = graph.parent;
            ((Pool.Poolable)currentEntity).reset();
        } while ((currentEntity = parent) != null);
    }

    public void reportDebugObjects() {
        this.updateNumberObjects();
        EventManager.publish(Event.DEBUG_OBJECTS, this, this.numberObjects, this.numberObjects);
    }

    private void updateNumberObjects() {
        if (this.engine != null) {
            ImmutableArray entities = this.engine.getEntities();
            this.numberObjects = 0;
            for (Entity entity : entities) {
                this.numberObjects += this.getNumberObjects(entity);
            }
        }
    }

    public int getNumberObjects(Entity entity) {
        if (Mapper.particleSet.has(entity)) {
            return ((ParticleSet)Mapper.particleSet.get(entity)).data().size();
        }
        if (Mapper.starSet.has(entity)) {
            return ((StarSet)Mapper.starSet.get(entity)).data().size();
        }
        if (Mapper.octree.has(entity)) {
            Octant octant = (Octant)Mapper.octant.get(entity);
            return this.getNumberObjects(octant.octant);
        }
        return 1;
    }

    public int getNumberObjects(OctreeNode node) {
        if (node == null) {
            return 0;
        }
        int objects = 0;
        if (node.objects != null && !node.objects.isEmpty()) {
            for (IOctreeObject o : node.objects) {
                objects += o.getStarCount();
            }
        }
        for (OctreeNode child : node.children) {
            objects += this.getNumberObjects(child);
        }
        return objects;
    }
}

