/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene;

import com.badlogic.ashley.core.Entity;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Logger;
import gaiasky.util.i18n.I18n;
import java.util.Locale;

public class SceneObserver
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(SceneObserver.class);
    private final FocusView view = new FocusView();

    public SceneObserver() {
        EventManager.instance.subscribe((IObserver)this, Event.PER_OBJECT_VISIBILITY_CMD, Event.FORCE_OBJECT_LABEL_CMD, Event.LABEL_COLOR_CMD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case PER_OBJECT_VISIBILITY_CMD: {
                Object name;
                Object object = data[0];
                if (object instanceof FocusView) {
                    FocusView focusView = (FocusView)object;
                    name = (String)data[1];
                    boolean state = (Boolean)data[2];
                    focusView.setVisible(state, ((String)name).toLowerCase(Locale.ROOT).strip());
                    logger.info(I18n.msg("notif.visibility.object.set", focusView.getName(), I18n.msg("gui." + state)));
                    break;
                }
                name = data[0];
                if (name instanceof Entity) {
                    Entity entity = (Entity)name;
                    this.view.setEntity(entity);
                    name = (String)data[1];
                    boolean state = (Boolean)data[2];
                    this.view.setVisible(state, ((String)name).toLowerCase(Locale.ROOT).strip());
                    logger.info(I18n.msg("notif.visibility.object.set", this.view.getName(), I18n.msg("gui." + state)));
                    break;
                }
                logger.warn("PER_OBJECT_VISIBILITY_CMD needs a FocusView or an Entity, got " + data[0].getClass().getSimpleName());
                break;
            }
            case FORCE_OBJECT_LABEL_CMD: {
                FocusView focusView = null;
                Object object = data[0];
                if (object instanceof Entity) {
                    Entity entity = (Entity)object;
                    this.view.setEntity(entity);
                    focusView = this.view;
                } else {
                    object = data[0];
                    if (object instanceof FocusView) {
                        FocusView fv;
                        focusView = fv = (FocusView)object;
                    }
                }
                if (focusView == null) break;
                String name = (String)data[1];
                boolean state = (Boolean)data[2];
                focusView.setForceLabel(state, name.toLowerCase(Locale.ROOT));
                logger.info(I18n.msg("notif.object.flag", "forceLabel", name, I18n.msg("gui." + state)));
                break;
            }
            case LABEL_COLOR_CMD: {
                Entity entity = (Entity)data[0];
                String name = (String)data[1];
                float[] labelColor = (float[])data[2];
                FocusView focusView = this.view;
                synchronized (focusView) {
                    this.view.setEntity(entity);
                    this.view.setLabelColor(labelColor, name);
                    break;
                }
            }
        }
    }
}

