/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.camera;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Constants;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.camera.Proximity;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import net.jafama.FastMath;

public abstract class AbstractCamera
implements ICamera {
    protected static final Logger.Log logger = Logger.getLogger(AbstractCamera.class);
    private static final double VIEW_ANGLE = FastMath.toRadians((double)0.05);
    public double CAM_NEAR;
    public double CAM_FAR;
    public Vector3Q pos;
    public Vector3Q posInv;
    public Vector3Q prevPos;
    public Vector3Q dPos;
    public Vector3D tmp;
    public Vector3D shift;
    public PerspectiveCamera camera;
    public float fovFactor;
    protected float angleEdgeRad;
    protected float ar;
    protected double distance;
    protected CameraManager parent;
    protected PerspectiveCamera camLeft;
    protected PerspectiveCamera camRight;
    protected PerspectiveCamera[] cameras;
    protected FocusView closestBody;
    protected IFocus closestStar;
    protected FocusView closestStarView;
    protected Proximity proximity;
    protected Matrix4 prevCombined;
    protected IFocus closest;
    protected boolean gamepadInput;

    protected AbstractCamera(CameraManager parent) {
        this.initNearFar();
        this.parent = parent;
        this.pos = new Vector3Q();
        this.prevPos = new Vector3Q();
        this.dPos = new Vector3Q();
        this.posInv = new Vector3Q();
        this.shift = new Vector3D();
        this.tmp = new Vector3D();
        this.prevCombined = new Matrix4();
        this.camLeft = new PerspectiveCamera(Settings.settings.scene.camera.fov, (float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight());
        this.camLeft.near = (float)this.CAM_NEAR;
        this.camLeft.far = (float)this.CAM_FAR;
        this.camRight = new PerspectiveCamera(Settings.settings.scene.camera.fov, (float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight());
        this.camRight.near = (float)this.CAM_NEAR;
        this.camRight.far = (float)this.CAM_FAR;
        this.closestBody = new FocusView();
        this.closestStarView = new FocusView();
        this.proximity = new Proximity(3);
    }

    private void initNearFar() {
        this.CAM_NEAR = 0.5 * Constants.M_TO_U;
        this.CAM_FAR = Constants.MPC_TO_U;
    }

    @Override
    public void updateAngleEdge(int width, int height) {
        this.ar = (float)width / (float)height;
        this.angleEdgeRad = this.getAngleEdge(width, height, this.camera.fieldOfView);
    }

    public float getAngleEdge(int width, int height, float angle) {
        float ar = (float)width / (float)height;
        float w = angle * ar;
        return (float)Math.toRadians(Math.sqrt(angle * angle + w * w)) / 2.0f;
    }

    @Override
    public float getFovFactor() {
        return this.fovFactor;
    }

    @Override
    public Vector3Q getPos() {
        return this.pos;
    }

    @Override
    public void setPos(Vector3D pos) {
        this.pos.set(pos);
    }

    @Override
    public void setPos(Vector3Q pos) {
        this.pos.set(pos);
    }

    @Override
    public Vector3Q getPreviousPos() {
        return this.prevPos;
    }

    @Override
    public void setPreviousPos(Vector3Q pos) {
        this.prevPos.set(pos);
    }

    @Override
    public void setPreviousPos(Vector3D prevpos) {
        this.prevPos.set(prevpos);
    }

    @Override
    public void setDPos(Vector3Q dPos) {
        this.dPos.set(dPos);
    }

    @Override
    public void setDPos(Vector3D dPos) {
        this.dPos.set(dPos);
    }

    @Override
    public Vector3Q getDPos() {
        return this.dPos;
    }

    @Override
    public Vector3Q getInversePos() {
        return this.posInv;
    }

    @Override
    public float getAngleEdge() {
        return this.angleEdgeRad;
    }

    @Override
    public CameraManager getManager() {
        return this.parent;
    }

    @Override
    public void render(int rw, int rh) {
    }

    @Override
    public ICamera getCurrent() {
        return this;
    }

    @Override
    public boolean isVisible(Entity cb) {
        Body body = (Body)Mapper.body.get(cb);
        GraphNode graph = (GraphNode)Mapper.graph.get(cb);
        return this.isVisible(body.solidAngle, graph.translation, body.distToCamera);
    }

    @Override
    public boolean isVisible(double viewAngle, Vector3D pos, double distToCamera) {
        return viewAngle > VIEW_ANGLE || GlobalResources.isInView(pos, distToCamera, this.angleEdgeRad, this.tmp.set(this.getCamera().direction));
    }

    public boolean isVisible(double viewAngle, Vector3Q pos, double distToCamera) {
        return viewAngle > VIEW_ANGLE || GlobalResources.isInView(pos, distToCamera, this.angleEdgeRad, this.tmp.set(this.getCamera().direction));
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    public void copyParamsFrom(AbstractCamera other) {
        this.pos.set(other.pos);
        this.posInv.set(other.posInv);
        this.getDirection().set(other.getDirection());
        this.getUp().set(other.getUp());
        this.closestBody = other.closestBody;
    }

    private void copyCamera(PerspectiveCamera source, PerspectiveCamera target) {
        target.far = source.far;
        target.near = source.near;
        target.direction.set(source.direction);
        target.up.set(source.up);
        target.position.set(source.position);
        target.fieldOfView = source.fieldOfView;
        target.viewportHeight = source.viewportHeight;
        target.viewportWidth = source.viewportWidth;
    }

    @Override
    public PerspectiveCamera getCameraStereoLeft() {
        return this.camLeft;
    }

    @Override
    public void setCameraStereoLeft(PerspectiveCamera cam) {
        this.copyCamera(cam, this.camLeft);
    }

    @Override
    public PerspectiveCamera getCameraStereoRight() {
        return this.camRight;
    }

    @Override
    public void setCameraStereoRight(PerspectiveCamera cam) {
        this.copyCamera(cam, this.camRight);
    }

    @Override
    public Vector3D getShift() {
        return this.shift;
    }

    @Override
    public void setShift(Vector3D shift) {
        this.shift.set(shift);
    }

    @Override
    public synchronized void checkClosestBody(IFocus cb) {
        if (cb instanceof FocusView) {
            FocusView candidate = (FocusView)cb;
            if (!cb.isCopy() && !Mapper.tagNoClosest.has(candidate.getEntity())) {
                if (this.closestBody.getEntity() == null) {
                    this.closestBody.setEntity(candidate.getEntity());
                } else if (this.closestBody.getDistToCamera() - this.closestBody.getRadius() > cb.getDistToCamera() - cb.getRadius()) {
                    this.closestBody.setEntity(candidate.getEntity());
                }
            }
        }
    }

    @Override
    public synchronized void checkClosestBody(Entity cb) {
        Base base = (Base)Mapper.base.get(cb);
        Body body = (Body)Mapper.body.get(cb);
        if (!base.copy && !Mapper.tagNoClosest.has(cb) && body.cameraCollision) {
            if (!this.closestBody.isValid()) {
                this.closestBody.setEntity(cb);
            } else {
                double distMinusRadius = this.closestBody.getDistToCamera() - this.closestBody.getRadius();
                Entity prev = this.closestBody.getEntity();
                this.closestBody.setEntity(cb);
                if (distMinusRadius < this.closestBody.getDistToCamera() - this.closestBody.getRadius()) {
                    this.closestBody.setEntity(prev);
                }
            }
        }
    }

    @Override
    public IFocus getClosestBody() {
        return this.closestBody;
    }

    @Override
    public IFocus getSecondClosestBody() {
        return this.closestBody;
    }

    @Override
    public IFocus getClosestParticle() {
        return this.closestStar;
    }

    @Override
    public IFocus getCloseLightSource(int i) {
        assert (this.proximity != null) : "Proximity is null";
        assert (i < this.proximity.effective.length) : "Index out of bounds: i=" + i + ", length=" + this.proximity.effective.length;
        return this.proximity.effective[i];
    }

    @Override
    public synchronized void checkClosestParticle(IFocus star) {
        if (star instanceof Proximity.NearbyRecord) {
            this.proximity.update((Proximity.NearbyRecord)star);
        } else {
            this.proximity.update(star, this);
        }
        if (this.closestStar == null || !this.closestStar.isEmpty() && this.closestStar.getClosestDistToCamera() > star.getClosestDistToCamera()) {
            if (star instanceof FocusView) {
                this.closestStarView.setEntity(((FocusView)star).getEntity());
                this.closestStar = this.closestStarView;
            } else {
                this.closestStar = star;
            }
        }
    }

    @Override
    public void swapBuffers() {
        this.proximity.swapBuffers();
    }

    @Override
    public IFocus getClosest() {
        return this.closest;
    }

    @Override
    public void setClosest(IFocus focus) {
        this.closest = focus;
    }

    @Override
    public Vector3D getVelocity() {
        return null;
    }

    @Override
    public void updateFrustumPlanes() {
        this.initNearFar();
        this.setFrustumPlanes(this.camera);
        this.setFrustumPlanes(this.camLeft);
        this.setFrustumPlanes(this.camRight);
    }

    protected void setFrustumPlanes(PerspectiveCamera cam) {
        if (cam != null) {
            cam.near = (float)this.CAM_NEAR;
            cam.far = (float)this.CAM_FAR;
            cam.update();
        }
    }

    @Override
    public double getNear() {
        return this.CAM_NEAR;
    }

    @Override
    public double getFar() {
        return this.CAM_FAR;
    }

    @Override
    public Matrix4 getProjView() {
        return this.camera.combined;
    }

    @Override
    public Matrix4 getPreviousProjView() {
        return this.prevCombined;
    }

    @Override
    public void setPreviousProjView(Matrix4 mat) {
        this.prevCombined.set(mat);
    }

    @Override
    public void setGamepadInput(boolean state) {
        this.gamepadInput = state;
    }

    @Override
    public void setPointerProjectionOnFocus(Vector3 point) {
    }

    @Override
    public double getSpeedScaling() {
        return 1.0;
    }

    @Override
    public double getSpeedScalingCapped() {
        return 1.0;
    }

    @Override
    public boolean isRotating() {
        return false;
    }
}

