/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.camera;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.AbstractCamera;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.scene.camera.RelativisticCamera;
import gaiasky.scene.camera.SpacecraftCamera;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Constants;
import gaiasky.util.GlobalResources;
import gaiasky.util.Settings;
import gaiasky.util.camera.CameraUtils;
import gaiasky.util.camera.Proximity;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.time.ITimeFrameProvider;
import net.jafama.FastMath;

public class CameraManager
implements ICamera,
IObserver {
    private final ICamera[] cameras;
    private final Vector3D out;
    private final Vector3D in;
    private final Vector3Q inb;
    private final Vector3 vec;
    private final Vector3 v0;
    private final Vector3 v1;
    private final Vector3 intersection;
    private final Matrix4 localTransformInv;
    public CameraMode mode;
    public ICamera current;
    public NaturalCamera naturalCamera;
    public SpacecraftCamera spacecraftCamera;
    public RelativisticCamera relativisticCamera;
    private final FocusView focusView;
    public IFocus previousClosest;
    protected double speed;
    protected Vector3D velocity;
    protected Vector3D velocityNormalized;
    private BackupProjectionCamera backupCamera;

    public CameraManager(AssetManager manager, CameraMode mode, boolean vr, GlobalResources globalResources) {
        this.naturalCamera = new NaturalCamera(manager, this, vr, globalResources.getSpriteShader(), globalResources.getShapeShader());
        this.spacecraftCamera = new SpacecraftCamera(this);
        this.relativisticCamera = new RelativisticCamera(manager, this);
        this.cameras = new ICamera[]{this.naturalCamera, this.spacecraftCamera};
        this.focusView = new FocusView();
        this.mode = mode;
        this.in = new Vector3D();
        this.inb = new Vector3Q();
        this.out = new Vector3D();
        this.vec = new Vector3();
        this.v0 = new Vector3();
        this.v1 = new Vector3();
        this.intersection = new Vector3();
        this.velocity = new Vector3D();
        this.velocityNormalized = new Vector3D();
        this.localTransformInv = new Matrix4();
        this.updateCurrentCamera();
        EventManager.instance.subscribe((IObserver)this, Event.CAMERA_MODE_CMD, Event.FOV_CHANGED_CMD);
    }

    @Override
    public void doneLoading(AssetManager manager) {
        for (ICamera cam : this.cameras) {
            cam.doneLoading(manager);
        }
    }

    public static void getFrustumCornersEye(PerspectiveCamera cam, Matrix4 frustumCorners) {
        float camFov = cam.fieldOfView;
        float camAspect = cam.viewportWidth / cam.viewportHeight;
        float fovWHalf = camFov * 0.5f;
        float tan_fov = (float)FastMath.tan((double)Math.toRadians(fovWHalf));
        Vector3 right = Vector3.X;
        Vector3 up = Vector3.Y;
        Vector3 forward = Vector3.Z;
        Vector3 toRight = new Vector3(right).scl(tan_fov * camAspect);
        Vector3 toTop = new Vector3(up).scl(tan_fov);
        Vector3 topLeft = new Vector3(forward).scl(-1.0f).sub(toRight).add(toTop).nor();
        Vector3 topRight = new Vector3(forward).scl(-1.0f).add(toRight).add(toTop).nor();
        Vector3 bottomRight = new Vector3(forward).scl(-1.0f).add(toRight).sub(toTop).nor();
        Vector3 bottomLeft = new Vector3(forward).scl(-1.0f).sub(toRight).sub(toTop).nor();
        frustumCorners.val[0] = topLeft.x;
        frustumCorners.val[1] = topLeft.y;
        frustumCorners.val[2] = topLeft.z;
        frustumCorners.val[4] = topRight.x;
        frustumCorners.val[5] = topRight.y;
        frustumCorners.val[6] = topRight.z;
        frustumCorners.val[8] = bottomRight.x;
        frustumCorners.val[9] = bottomRight.y;
        frustumCorners.val[10] = bottomRight.z;
        frustumCorners.val[12] = bottomLeft.x;
        frustumCorners.val[13] = bottomLeft.y;
        frustumCorners.val[14] = bottomLeft.z;
    }

    private AbstractCamera backupCam(ICamera current) {
        if (current instanceof AbstractCamera) {
            return (AbstractCamera)current;
        }
        return null;
    }

    private void restoreCam(AbstractCamera cam, AbstractCamera copy) {
        if (copy != null) {
            cam.copyParamsFrom(copy);
        }
    }

    public void updateCurrentCamera() {
        switch (this.mode.ordinal()) {
            case 2: {
                EventManager.publish(Event.CAMERA_CINEMATIC_CMD, this, false);
            }
            case 0: 
            case 1: {
                AbstractCamera aux = this.backupCam(this.current);
                this.current = this.naturalCamera;
                this.restoreCam(this.naturalCamera, aux);
                break;
            }
            case 3: {
                AbstractCamera aux = this.backupCam(this.current);
                this.current = this.spacecraftCamera;
                this.restoreCam(this.spacecraftCamera, aux);
                break;
            }
        }
    }

    public boolean isNatural() {
        return this.current == this.naturalCamera;
    }

    @Override
    public PerspectiveCamera getCamera() {
        return this.current.getCamera();
    }

    @Override
    public void setCamera(PerspectiveCamera perspectiveCamera) {
        this.current.setCamera(perspectiveCamera);
    }

    @Override
    public float getFovFactor() {
        return this.current.getFovFactor();
    }

    @Override
    public Vector3Q getPos() {
        return this.current.getPos();
    }

    @Override
    public void setPos(Vector3D pos) {
        this.current.setPos(pos);
    }

    @Override
    public void setPos(Vector3Q pos) {
        this.current.setPos(pos);
    }

    @Override
    public Vector3Q getPreviousPos() {
        return this.current.getPreviousPos();
    }

    @Override
    public void setPreviousPos(Vector3D prevPos) {
        this.current.setPreviousPos(prevPos);
    }

    @Override
    public void setPreviousPos(Vector3Q prevPos) {
        this.current.setPreviousPos(prevPos);
    }

    @Override
    public Vector3Q getDPos() {
        return this.current.getDPos();
    }

    @Override
    public void setDPos(Vector3D dPos) {
        this.current.setDPos(dPos);
    }

    @Override
    public void setDPos(Vector3Q dPos) {
        this.current.setDPos(dPos);
    }

    @Override
    public Vector3Q getInversePos() {
        return this.current.getInversePos();
    }

    @Override
    public Vector3D getVelocity() {
        return this.current.getVelocity();
    }

    @Override
    public Vector3D getDirection() {
        return this.current.getDirection();
    }

    @Override
    public void setDirection(Vector3D dir) {
        this.current.setDirection(dir);
    }

    @Override
    public Vector3D getUp() {
        return this.current.getUp();
    }

    @Override
    public void swapBuffers() {
        this.current.swapBuffers();
    }

    @Override
    public void setGamepadInput(boolean state) {
        this.current.setGamepadInput(state);
    }

    @Override
    public void setPointerProjectionOnFocus(Vector3 point) {
        this.current.setPointerProjectionOnFocus(point);
    }

    @Override
    public double getSpeedScaling() {
        return this.current.getSpeedScaling();
    }

    @Override
    public double getSpeedScalingCapped() {
        return this.current.getSpeedScalingCapped();
    }

    public void backupCamera() {
        this.backupCamera = new BackupProjectionCamera(this.current.getCamera());
    }

    public void restoreCamera() {
        if (this.backupCamera != null) {
            this.backupCamera.restore(this.current.getCamera());
            this.backupCamera = null;
        }
    }

    @Override
    public void update(double dt, ITimeFrameProvider time) {
        IFocus closestParticle;
        IFocus closestBody;
        boolean ok;
        this.current.setPreviousPos(this.current.getPos());
        this.current.setPreviousProjView(this.current.getProjView());
        this.current.update(dt, time);
        Vector3Q dPos = this.current.getDPos();
        dPos.set(this.current.getPreviousPos()).sub(this.current.getPos());
        this.velocity.set(dPos);
        this.velocityNormalized.set(this.velocity).nor();
        this.speed = this.velocity.len() * Constants.U_TO_KM / (dt * 2.777777777777778E-4);
        double d = Settings.settings.runtime.openXr ? 5000000.0 : 500000.0;
        if (this.speed > d) {
            EventManager.publish(Event.CLEAR_OCTANT_QUEUE, this, new Object[0]);
        }
        EventManager.publish(Event.CAMERA_MOTION_UPDATE, this, this.current.getPos(), this.speed, this.velocityNormalized, this.current.getCamera());
        int screenX = Gdx.input.getX();
        int screenY = Gdx.input.getY();
        int width = Gdx.graphics.getWidth();
        int height = Gdx.graphics.getHeight();
        if (width > 0 && height > 0) {
            this.updateRADEC(screenX, screenY, width / 2, height / 2);
        }
        if ((ok = this.updateFocusLatLon(screenX, screenY)) && this.current.hasFocus() && ((FocusView)this.current.getFocus()).isPlanet()) {
            this.current.setPointerProjectionOnFocus(this.intersection);
        }
        if (!(closestBody = this.getClosestBody()).isEmpty() && closestBody.getOctant() != null && !closestBody.getOctant().observed) {
            ((FocusView)closestBody).clearEntity();
        }
        if ((closestParticle = this.getClosestParticle()) != null && closestParticle.getOctant() != null && !closestParticle.getOctant().observed) {
            closestParticle = null;
        }
        if (!closestBody.isEmpty() || closestParticle != null) {
            if (closestBody.isEmpty()) {
                this.setClosest(closestParticle);
            } else if (closestParticle == null) {
                this.setClosest(closestBody);
            } else {
                this.setClosest(closestBody.getDistToCamera() < closestParticle.getClosestDistToCamera() ? closestBody : closestParticle);
            }
        }
        IFocus newClosest = this.getClosest();
        EventManager.publish(Event.CAMERA_CLOSEST_INFO, this, newClosest, this.getClosestBody(), this.getClosestParticle());
        if (newClosest != null && !newClosest.equals(this.previousClosest)) {
            EventManager.publish(Event.CAMERA_NEW_CLOSEST, this, newClosest);
            if (newClosest instanceof FocusView) {
                this.focusView.setEntity(((FocusView)newClosest).getEntity());
                this.previousClosest = this.focusView;
            } else if (newClosest instanceof Proximity.NearbyRecord) {
                this.previousClosest = newClosest;
            }
        }
    }

    private void updateRADEC(int pointerX, int pointerY, int viewX, int viewY) {
        ICamera camera = this.current;
        this.vec.set((float)pointerX, (float)pointerY, 0.5f);
        camera.getCamera().unproject(this.vec);
        try {
            this.inb.set(this.vec);
            Coordinates.cartesianToSpherical(this.inb, this.out);
            double pointerRA = this.out.x * 57.29577951308232;
            double pointerDEC = this.out.y * 57.29577951308232;
            this.vec.set((float)viewX, (float)viewY, 0.5f);
            camera.getCamera().unproject(this.vec);
            this.inb.set(this.vec);
            Coordinates.cartesianToSpherical(this.inb, this.out);
            double viewRA = this.out.x * 57.29577951308232;
            double viewDEC = this.out.y * 57.29577951308232;
            EventManager.publish(Event.RA_DEC_UPDATED, this, pointerRA, pointerDEC, viewRA, viewDEC, pointerX, pointerY);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private boolean updateFocusLatLon(int screenX, int screenY) {
        if (this.isNatural() && this.current.hasFocus() && ((FocusView)this.current.getFocus()).isPlanet()) {
            FocusView e = (FocusView)this.current.getFocus();
            double[] lonlat = new double[2];
            boolean ok = CameraUtils.getLonLat(e, e.getEntity(), this.getCurrent(), screenX, screenY, this.v0, this.v1, this.vec, this.intersection, this.in, this.out, this.localTransformInv, lonlat);
            if (ok) {
                EventManager.publish(Event.LON_LAT_UPDATED, this, lonlat[0], lonlat[1], screenX, screenY);
            }
            return ok;
        }
        return false;
    }

    @Override
    public void updateMode(ICamera previousCam, CameraMode previousMode, CameraMode newMode, boolean centerFocus) {
        previousMode = this.mode;
        previousCam = this.current;
        this.mode = newMode;
        this.updateCurrentCamera();
        for (ICamera cam : this.cameras) {
            cam.updateMode(previousCam, previousMode, newMode, centerFocus);
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case CAMERA_MODE_CMD: {
                CameraMode newCameraMode = (CameraMode)((Object)data[0]);
                boolean centerFocus = true;
                if (data.length > 1) {
                    centerFocus = (Boolean)data[1];
                }
                this.updateMode(this.current, this.mode, newCameraMode, centerFocus);
                break;
            }
            case FOV_CHANGED_CMD: {
                this.updateAngleEdge(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
                break;
            }
        }
    }

    @Override
    public Vector3D[] getDirections() {
        return this.current.getDirections();
    }

    @Override
    public int getNCameras() {
        return this.current.getNCameras();
    }

    @Override
    public PerspectiveCamera[] getFrontCameras() {
        return this.current.getFrontCameras();
    }

    @Override
    public CameraMode getMode() {
        return this.mode;
    }

    @Override
    public void updateAngleEdge(int width, int height) {
        for (ICamera cam : this.cameras) {
            cam.updateAngleEdge(width, height);
        }
    }

    @Override
    public float getAngleEdge() {
        return this.current.getAngleEdge();
    }

    @Override
    public CameraManager getManager() {
        return this;
    }

    @Override
    public void render(int rw, int rh) {
        this.current.render(rw, rh);
    }

    @Override
    public ICamera getCurrent() {
        return this.current;
    }

    @Override
    public double getSpeed() {
        return this.speed;
    }

    @Override
    public boolean isFocus(Entity cb) {
        return this.current.isFocus(cb);
    }

    @Override
    public void checkClosestBody(IFocus focus) {
        this.current.checkClosestBody(focus);
    }

    @Override
    public void checkClosestBody(Entity entity) {
        this.current.checkClosestBody(entity);
    }

    @Override
    public IFocus getFocus() {
        return this.current.getFocus();
    }

    @Override
    public boolean hasFocus() {
        return this.current.hasFocus();
    }

    @Override
    public boolean isVisible(Entity cb) {
        return this.current.isVisible(cb);
    }

    @Override
    public boolean isVisible(double viewAngle, Vector3D pos, double distToCamera) {
        return this.current.isVisible(viewAngle, pos, distToCamera);
    }

    @Override
    public double getDistance() {
        return this.current.getDistance();
    }

    @Override
    public boolean isRotating() {
        return this.current.isRotating();
    }

    @Override
    public PerspectiveCamera getCameraStereoLeft() {
        return this.current.getCameraStereoLeft();
    }

    @Override
    public void setCameraStereoLeft(PerspectiveCamera cam) {
        this.current.setCameraStereoLeft(cam);
    }

    @Override
    public PerspectiveCamera getCameraStereoRight() {
        return this.current.getCameraStereoRight();
    }

    @Override
    public void setCameraStereoRight(PerspectiveCamera cam) {
        this.current.setCameraStereoRight(cam);
    }

    @Override
    public IFocus getClosestBody() {
        return this.current.getClosestBody();
    }

    @Override
    public IFocus getSecondClosestBody() {
        return this.current.getSecondClosestBody();
    }

    @Override
    public IFocus getCloseLightSource(int i) {
        return this.current.getCloseLightSource(i);
    }

    @Override
    public void resize(int width, int height) {
        for (ICamera cam : this.cameras) {
            cam.resize(width, height);
        }
    }

    @Override
    public Vector3D getShift() {
        return this.current.getShift();
    }

    @Override
    public void setShift(Vector3D shift) {
        this.current.setShift(shift);
    }

    @Override
    public Matrix4 getProjView() {
        return this.current.getProjView();
    }

    @Override
    public Matrix4 getPreviousProjView() {
        return this.current.getPreviousProjView();
    }

    @Override
    public void setPreviousProjView(Matrix4 mat) {
        this.current.setPreviousProjView(mat);
    }

    @Override
    public IFocus getClosestParticle() {
        return this.current.getClosestParticle();
    }

    @Override
    public void checkClosestParticle(IFocus particle) {
        this.current.checkClosestParticle(particle);
    }

    @Override
    public IFocus getClosest() {
        return this.current.getClosest();
    }

    @Override
    public void setClosest(IFocus focus) {
        this.current.setClosest(focus);
    }

    @Override
    public double speedScaling() {
        return this.current.speedScaling();
    }

    @Override
    public void updateFrustumPlanes() {
        for (ICamera cam : this.cameras) {
            cam.updateFrustumPlanes();
        }
    }

    @Override
    public double getNear() {
        return this.current.getNear();
    }

    @Override
    public double getFar() {
        return this.current.getFar();
    }

    public static enum CameraMode {
        FREE_MODE,
        FOCUS_MODE,
        GAME_MODE,
        SPACECRAFT_MODE;


        public static CameraMode getMode(int idx) {
            if (idx >= 0 && idx < CameraMode.values().length) {
                return CameraMode.values()[idx];
            }
            return null;
        }

        public String getKey() {
            return "camera." + String.valueOf((Object)this);
        }

        public String toStringI18n() {
            return I18n.msg(this.getKey());
        }

        public boolean isSpacecraft() {
            return this.equals((Object)SPACECRAFT_MODE);
        }

        public boolean isFocus() {
            return this.equals((Object)FOCUS_MODE);
        }

        public boolean isFree() {
            return this.equals((Object)FREE_MODE);
        }

        public boolean isGame() {
            return this.equals((Object)GAME_MODE);
        }
    }

    public static class BackupProjectionCamera {
        float near;
        float far;
        float fov;
        Vector3 position;
        Vector3 direction;
        Vector3 up;
        float viewportWidth;
        float viewportHeight;

        public BackupProjectionCamera(PerspectiveCamera cam) {
            this.near = cam.near;
            this.far = cam.far;
            this.fov = cam.fieldOfView;
            this.position = new Vector3(cam.position);
            this.direction = new Vector3(cam.direction);
            this.up = new Vector3(cam.up);
            this.viewportHeight = cam.viewportHeight;
            this.viewportWidth = cam.viewportWidth;
        }

        public void restore(PerspectiveCamera cam) {
            if (this.position != null && this.direction != null && this.up != null) {
                cam.near = this.near;
                cam.far = this.far;
                cam.fieldOfView = this.fov;
                cam.position.set(this.position);
                cam.direction.set(this.direction);
                cam.up.set(this.up);
                cam.viewportWidth = this.viewportWidth;
                cam.viewportHeight = this.viewportHeight;
                cam.update();
            }
        }
    }
}

