/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.camera;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.util.ControllerConnectionListener;
import gaiasky.gui.vr.OpenXRListener;
import gaiasky.input.AbstractMouseKbdListener;
import gaiasky.input.GameMouseKbdListener;
import gaiasky.input.MainGamepadListener;
import gaiasky.input.MainMouseKbdListener;
import gaiasky.render.ComponentTypes;
import gaiasky.render.postprocess.effects.CubmeapProjectionEffect;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.AbstractCamera;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Octant;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.scene.record.RotationComponent;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Constants;
import gaiasky.util.DecalUtils;
import gaiasky.util.GlobalResources;
import gaiasky.util.MasterManager;
import gaiasky.util.Settings;
import gaiasky.util.SlaveManager;
import gaiasky.util.camera.Proximity;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.gdx.g2d.Sprite;
import gaiasky.util.gravwaves.RelativisticEffectsManager;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.time.ITimeFrameProvider;
import gaiasky.util.tree.OctreeNode;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jafama.FastMath;

public class NaturalCamera
extends AbstractCamera
implements IObserver {
    private static final double MIN_DIST = 1.0 * Constants.M_TO_U;
    private final Vector3Q force;
    private final Object updateLock = new Object();
    public final Vector3D vrOffset;
    public final Vector3D accel;
    public final Vector3D vel;
    public final Vector3D posBak;
    public final Vector3D direction;
    public final Vector3D up;
    public boolean facingFocus;
    public FocusView focus;
    public FocusView focusBak;
    QuaternionDouble qPrev;
    float fovBackup;
    boolean gravity = true;
    boolean diverted = false;
    boolean vr;
    boolean projectionFlag = false;
    private Vector3Q friction;
    private Vector3Q focusDirection;
    private final Vector3D aux1;
    private final Vector3D aux2;
    private final Vector3D aux5;
    private final Vector3Q dx;
    private final Vector3Q aux1b;
    private final Vector3Q aux2b;
    private final Vector3Q aux3b;
    private final Vector3Q aux4b;
    private final Vector3Q aux5b;
    private final Vector3Q nextFocusPosition;
    private final Vector3Q nextClosestPosition;
    private final Vector2 aux2f2;
    private final Vector3 auxf1;
    private Vector3D pitch;
    private Vector3D yaw;
    private Vector3D roll;
    private Vector3D horizontal;
    private Vector3D vertical;
    private double lastFwdTime = 0.0;
    private double lastFwdAmount = 0.0;
    private double thrust = 0.0;
    private int thrustDirection = 0;
    private boolean fullStop = true;
    private CameraManager.CameraMode lastMode;
    private final FocusView focusView;
    private final FocusView trackingObject;
    private String trackingName;
    private Vector3D lastVel;
    private Vector3Q focusPos;
    private Vector3Q freeTargetPos;
    private boolean freeTargetOn;
    private Vector3Q desired;
    private final Vector3D pointerCartesian;
    private final AtomicBoolean pointerCoordinatesFlag = new AtomicBoolean(false);
    private final AtomicBoolean surfaceModeFlag = new AtomicBoolean(false);
    private boolean firstAux = true;
    private float firstAngle = 0.0f;
    private double velocityGamepad = 0.0;
    private double movementMultiplier = 1.0;
    private double speedMultiplier = 1.0;
    private double speedScaling;
    private double speedScalingCapped;
    private Vector3D velocityVR0;
    private Vector3D velocityVR1;
    private double velocityVRX = 0.0;
    private double velocityVRY = 0.0;
    private IFocus home;
    private AbstractMouseKbdListener currentMouseKbdListener;
    private MainMouseKbdListener naturalMouseKbdListener;
    private GameMouseKbdListener gameMouseKbdListener;
    private MainGamepadListener gamepadListener;
    private OpenXRListener openXRListener;
    private double DIST_SMOOTH_UP;
    private double MAX_ALLOWED_DISTANCE;
    private SpriteBatch spriteBatch;
    private ShapeRenderer shapeRenderer;
    private Sprite spriteFocus;
    private Sprite spriteClosest;
    private Sprite spriteHome;
    private Texture crosshairArrow;
    private Texture crosshairGravWaves;
    private Scene scene;
    double previousRotationAngle = 0.0;
    private double smoothedStarDistance = -1.0;
    private double smoothedDistance = -1.0;

    public NaturalCamera(AssetManager assetManager, CameraManager parent, boolean vr, ShaderProgram spriteShader, ShaderProgram shapeShader) {
        super(parent);
        this.vrOffset = new Vector3D();
        this.vel = new Vector3D();
        this.accel = new Vector3D();
        this.force = new Vector3Q();
        this.posBak = new Vector3D();
        this.qPrev = new QuaternionDouble();
        this.focus = new FocusView();
        this.focusView = new FocusView();
        this.trackingObject = new FocusView();
        this.vr = vr;
        this.pointerCartesian = new Vector3D();
        this.up = new Vector3D(1.0, 0.0, 0.0);
        this.direction = new Vector3D(0.0, 1.0, 0.0);
        this.aux1 = new Vector3D();
        this.aux2 = new Vector3D();
        this.aux5 = new Vector3D();
        this.auxf1 = new Vector3();
        this.aux2f2 = new Vector2();
        this.aux1b = new Vector3Q();
        this.aux2b = new Vector3Q();
        this.aux3b = new Vector3Q();
        this.aux4b = new Vector3Q();
        this.aux5b = new Vector3Q();
        this.dx = new Vector3Q();
        this.nextFocusPosition = new Vector3Q();
        this.nextClosestPosition = new Vector3Q();
        this.initialize(spriteShader, shapeShader);
    }

    public void initialize(ShaderProgram spriteShader, ShaderProgram shapeShader) {
        this.camera = this.vr ? new PerspectiveCamera(Settings.settings.scene.camera.fov, (float)Settings.settings.graphics.backBufferResolution[0], (float)Settings.settings.graphics.backBufferResolution[1]) : new PerspectiveCamera(Settings.settings.scene.camera.fov, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
        this.camera.near = (float)this.CAM_NEAR;
        this.camera.far = (float)this.CAM_FAR;
        this.fovBackup = Settings.settings.scene.camera.fov;
        this.cameras = new PerspectiveCamera[]{this.camera, this.camLeft, this.camRight};
        this.fovFactor = this.camera.fieldOfView / 40.0f;
        this.focusDirection = new Vector3Q();
        this.desired = new Vector3Q();
        this.pitch = new Vector3D(0.0, 0.0, -3.0291598704934586E-6);
        this.yaw = new Vector3D(0.0, 0.0, -7.980720511113759E-6);
        this.roll = new Vector3D(0.0, 0.0, -1.442394423065707E-4);
        this.horizontal = new Vector3D();
        this.vertical = new Vector3D();
        this.friction = new Vector3Q();
        this.lastVel = new Vector3D();
        this.focusPos = new Vector3Q();
        this.freeTargetPos = new Vector3Q();
        this.freeTargetOn = false;
        this.DIST_SMOOTH_UP = 5000.0 * Constants.MPC_TO_U;
        this.MAX_ALLOWED_DISTANCE = 50000.0 * Constants.MPC_TO_U;
        this.naturalMouseKbdListener = new MainMouseKbdListener(this);
        this.gameMouseKbdListener = new GameMouseKbdListener(this);
        this.currentMouseKbdListener = null;
        this.gamepadListener = new MainGamepadListener(this, Settings.settings.controls.gamepad.mappingsFile);
        ControllerConnectionListener controllerConnectionListener = new ControllerConnectionListener();
        Controllers.addListener((ControllerListener)controllerConnectionListener);
        if (this.vr) {
            this.openXRListener = new OpenXRListener(this);
        }
        this.shapeRenderer = new ShapeRenderer(10, shapeShader);
        this.shapeRenderer.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, this.camera.viewportWidth, this.camera.viewportHeight);
        this.spriteBatch = new SpriteBatch(50, spriteShader);
        EventManager.instance.subscribe((IObserver)this, Event.SCENE_LOADED, Event.FOCUS_CHANGE_CMD, Event.FOV_CHANGED_CMD, Event.CAMERA_POS_CMD, Event.CAMERA_DIR_CMD, Event.CAMERA_UP_CMD, Event.CAMERA_PROJECTION_CMD, Event.CAMERA_FWD, Event.CAMERA_ROTATE, Event.CAMERA_PAN, Event.CAMERA_ROLL, Event.CAMERA_TURN, Event.CAMERA_STOP, Event.CAMERA_CENTER, Event.GO_TO_OBJECT_CMD, Event.CUBEMAP_CMD, Event.FREE_MODE_COORD_CMD, Event.FOCUS_NOT_AVAILABLE, Event.TOGGLE_VISIBILITY_CMD, Event.CAMERA_CENTER_FOCUS_CMD, Event.CONTROLLER_CONNECTED_INFO, Event.CONTROLLER_DISCONNECTED_INFO, Event.NEW_DISTANCE_SCALE_FACTOR, Event.CAMERA_TRACKING_OBJECT_CMD);
    }

    @Override
    public void doneLoading(AssetManager manager) {
        GlobalResources globalResources = GaiaSky.instance.getGlobalResources();
        this.spriteFocus = new Sprite(globalResources.getTexture("crosshair-focus"));
        this.spriteClosest = new Sprite(globalResources.getTexture("crosshair-closest"));
        this.spriteHome = new Sprite(globalResources.getTexture("crosshair-home"));
        this.crosshairArrow = globalResources.getTexture("crosshair-arrow");
        this.crosshairGravWaves = globalResources.getTexture("crosshair-arrow");
    }

    private void computeNextPositions(ITimeFrameProvider time) {
        if (this.getMode().isFocus() && this.focus != null) {
            this.focus.getPredictedPosition(this.nextFocusPosition, time, this, false);
        }
        if (this.closestBody != null && !this.closestBody.isEmpty()) {
            if (this.getMode().isFocus() && this.focus.getEntity() == this.closestBody.getEntity()) {
                this.nextClosestPosition.set(this.nextFocusPosition);
            } else {
                this.closestBody.getPredictedPosition(this.nextClosestPosition, time, this, false);
            }
        }
    }

    @Override
    public void update(double dt, ITimeFrameProvider time) {
        if (SlaveManager.projectionActive()) {
            this.camOrientProjection(SlaveManager.instance.yaw, SlaveManager.instance.pitch, SlaveManager.instance.roll);
        }
        this.camUpdate(dt, time);
        if (MasterManager.instance != null) {
            MasterManager.instance.boardcastCameraAndTime(this.pos, this.direction, this.up, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void camUpdate(double dt, ITimeFrameProvider time) {
        this.currentMouseKbdListener.update();
        this.gamepadListener.update();
        if (this.vr) {
            this.openXRListener.update();
        }
        this.computeNextPositions(time);
        this.distance = this.pos.lenDouble();
        CameraManager.CameraMode m = this.parent.current == this ? this.parent.mode : this.lastMode;
        this.speedScaling = m.isGame() ? this.speedScaling(1.0E-5) : this.speedScaling();
        this.speedScalingCapped = FastMath.max((double)(10.0 * Constants.M_TO_U), (double)this.speedScaling);
        switch (m) {
            case FOCUS_MODE: {
                if (!this.focus.isEmpty() && !this.focus.isCoordinatesTimeOverflow() && this.focus.isFocusable()) {
                    double appMagEarth;
                    double appMagCamera;
                    Object object = this.updateLock;
                    synchronized (object) {
                        this.focusBak = this.focus;
                        this.focus.getAbsolutePosition(this.aux4b);
                        if (!this.aux4b.hasNaN()) {
                            this.focusPos.set(this.aux4b);
                        }
                        this.dx.set(0.0f, 0.0f, 0.0f);
                        if (Settings.settings.scene.camera.focusLock.position) {
                            this.dx.set(this.nextFocusPosition).sub(this.focusPos);
                            if (Settings.settings.scene.camera.focusLock.orientation && time.getHdiff() != 0.0 && this.focus.getOrientation() != null) {
                                if (this.focus.getRotationComponent() != null) {
                                    RotationComponent rc = this.focus.getRotationComponent();
                                    double deltaAngle = rc.angle - this.previousRotationAngle;
                                    this.previousRotationAngle = rc.angle;
                                    this.aux5b.set(this.focusPos);
                                    this.aux3b.set(this.pos).sub(this.aux5b);
                                    this.aux2.set(0.0, 1.0, 0.0).mul(this.focus.getOrientation());
                                    this.aux3b.rotate(this.aux2, deltaAngle);
                                    this.aux3b.add(this.aux5b);
                                    this.pos.set(this.aux3b);
                                    this.direction.rotate(this.aux2, deltaAngle);
                                    this.up.rotate(this.aux2, deltaAngle);
                                } else if (this.focus.getOrientationQuaternion() != null) {
                                    QuaternionDouble q = this.focus.getOrientationQuaternion();
                                    this.qPrev.mulInverse(q);
                                    this.qPrev.inverse();
                                    this.aux5b.set(this.aux4b);
                                    this.aux3b.set(this.pos).sub(this.aux5b);
                                    this.aux3b.mul(this.qPrev);
                                    this.aux3b.add(this.aux5b);
                                    this.pos.set(this.aux3b);
                                    this.direction.mul(this.qPrev);
                                    this.up.mul(this.qPrev);
                                    this.qPrev.set(q);
                                }
                            }
                            this.pos.add(this.dx);
                        }
                        this.aux4b.add(this.dx);
                        Vector3Q camObj = this.aux1b.set(this.aux4b).sub(this.pos);
                        double distFromFocus = camObj.lenDouble();
                        this.surfaceModeFlag.set(!this.gamepadInput && !this.vr && !this.isTracking() && this.focus.isPlanet() && distFromFocus < this.focus.getRadius() * 2.5 / (double)this.fovFactor);
                        if (!this.vr) {
                            if (!this.diverted && !this.surfaceModeFlag.get()) {
                                this.directionToTarget(dt, this.aux4b, Settings.settings.scene.camera.turn / (double)(Settings.settings.scene.camera.cinematic ? 1000.0f : 100.0f));
                            } else {
                                this.updateRotationFree(dt, Settings.settings.scene.camera.turn);
                            }
                            this.updateRoll(dt, Settings.settings.scene.camera.turn);
                        }
                        this.updatePosition(dt, this.speedScalingCapped, this.speedScaling);
                        this.updateRotation(dt, this.aux4b);
                        if (this.surfaceModeFlag.get() && this.pointerCoordinatesFlag.get()) {
                            this.focusDirection.set(this.pointerCartesian).nor();
                            this.pointerCoordinatesFlag.set(false);
                        } else {
                            this.focusDirection.set(this.aux4b).sub(this.pos).nor();
                        }
                        this.focus = this.focusBak;
                        double dist = this.aux4b.dstD(this.pos);
                        if (dist < this.focus.getRadius()) {
                            this.aux2b.set(this.pos).sub(this.aux4b).nor().scl(this.focus.getRadius());
                            this.pos.set(this.aux4b).add(this.aux2b);
                        }
                        if (!this.vr && this.isTracking()) {
                            this.trackingObject.getPredictedPosition(this.aux5b, this.trackingName, time, false);
                            this.directionToTrackingObject(this.aux5b);
                        }
                        appMagCamera = this.computeFocusApparentMagnitudeCamera();
                        appMagEarth = this.computeFocusApparentMagnitudeEarth();
                    }
                    EventManager.publish(Event.FOCUS_INFO_UPDATED, this, this.focus.getDistToCamera() - this.focus.getRadius(), this.focus.getSolidAngle(), this.focus.getAlpha(), this.focus.getDelta(), this.focus.getAbsolutePosition(this.aux2b).lenDouble() - this.focus.getRadius(), appMagCamera, appMagEarth);
                    break;
                }
                EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE});
                break;
            }
            case GAME_MODE: {
                Object object = this.updateLock;
                synchronized (object) {
                    if (this.gravity && this.closestBody.getEntity() != null && this.closestBody.isPlanet() && !this.currentMouseKbdListener.isKeyPressed(62)) {
                        Vector3Q camObj = this.closestBody.getAbsolutePosition(this.aux1b).sub(this.pos);
                        double dist = camObj.lenDouble();
                        if (dist < this.closestBody.getRadius() * 2.0) {
                            this.force.add(camObj.nor().scl(0.002));
                            this.fullStop = false;
                        } else {
                            this.fullStop = true;
                        }
                    } else {
                        this.fullStop = true;
                    }
                }
            }
            case FREE_MODE: {
                Object object = this.updateLock;
                synchronized (object) {
                    this.updatePosition(dt, this.speedScalingCapped, Settings.settings.scene.camera.targetMode ? this.speedScaling : 1.0);
                    if (!this.vr) {
                        if (this.freeTargetOn) {
                            this.directionToTarget(dt, this.freeTargetPos, Settings.settings.scene.camera.turn / (Settings.settings.scene.camera.cinematic ? 1000.0 : 100.0));
                            if (this.facingFocus) {
                                this.freeTargetOn = false;
                            }
                        }
                        this.updateRotationFree(dt, Settings.settings.scene.camera.turn);
                        this.updateRoll(dt, Settings.settings.scene.camera.turn);
                    }
                    this.updateLateral(dt, this.speedScalingCapped);
                    break;
                }
            }
        }
        EventManager.publish(Event.UPDATE_CAM_RECORDER, this, time, this.pos, this.direction, this.up);
        this.lastFwdTime += dt;
        this.lastMode = m;
        this.posDistanceCheck();
        if (this.pos.hasNaN()) {
            this.pos.set(this.posBak);
        } else {
            this.posBak.set(this.pos);
        }
        this.updatePerspectiveCamera();
    }

    public void camOrientProjection(float yaw, float pitch, float roll) {
        if (this.projectionFlag) {
            this.direction.rotate(this.up, -yaw);
            this.aux1.set(this.direction).crs(this.up);
            this.direction.rotate(this.aux1, pitch);
            this.up.rotate(this.aux1, pitch);
            this.up.rotate(this.direction, roll);
            this.projectionFlag = false;
        }
    }

    public void updatePerspectiveCamera() {
        this.camera.position.set(0.0f, 0.0f, 0.0f);
        this.camera.direction.set(this.direction.valuesF());
        this.camera.up.set(this.up.valuesF());
        this.camera.update();
        this.posInv.set(this.pos).scl(-1.0);
    }

    public void addForwardForce(double amount) {
        double tu = this.speedScaling();
        if (amount <= 0.0) {
            tu = FastMath.max((double)(10.0 * Constants.M_TO_U), (double)tu);
        }
        if (this.parent.mode == CameraManager.CameraMode.FOCUS_MODE) {
            this.desired.set(this.focusDirection);
        } else {
            this.desired.set(this.direction);
        }
        this.desired.nor().scl(amount * tu * (double)(this.vr ? 10 : 100));
        this.force.add(this.desired);
        this.lastFwdTime = 0.0;
        this.lastFwdAmount = amount;
    }

    public void setVelocityVR(Vector3D p0, Vector3D p1, double amountX, double amountY) {
        if (this.getMode() == CameraManager.CameraMode.FOCUS_MODE) {
            this.setVelocity(amountY);
        } else {
            this.velocityVR0 = p0;
            this.velocityVR1 = p1;
            this.velocityVRX = amountX;
            this.velocityVRY = amountY;
        }
    }

    public void clearVelocityVR() {
        this.setVelocity(0.0);
        this.velocityVR0 = null;
        this.velocityVR1 = null;
        this.velocityVRX = 0.0;
        this.velocityVRY = 0.0;
    }

    public void forward(double amount) {
        this.forward(amount, 0.0);
    }

    public void forward(double amount, double minTu) {
        double speedScaling = this.speedScaling(minTu);
        this.desired.set(this.direction).nor().scl(amount * speedScaling);
        this.vel.add(this.desired).clamp(0.0, 5.0E12);
        this.lastFwdTime = 0.0;
    }

    public void strafe(double amount, double minTu) {
        double speedScaling = this.speedScaling(minTu);
        this.desired.set(this.direction).crs(this.up).nor().scl(amount * speedScaling);
        this.vel.add(this.desired).clamp(0.0, 5.0E12);
        this.lastFwdTime = 0.0;
    }

    public void vertical(double amount) {
        this.vertical(amount, 0.0);
    }

    public void vertical(double amount, double minTu) {
        double speedScaling = this.speedScaling(minTu);
        this.desired.set(this.up).nor().scl(amount * speedScaling);
        this.vel.add(this.desired).clamp(0.0, 5.0E12);
        this.lastFwdTime = 0.0;
    }

    public void addRotateMovement(double deltaX, double deltaY, boolean focusLookKeyPressed, boolean acceleration) {
        if (this.parent.mode.equals((Object)CameraManager.CameraMode.FREE_MODE)) {
            this.addYaw(deltaX *= (double)this.fovFactor, acceleration);
            this.addPitch(deltaY *= (double)this.fovFactor, acceleration);
        } else if (this.parent.mode.equals((Object)CameraManager.CameraMode.FOCUS_MODE)) {
            if (focusLookKeyPressed) {
                this.diverted = true;
                this.addYaw(deltaX * (double)this.fovFactor, acceleration);
                this.addPitch(deltaY * (double)this.fovFactor, acceleration);
            } else {
                double maxRadii;
                double radius = this.focus.getRadius();
                double distanceInRadii = (double)this.getFovFactor() * (this.focus.getDistToCamera() - radius) / radius;
                double factor = distanceInRadii < (maxRadii = 2.0) ? distanceInRadii / maxRadii : 1.0;
                this.addHorizontal(deltaX * factor, acceleration);
                this.addVertical(deltaY * factor, acceleration);
            }
        }
    }

    public void addAmount(Vector3D vec, double amount, boolean x) {
        if (x) {
            vec.x += amount;
        } else {
            vec.y = amount;
        }
    }

    public void addYaw(double amount, boolean acceleration) {
        this.addAmount(this.yaw, amount, acceleration);
    }

    public void setYaw(double amount) {
        this.yaw.x = 0.0;
        this.yaw.y = amount;
    }

    public void addPitch(double amount, boolean acceleration) {
        this.addAmount(this.pitch, amount, acceleration);
    }

    public void setPitch(double amount) {
        this.pitch.x = 0.0;
        this.pitch.y = amount;
    }

    public void addRoll(double amount, boolean acceleration) {
        this.addAmount(this.roll, amount, acceleration);
    }

    public void setRoll(double amount) {
        this.roll.x = 0.0;
        this.roll.y = amount;
    }

    public void addHorizontal(double amount, boolean acceleration) {
        this.addAmount(this.horizontal, amount, acceleration);
    }

    public void setHorizontal(double amount) {
        this.horizontal.x = 0.0;
        this.horizontal.y = amount * (double)this.fovFactor;
    }

    public void addVertical(double amount, boolean acceleration) {
        this.addAmount(this.vertical, amount, acceleration);
    }

    public void setVertical(double amount) {
        this.vertical.x = 0.0;
        this.vertical.y = amount * (double)this.fovFactor;
    }

    public boolean stopMovement() {
        boolean stopped = this.vel.len2() != 0.0 || this.yaw.y != 0.0 || this.pitch.y != 0.0 || this.roll.y != 0.0 || this.vertical.y != 0.0 || this.horizontal.y != 0.0;
        this.force.setZero();
        this.vel.setZero();
        this.yaw.y = 0.0;
        this.pitch.y = 0.0;
        this.roll.y = 0.0;
        this.horizontal.y = 0.0;
        this.vertical.y = 0.0;
        return stopped;
    }

    public void stopTotalMovement() {
        this.force.setZero();
        this.vel.setZero();
        this.yaw.setZero();
        this.pitch.setZero();
        this.roll.setZero();
        this.horizontal.setZero();
        this.vertical.setZero();
    }

    public void stopRotateMovement() {
        this.yaw.setZero();
        this.pitch.setZero();
        this.horizontal.setZero();
        this.vertical.setZero();
    }

    public void stopForwardMovement() {
        this.force.setZero();
        this.vel.setZero();
    }

    protected void updateVelocity(double dt, double multiplier, double speedScaling) {
        boolean cinematic = Settings.settings.scene.camera.cinematic;
        if (this.velocityGamepad != 0.0) {
            this.vel.set(this.direction).nor().scl(this.velocityGamepad * multiplier);
        } else if (this.velocityVRX != 0.0 || this.velocityVRY != 0.0) {
            this.aux1.set(this.velocityVR1).sub(this.velocityVR0).nor();
            this.vel.set(this.aux1).scl(this.velocityVRY * multiplier);
            this.aux1.crs(this.up).nor().scl(this.velocityVRX * multiplier);
            this.vel.add(this.aux1);
        }
        double forceLen = this.force.lenDouble();
        double velocity = this.vel.len();
        if (this.fullStop && this.focus.isValid()) {
            double scl;
            double counterAmount;
            double elevation = this.focus.getElevationAt(this.pos);
            double d = counterAmount = this.lastFwdAmount < 0.0 && cinematic ? FastMath.min((double)speedScaling, (double)200.0) : 2.0;
            if (this.getMode().isFocus() && this.lastFwdAmount > 0.0) {
                counterAmount *= 1.0 / ((this.focus.getDistToCamera() - elevation) / elevation);
            }
            if (Double.isFinite(scl = -velocity * counterAmount * dt)) {
                this.friction.set(this.vel).nor().scl(scl);
            }
        } else {
            this.friction.set(this.force).nor().scl(-forceLen * dt);
        }
        this.force.add(this.friction);
        float f = cinematic ? 250.0f : this.currentMouseKbdListener.getResponseTime();
        if (this.lastFwdTime > (double)f && this.velocityGamepad == 0.0 && this.velocityVRX == 0.0 && this.velocityVRY == 0.0 && this.fullStop || this.lastFwdAmount > 0.0 && speedScaling == 0.0) {
            this.stopForwardMovement();
        }
        if (this.thrust != 0.0) {
            this.force.add(this.thrust).scl(this.thrustDirection);
        }
        this.applyForce(this.force);
        if (!this.force.isZero() || velocity != 0.0 || !this.accel.isZero()) {
            this.vel.add(this.accel.scl(dt)).scl(this.speedMultiplier);
            if (Settings.settings.scene.camera.speedLimit > 0.0 && this.vel.len() > Settings.settings.scene.camera.speedLimit) {
                this.vel.clamp(0.0, Settings.settings.scene.camera.speedLimit);
            }
            if (this.lastVel.dot(this.vel) < 0.0) {
                this.vel.setZero();
            }
            velocity = this.vel.len();
            if (this.parent.mode.equals((Object)CameraManager.CameraMode.FOCUS_MODE)) {
                double sign = FastMath.signum((double)this.vel.dot(this.focusDirection));
                this.vel.set(this.focusDirection).nor().scl(sign * velocity);
            }
            this.vel.clamp(0.0, multiplier * this.speedMultiplier);
        }
    }

    protected void updatePosition(double dt, double multiplier, double speedScaling) {
        this.updateVelocity(dt, multiplier, speedScaling);
        this.aux1b.set(this.vel).scl(dt);
        this.pos.add(this.aux1b);
        this.accel.setZero();
        this.lastVel.set(this.vel);
        this.force.setZero();
        this.posInv.set(this.pos).scl(-1.0);
    }

    private void posDistanceCheck() {
        if (!this.closestBody.isEmpty()) {
            this.aux5b.set(this.nextClosestPosition);
            double elevation = this.closestBody.getElevationAt(this.pos, this.aux5b) + this.closestBody.getHeightScale() / FastMath.max((double)4.0, (double)(20.0 - Settings.settings.scene.renderer.elevation.multiplier));
            double newDist = this.aux5b.scl(-1.0).add(this.pos).lenDouble();
            if (newDist < elevation) {
                this.aux5b.nor().scl(elevation - newDist);
                this.pos.add(this.aux5b);
                this.posInv.set(this.pos).scl(-1.0);
            }
        }
        if (this.pos.lenDouble() >= this.MAX_ALLOWED_DISTANCE) {
            this.pos.clamp(0.0, this.MAX_ALLOWED_DISTANCE);
            this.posInv.set(this.pos).scl(-1.0);
        }
    }

    private void updateRotationFree(double dt, double rotateSpeed) {
        if (this.updatePosition(this.pitch, dt)) {
            this.aux1.set(this.direction).crs(this.up).nor();
            this.rotate(this.aux1, this.pitch.z * rotateSpeed * this.movementMultiplier);
        }
        if (this.updatePosition(this.yaw, dt)) {
            this.rotate(this.up, -this.yaw.z * rotateSpeed * this.movementMultiplier);
        }
        this.defaultState(this.pitch, !Settings.settings.scene.camera.cinematic && !this.gamepadInput);
        this.defaultState(this.yaw, !Settings.settings.scene.camera.cinematic && !this.gamepadInput);
    }

    private void updateRoll(double dt, double rotateSpeed) {
        if (this.updatePosition(this.roll, dt)) {
            this.rotate(this.direction, -this.roll.z * rotateSpeed * this.movementMultiplier);
        }
        this.defaultState(this.roll, !Settings.settings.scene.camera.cinematic && !this.gamepadInput);
    }

    private void updateRotation(double dt, Vector3Q rotationCenter) {
        if (this.updatePosition(this.vertical, dt)) {
            this.aux1.set(this.direction).crs(this.up).nor();
            this.rotateAround(rotationCenter, this.aux1, this.vertical.z * Settings.settings.scene.camera.rotate * this.movementMultiplier);
        }
        if (this.updatePosition(this.horizontal, dt)) {
            this.rotateAround(rotationCenter, this.up, -this.horizontal.z * Settings.settings.scene.camera.rotate * this.movementMultiplier);
        }
        this.defaultState(this.vertical, !Settings.settings.scene.camera.cinematic && !this.gamepadInput);
        this.defaultState(this.horizontal, !Settings.settings.scene.camera.cinematic && !this.gamepadInput);
    }

    private void defaultState(Vector3D vec, boolean resetVelocity) {
        vec.x = 0.0;
        if (resetVelocity) {
            vec.y = 0.0;
        }
    }

    private void updateLateral(double dt, double translateUnits) {
        this.aux1.set(this.direction).crs(this.up).nor();
        this.aux1.scl(this.horizontal.y * translateUnits * this.movementMultiplier);
        this.aux2.set(this.up).nor().scl(this.vertical.y * translateUnits * this.movementMultiplier);
        this.aux1.add(this.aux2);
        if (Settings.settings.scene.camera.speedLimit > 0.0 && this.aux1.len() > Settings.settings.scene.camera.speedLimit) {
            this.aux1.clamp(0.0, Settings.settings.scene.camera.speedLimit);
        }
        if (dt > 0.0) {
            this.translate(this.aux1.scl(dt));
        }
    }

    private boolean updatePosition(Vector3D angle, double dt) {
        if (angle.x != 0.0 || angle.y != 0.0) {
            angle.y += angle.x * dt;
            angle.y = FastMath.signum((double)angle.y) * FastMath.abs((double)angle.y);
            angle.z = angle.y * dt % 360.0;
            return true;
        }
        return false;
    }

    private void directionToTarget(double dt, Vector3Q target, double turnVelocity) {
        this.desired.set(target).sub(this.pos).nor();
        double desiredDirectionAngle = this.desired.angle(this.direction);
        if (desiredDirectionAngle > FastMath.min((double)0.3, (double)(0.3 * (double)this.fovFactor))) {
            this.desired.scl(turnVelocity * dt * this.movementMultiplier);
            this.direction.add(this.desired).nor();
            this.aux1.set(this.direction).crs(this.up);
            this.up.set(this.aux1).crs(this.direction).nor();
            this.facingFocus = false;
        } else {
            this.facingFocus = true;
        }
    }

    private void directionToTrackingObject(Vector3Q target) {
        this.desired.set(target).sub(this.pos).nor();
        this.direction.set(this.desired);
        this.aux1.set(this.direction).crs(this.up);
        this.up.set(this.aux1).crs(this.direction).nor();
        this.facingFocus = false;
    }

    private void setMouseKbdListener(AbstractMouseKbdListener newListener) {
        InputMultiplexer im = (InputMultiplexer)Gdx.input.getInputProcessor();
        if (this.currentMouseKbdListener != null) {
            im.removeProcessor((InputProcessor)this.currentMouseKbdListener);
            this.currentMouseKbdListener.deactivate();
        }
        this.currentMouseKbdListener = newListener;
        im.addProcessor((InputProcessor)this.currentMouseKbdListener);
        this.currentMouseKbdListener.activate();
    }

    @Override
    public void updateMode(ICamera previousCam, CameraManager.CameraMode previousMode, CameraManager.CameraMode newMode, boolean centerFocus) {
        InputProcessor ip = Gdx.input.getInputProcessor();
        if (ip instanceof InputMultiplexer) {
            InputMultiplexer im = (InputMultiplexer)ip;
            switch (newMode) {
                case FOCUS_MODE: {
                    this.diverted = !centerFocus;
                    this.checkFocus();
                }
                case GAME_MODE: 
                case FREE_MODE: {
                    AbstractMouseKbdListener newListener = newMode == CameraManager.CameraMode.GAME_MODE ? this.gameMouseKbdListener : this.naturalMouseKbdListener;
                    this.setMouseKbdListener(newListener);
                    this.addGamepadListener();
                    if (!this.vr) break;
                    GaiaSky.instance.xrDriver.addListener(this.openXRListener);
                    break;
                }
                default: {
                    im.removeProcessor((InputProcessor)this.currentMouseKbdListener);
                    this.removeGamepadListener();
                    if (!this.vr) break;
                    GaiaSky.instance.xrDriver.removeListener(this.openXRListener);
                }
            }
        }
    }

    public MainGamepadListener getGamepadListener() {
        return this.gamepadListener;
    }

    public void addGamepadListener() {
        Settings.settings.controls.gamepad.addControllerListener(this.gamepadListener);
    }

    public void removeGamepadListener() {
        Settings.settings.controls.gamepad.removeControllerListener(this.gamepadListener);
    }

    public void setFocus(String focusName, Entity newFocus) {
        if (newFocus != null && GaiaSky.instance.isOn(((Base)Mapper.base.get((Entity)newFocus)).ct)) {
            this.focus.setEntity(newFocus);
            this.focus.getFocus(focusName != null ? focusName : this.focus.getCandidateName());
            this.focus.makeFocus();
            this.facingFocus = false;
            EventManager.publish(Event.FOCUS_CHANGED, this, this.focus);
        }
    }

    private double computeDistanceScale(double distance, double smoothingDistance0, double smoothingDistance1) {
        if (this.getMode().isFocus()) {
            double focusDistance = this.focus.getDistToCamera() + MIN_DIST;
            double a = distance < smoothingDistance0 ? 0.0 : (distance > smoothingDistance1 ? 1.0 : (distance - smoothingDistance0) / (smoothingDistance1 - smoothingDistance0));
            return MathUtilsDouble.mix(distance, focusDistance, a);
        }
        return distance;
    }

    private double getClosestBodyDistance() {
        return this.closestBody != null ? (this.closestBody.getDistToCamera() - (this.closestBody.getElevationAt(this.pos, false) + MIN_DIST)) * (this.closestBody.isBillboard() ? 15.0 : 1.0) : 1.0E40;
    }

    private double getClosestStarDistance() {
        if (GaiaSky.instance.cameraManager.getMode().isFocus() || !Settings.settings.scene.camera.starDistanceScaling) {
            return Double.MAX_VALUE;
        }
        Proximity.NearbyRecord star = this.proximity.effective[0];
        if (star == null) {
            return 1.0E40;
        }
        double radius = star.getRadius();
        double distance = star.getClosestDistToCamera() + MIN_DIST;
        double dist0Scale = 1000.0;
        double dist1Scale = 1.0E7;
        double rawDistance = this.computeDistanceScale(distance, radius * dist0Scale, radius * dist1Scale);
        this.smoothedStarDistance = MathUtilsDouble.lowPass(rawDistance, this.smoothedStarDistance, 3.0);
        return this.smoothedStarDistance;
    }

    public double speedScaling(double min) {
        double focusDistance = this.getMode().isFocus() ? this.focus.getDistToCamera() : Double.MAX_VALUE;
        double closestBodyDistance = this.getClosestBodyDistance();
        double closestStarDistance = this.getClosestStarDistance();
        double dist = FastMath.min((double)closestStarDistance, (double)FastMath.min((double)closestBodyDistance, (double)focusDistance));
        this.smoothedDistance = MathUtilsDouble.lowPass(dist, this.smoothedDistance, 3.0);
        double distanceMap = MathUtilsDouble.flint(this.smoothedDistance, 0.0, this.DIST_SMOOTH_UP, 0.0, 2.0E16);
        return this.smoothedDistance >= 0.0 ? Math.max(distanceMap, min) * Settings.settings.scene.camera.speed * Constants.DISTANCE_SCALE_FACTOR : 0.0;
    }

    @Override
    public double speedScaling() {
        return this.speedScaling(5.0E-9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case SCENE_LOADED: {
                this.scene = (Scene)data[0];
                this.focus.setScene(this.scene);
                this.focusView.setScene(this.scene);
                this.trackingObject.setScene(this.scene);
                this.closestBody.setScene(this.scene);
                this.closestStarView.setScene(this.scene);
                break;
            }
            case FOCUS_CHANGE_CMD: {
                boolean centerFocus;
                this.setTrackingObject(null, null);
                Entity newFocus = null;
                boolean bl = centerFocus = !this.vr;
                if (data.length > 1) {
                    centerFocus = (Boolean)data[1];
                }
                String focusName = null;
                if (data[0] instanceof String) {
                    focusName = (String)data[0];
                    newFocus = this.scene.getEntity(focusName);
                    this.diverted = !centerFocus;
                } else if (data[0] instanceof FocusView) {
                    newFocus = ((FocusView)data[0]).getEntity();
                    this.diverted = !centerFocus;
                } else if (data[0] instanceof Entity) {
                    newFocus = (Entity)data[0];
                    this.diverted = !centerFocus;
                }
                this.setFocus(focusName, newFocus);
                this.checkFocus();
                break;
            }
            case FOV_CHANGED_CMD: {
                boolean checkMax = source instanceof Actor;
                float fov = MathUtilsDouble.clamp(((Float)data[0]).floatValue(), 1.0f, checkMax ? 150.0f : 179.0f);
                for (PerspectiveCamera cam : this.cameras) {
                    cam.fieldOfView = fov;
                }
                this.fovFactor = this.camera.fieldOfView / 40.0f;
                break;
            }
            case CUBEMAP_CMD: {
                boolean state = (Boolean)data[0];
                CubmeapProjectionEffect.CubemapProjection p = (CubmeapProjectionEffect.CubemapProjection)((Object)data[1]);
                if (!p.isPlanetarium() || !state || this.vr) break;
                this.fovBackup = GaiaSky.instance.cameraManager.getCamera().fieldOfView;
                break;
            }
            case CAMERA_POS_CMD: {
                Object state = this.updateLock;
                synchronized (state) {
                    this.pos.set((double[])data[0]);
                    this.posInv.set(this.pos).scl(-1.0);
                    break;
                }
            }
            case CAMERA_DIR_CMD: {
                Object state = this.updateLock;
                synchronized (state) {
                    this.direction.set((double[])data[0]).nor();
                    break;
                }
            }
            case CAMERA_UP_CMD: {
                Object state = this.updateLock;
                synchronized (state) {
                    this.up.set((double[])data[0]).nor();
                    break;
                }
            }
            case CAMERA_PROJECTION_CMD: {
                Object state = this.updateLock;
                synchronized (state) {
                    this.pos.set((double[])data[0]);
                    this.posInv.set(this.pos).scl(-1.0);
                    this.direction.set((double[])data[1]).nor();
                    this.up.set((double[])data[2]).nor();
                    this.projectionFlag = true;
                    break;
                }
            }
            case CAMERA_FWD: {
                Object state = this.updateLock;
                synchronized (state) {
                    this.addForwardForce((Double)data[0]);
                    break;
                }
            }
            case CAMERA_ROTATE: {
                Object state = this.updateLock;
                synchronized (state) {
                    this.addRotateMovement((Double)data[0], (Double)data[1], false, true);
                    break;
                }
            }
            case CAMERA_TURN: {
                Object state = this.updateLock;
                synchronized (state) {
                    this.addRotateMovement((Double)data[0], (Double)data[1], true, true);
                    break;
                }
            }
            case CAMERA_ROLL: {
                Object state = this.updateLock;
                synchronized (state) {
                    this.addRoll((Double)data[0], Settings.settings.scene.camera.cinematic);
                    break;
                }
            }
            case CAMERA_STOP: {
                Object state = this.updateLock;
                synchronized (state) {
                    this.stopTotalMovement();
                    break;
                }
            }
            case CAMERA_CENTER: {
                Object state = this.updateLock;
                synchronized (state) {
                    this.diverted = false;
                    break;
                }
            }
            case GO_TO_OBJECT_CMD: {
                if (this.focus == null || !this.focus.isValid()) break;
                FocusView f = this.focus;
                GaiaSky.postRunnable(() -> {
                    this.setTrackingObject(null, null);
                    this.stopTotalMovement();
                    f.getAbsolutePosition(this.aux1b);
                    this.pos.set(this.aux1b);
                    double dx = 0.0;
                    double dy = f.getSize() / 4.0;
                    double dz = -f.getSize() * 4.0;
                    if (this.vr) {
                        dz = -dz;
                    }
                    this.pos.add(dx, dy, dz);
                    this.posInv.set(this.pos).scl(-1.0);
                    this.direction.set(-dx, -dy, -dz).nor();
                    this.up.set(this.direction.x, this.direction.z, -this.direction.y).nor();
                    this.rotate(this.up, 0.01);
                    this.updatePerspectiveCamera();
                });
                break;
            }
            case FREE_MODE_COORD_CMD: {
                Object f = this.updateLock;
                synchronized (f) {
                    double ra = (Double)data[0];
                    double dec = (Double)data[1];
                    double dist = 1.0E12 * Constants.PC_TO_U;
                    this.aux1.set(Math.PI / 180 * ra, Math.PI / 180 * dec, dist);
                    Coordinates.sphericalToCartesian(this.aux1, this.aux2);
                    this.freeTargetPos.set(this.aux2);
                    this.facingFocus = false;
                    this.freeTargetOn = true;
                    break;
                }
            }
            case FOCUS_NOT_AVAILABLE: {
                if (!this.getMode().isFocus()) break;
                boolean found = false;
                Object focusName = data[0];
                if (focusName instanceof Entity) {
                    Entity entity = (Entity)focusName;
                    if (Mapper.octree.has(entity)) {
                        Octant root = (Octant)Mapper.octant.get(entity);
                        OctreeNode octant = this.focus.getOctant();
                        if (octant != null && octant.getRoot() == root.octant) {
                            found = true;
                        }
                    } else if (Mapper.datasetDescription.has(entity)) {
                        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
                        found = graph.children != null && graph.children.contains((Object)this.focus.getEntity(), true);
                    } else if (Mapper.focus.has(entity)) {
                        this.focus.setEntity(entity);
                        found = this.isFocus(entity);
                    }
                }
                if (!found) break;
                EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE});
                break;
            }
            case TOGGLE_VISIBILITY_CMD: {
                if (!this.getMode().isFocus()) break;
                ComponentTypes.ComponentType ct = ComponentTypes.ComponentType.getFromKey((String)data[0]);
                if (this.focus == null || !this.focus.isValid() || ct == null || !this.focus.getCt().isEnabled(ct)) break;
                EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE});
                break;
            }
            case CAMERA_CENTER_FOCUS_CMD: {
                Object ct = this.updateLock;
                synchronized (ct) {
                    this.setCenterFocus((Boolean)data[0]);
                    break;
                }
            }
            case CONTROLLER_CONNECTED_INFO: {
                Settings.settings.controls.gamepad.addControllerListener(this.gamepadListener, (String)data[0]);
                break;
            }
            case CONTROLLER_DISCONNECTED_INFO: {
                break;
            }
            case NEW_DISTANCE_SCALE_FACTOR: {
                Object ct = this.updateLock;
                synchronized (ct) {
                    this.DIST_SMOOTH_UP = 5000.0 * Constants.MPC_TO_U;
                    this.MAX_ALLOWED_DISTANCE = 50000.0 * Constants.MPC_TO_U;
                    break;
                }
            }
            case CAMERA_TRACKING_OBJECT_CMD: {
                Entity newTrackingObject = (Entity)data[0];
                String newTrackingName = (String)data[1];
                Object object = this.updateLock;
                synchronized (object) {
                    this.setTrackingObject(newTrackingObject, newTrackingName != null ? newTrackingName.toLowerCase(Locale.ROOT) : null);
                    break;
                }
            }
        }
    }

    public void rotateAround(Vector3Q rotationCenter, Vector3D rotationAxis, double angle) {
        this.rotate(rotationAxis, angle);
        this.aux3b.set(this.pos).sub(rotationCenter);
        this.aux3b.rotate(rotationAxis, angle);
        this.pos.set(this.aux3b).add(rotationCenter);
        this.posDistanceCheck();
    }

    public void rotate(Vector3D axis, double angle) {
        if (!axis.hasNaN() && Double.isFinite(angle)) {
            this.direction.rotate(axis, angle);
            this.up.rotate(axis, angle);
        }
    }

    public void translate(double x, double y, double z) {
        if (Double.isFinite(x) && Double.isFinite(y) && Double.isFinite(z)) {
            this.pos.add(x, y, z);
            this.posDistanceCheck();
        }
    }

    public void translate(Vector3D vec) {
        if (vec != null && !vec.hasNaN()) {
            this.pos.add(vec);
            this.posDistanceCheck();
        }
    }

    protected void applyForce(Vector3Q force) {
        if (force != null && !force.hasNaN()) {
            this.accel.add(force);
        }
    }

    @Override
    public PerspectiveCamera[] getFrontCameras() {
        return new PerspectiveCamera[]{this.camera};
    }

    @Override
    public PerspectiveCamera getCamera() {
        return this.camera;
    }

    @Override
    public void setCamera(PerspectiveCamera perspectiveCamera) {
        this.camera = perspectiveCamera;
    }

    @Override
    public Vector3D getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(Vector3D dir) {
        this.direction.set(dir);
    }

    @Override
    public Vector3D getUp() {
        return this.up;
    }

    public void setUp(Vector3D up) {
        this.up.set(up);
    }

    @Override
    public Vector3D[] getDirections() {
        return new Vector3D[]{this.direction};
    }

    @Override
    public int getNCameras() {
        return 1;
    }

    @Override
    public CameraManager.CameraMode getMode() {
        return this.parent.mode;
    }

    @Override
    public double getSpeed() {
        return this.parent.getSpeed();
    }

    @Override
    public boolean isFocus(Entity focus) {
        return this.focus != null && this.focus.getEntity() == focus;
    }

    @Override
    public IFocus getFocus() {
        return this.getMode().equals((Object)CameraManager.CameraMode.FOCUS_MODE) ? this.focus : null;
    }

    @Override
    public boolean hasFocus() {
        return this.getMode().equals((Object)CameraManager.CameraMode.FOCUS_MODE) && this.focus != null && !this.focus.isEmpty();
    }

    private void checkFocus() {
        if (this.focus.isValid() && !Mapper.hip.has(this.focus.getEntity()) && this.focus.getSet() == null) {
            this.focus.getAbsolutePosition(this.aux1b);
            if (this.pos.dstD(this.aux1b, this.aux2b) < this.focus.getRadius()) {
                this.stopTotalMovement();
                this.focus.getAbsolutePosition(this.aux1b);
                this.pos.set(this.aux1b);
                this.pos.add(0.0, 0.0, -this.focus.getSize() * 6.0);
                this.posInv.set(this.pos).scl(-1.0);
                this.direction.set(0.0, 0.0, 1.0);
            }
        } else if (!this.focus.isValid() && this.closest != null && this.closest.isValid()) {
            this.focus.setEntity(((FocusView)this.closest).getEntity());
            this.checkFocus();
        }
    }

    public void setCenterFocus(boolean centerFocus) {
        this.diverted = !centerFocus;
    }

    private double computeFocusApparentMagnitudeCamera() {
        if (this.focus.isParticle() || this.focus.getMag() == null) {
            return 5.0 * FastMath.log10((double)(this.focus.getDistToCamera() * Constants.U_TO_PC)) - 5.0 + (double)this.focus.getAbsmag();
        }
        if (this.focus.getMag() != null) {
            double distCamAu = this.pos.put(this.aux4b).sub(this.focus.getAbsolutePosition(this.aux5b)).lenDouble() * Constants.U_TO_AU;
            IFocus starAncestor = this.focus.getFirstStarAncestor();
            double distStarAu = (starAncestor != null ? starAncestor.getAbsolutePosition(this.aux4b).sub(this.focus.getAbsolutePosition(this.aux5b)).lenDouble() : this.focus.getAbsolutePosition(this.aux5b).lenDouble()) * Constants.U_TO_AU;
            return 5.0 * FastMath.log10((double)(distStarAu * distCamAu)) + (double)this.focus.getAbsmag();
        }
        return Double.NaN;
    }

    private double computeFocusApparentMagnitudeEarth() {
        Entity earth = this.scene.getEntity("Earth");
        if (this.focus.getMag() != null && earth != null) {
            double distEarthAu = EntityUtils.getAbsolutePosition(earth, this.aux4b).sub(this.focus.getAbsolutePosition(this.aux5b)).lenDouble() * Constants.U_TO_AU;
            IFocus starAncestor = this.focus.getFirstStarAncestor(this.focusView);
            double distStarAu = (starAncestor != null ? starAncestor.getAbsolutePosition(this.aux4b).sub(this.focus.getAbsolutePosition(this.aux5b)).lenDouble() : this.focus.getAbsolutePosition(this.aux5b).lenDouble()) * Constants.U_TO_AU;
            return 5.0 * FastMath.log10((double)(distStarAu * distEarthAu)) + (double)this.focus.getAbsmag();
        }
        return Double.NaN;
    }

    public void setThrust(double thrust, int direction) {
        this.thrust = thrust;
        this.thrustDirection = direction;
    }

    @Override
    public void render(int rw, int rh) {
        boolean modeStereo = Settings.settings.program.modeStereo.active;
        boolean modeStereoVR = modeStereo && Settings.settings.program.modeStereo.isStereoVR();
        boolean modeCubemap = Settings.settings.program.modeCubemap.active;
        boolean modeReprojection = Settings.settings.postprocess.reprojection.active;
        if (modeStereoVR || modeReprojection) {
            return;
        }
        if (Settings.settings.program.pointer.guides.active && !modeStereo && !modeCubemap && !this.vr) {
            int mouseX = Gdx.input.getX();
            int mouseY = rh - Gdx.input.getY();
            this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            Gdx.gl.glEnable(3042);
            Gdx.gl.glLineWidth(Settings.settings.program.pointer.guides.width);
            float[] pc = Settings.settings.program.pointer.guides.color;
            this.shapeRenderer.setColor(pc[0], pc[1], pc[2], pc[3]);
            this.shapeRenderer.line(0.0f, (float)mouseY, (float)rw, (float)mouseY);
            this.shapeRenderer.line((float)mouseX, 0.0f, (float)mouseX, (float)rh);
            this.shapeRenderer.end();
        }
        this.spriteBatch.begin();
        boolean decal = modeCubemap || modeStereo || this.vr;
        float chScale = 2.0f / GaiaSky.instance.getUnitsPerPixel();
        if (modeCubemap) {
            chScale = 4.0f;
        }
        if (Settings.settings.scene.crosshair.home) {
            if (this.home == null && this.scene != null) {
                Entity homeEntity = this.scene.findFocus(Settings.settings.scene.homeObject);
                this.home = new FocusView(homeEntity);
            }
            if (this.home != null) {
                this.drawCrossHair(this.spriteBatch, this.home, decal, false, this.spriteHome, this.crosshairArrow, chScale, rw, rh, 1.0f, 0.7f, 0.1f, 1.0f);
            }
        }
        if (Settings.settings.scene.crosshair.closest && this.closest != null) {
            this.drawCrossHair(this.spriteBatch, this.closest, decal, false, this.spriteClosest, this.crosshairArrow, chScale, rw, rh, 0.3f, 0.5f, 1.0f, 0.6f);
        }
        if (Settings.settings.scene.crosshair.focus && this.getMode().isFocus()) {
            this.drawCrossHair(this.spriteBatch, this.focus, decal, true, this.spriteFocus, this.crosshairArrow, chScale, rw, rh, 0.2f, 1.0f, 0.4f, 1.0f);
        }
        if (Settings.settings.runtime.gravitationalWaves) {
            RelativisticEffectsManager gw = RelativisticEffectsManager.getInstance();
            float chw = this.crosshairGravWaves.getWidth();
            float chh = this.crosshairGravWaves.getHeight();
            float chw2 = chw / 2.0f;
            float chh2 = chh / 2.0f;
            this.aux1.set(gw.gw).nor().scl(1.0E12).add(this.posInv);
            GlobalResources.applyRelativisticAberration(this.aux1, this);
            boolean inside = this.projectToScreen(this.aux1, this.auxf1, rw, rh, chw2, chh2);
            if (inside) {
                this.spriteBatch.setColor(0.0f, 1.0f, 1.0f, 1.0f);
                this.spriteBatch.draw(this.crosshairGravWaves, this.auxf1.x - chw2, this.auxf1.y - chh2, chw, chh);
            }
        }
        this.spriteBatch.end();
    }

    private void drawCrossHairDecal(SpriteBatch batch, IFocus chFocus, boolean focusMode, Sprite sprite, float r, float g, float b, float a) {
        sprite.setColor(r, g, b, a);
        Vector3Q p = !focusMode ? chFocus.getClosestAbsolutePos(this.aux1b).add(this.posInv) : chFocus.getAbsolutePosition(this.aux1b).add(this.posInv);
        Vector3D pos = this.aux5;
        p.put(pos);
        DecalUtils.drawSprite(sprite, batch, (float)pos.x, (float)pos.y, (float)pos.z, 8.0E-4, 1.0f, this, true, 0.04f, 0.04f);
    }

    private void drawCrossHair(SpriteBatch batch, IFocus chFocus, boolean decal, boolean focusMode, Sprite crosshairSprite, Texture arrowTex, float crosshairScale, int rw, int rh, float r, float g, float b, float a) {
        if (chFocus != null) {
            if (decal) {
                crosshairSprite.setScale(crosshairScale);
                this.drawCrossHairDecal(batch, chFocus, focusMode, crosshairSprite, r, g, b, a);
            } else if (!focusMode) {
                this.drawCrossHair(chFocus.getClosestAbsolutePos(this.aux1b).add(this.posInv), chFocus.getClosestDistToCamera(), chFocus.getRadius(), crosshairSprite.getTexture(), crosshairScale, arrowTex, rw, rh, r, g, b, a);
            } else {
                this.drawCrossHair(chFocus.getAbsolutePosition(this.aux1b).add(this.posInv), chFocus.getDistToCamera(), chFocus.getRadius(), crosshairSprite.getTexture(), crosshairScale, arrowTex, rw, rh, r, g, b, a);
            }
        }
    }

    private void drawCrossHair(Vector3Q p, double distToCam, double radius, Texture crossHairTex, float crossHairScale, Texture arrowTex, int rw, int rh, float r, float g, float b, float a) {
        if (distToCam > radius * 2.0) {
            float chw = (float)crossHairTex.getWidth() * crossHairScale;
            float chh = (float)crossHairTex.getHeight() * crossHairScale;
            float chw2 = chw / 2.0f;
            float chh2 = chh / (float)(this.vr ? 1 : 2);
            Vector3D pos = this.aux5;
            p.put(pos);
            GlobalResources.applyRelativisticAberration(pos, this);
            RelativisticEffectsManager.getInstance().gravitationalWavePos(pos);
            if (this.vr) {
                pos.nor().scl(distToCam - radius);
            }
            boolean inside = this.projectToScreen(pos, this.auxf1, rw, rh, chw2, chh2);
            this.spriteBatch.setColor(r, g, b, a);
            if (inside) {
                this.spriteBatch.draw(crossHairTex, this.auxf1.x - chw2, this.auxf1.y - chh2, chw, chh);
            } else if (this.vr) {
                float ang;
                float f = ang = this.firstAux ? -90.0f + this.aux2f2.angleDeg() : this.firstAngle;
                if (this.firstAux) {
                    this.firstAngle = ang;
                }
                this.firstAux = !this.firstAux;
                this.aux2f2.set(this.auxf1.x - (float)rw / 2.0f, this.auxf1.y - (float)rh / 2.0f);
                this.aux2.set(this.up).rotate(this.direction, 90.0).add(this.up).scl(0.04);
                this.aux1.set(this.vrOffset).add(this.aux2).scl(1.0 / Constants.M_TO_U).add(this.direction);
                this.projectToScreen(this.aux1, this.auxf1, rw, rh, chw2, chh2);
                this.spriteBatch.draw(arrowTex, this.auxf1.x, this.auxf1.y, chw2, chh2, chw, chh, 1.0f, 1.0f, ang, 0, 0, (int)chw, (int)chw, false, false);
            } else {
                this.aux2f2.set(this.auxf1.x - (float)rw / 2.0f, this.auxf1.y - (float)rh / 2.0f);
                this.spriteBatch.draw(arrowTex, this.auxf1.x - chw2, this.auxf1.y - chh2, chw2, chh2, chw, chh, 1.0f, 1.0f, -90.0f + this.aux2f2.angleDeg(), 0, 0, (int)chw, (int)chh, false, false);
            }
        }
    }

    private boolean projectToScreen(Vector3D vec, Vector3 out, int rw, int rh, float chw2, float chh2) {
        vec.put(out);
        this.camera.project(out, 0.0f, 0.0f, (float)rw, (float)rh);
        double ang = this.direction.angle(vec);
        if (ang > 90.0) {
            out.x = (float)rw - out.x;
            out.y = (float)rh - out.y;
            float w2 = (float)rw / 2.0f;
            float h2 = (float)rh / 2.0f;
            if (out.x <= w2 && out.y >= h2) {
                out.x = chw2;
                out.y = (float)rh - chh2;
            } else if (out.x > w2 && out.y > h2) {
                out.x = (float)rw - chw2;
                out.y = (float)rh - chh2;
            } else if (out.x <= w2) {
                out.x = chw2;
                out.y = chh2;
            } else if (out.y < h2) {
                out.x = (float)rw - chw2;
                out.y = chh2;
            }
        }
        out.x = MathUtils.clamp((float)out.x, (float)chw2, (float)((float)rw - chw2));
        out.y = MathUtils.clamp((float)out.y, (float)chh2, (float)((float)rh - chh2));
        return ang * 2.0 < (double)this.camera.fieldOfView;
    }

    @Override
    public void resize(int width, int height) {
        if (!this.vr) {
            this.camera.viewportHeight = height;
            this.camera.viewportWidth = width;
            this.camera.update(true);
        }
        this.spriteBatch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, this.camera.viewportWidth, this.camera.viewportHeight);
        this.shapeRenderer.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, this.camera.viewportWidth, this.camera.viewportHeight);
    }

    @Override
    public void setPointerProjectionOnFocus(Vector3 point) {
        this.pointerCartesian.set(point);
        this.pointerCoordinatesFlag.set(true);
    }

    @Override
    public double getSpeedScaling() {
        return this.speedScaling;
    }

    @Override
    public double getSpeedScalingCapped() {
        return this.speedScalingCapped;
    }

    @Override
    public Vector3D getVelocity() {
        return this.vel;
    }

    public void setVelocity(double amount) {
        this.velocityGamepad = amount;
    }

    public void setDiverted(boolean diverted) {
        this.diverted = diverted;
    }

    public void setCameraMultipliers(double movementMultiplier, double speedMultiplier) {
        this.movementMultiplier = movementMultiplier;
        this.speedMultiplier = speedMultiplier;
    }

    public AbstractMouseKbdListener getCurrentMouseKbdListener() {
        return this.currentMouseKbdListener;
    }

    private void setTrackingObject(Entity trackingObject, String trackingName) {
        this.trackingObject.setEntity(trackingObject);
        this.trackingName = trackingName;
        EventManager.publish(Event.CAMERA_TRACKING_OBJECT_UPDATE, this, new FocusView(trackingObject), trackingName);
    }

    public Scene getScene() {
        return this.scene;
    }

    @Override
    public boolean isRotating() {
        return this.getMode().isFocus() && (FastMath.abs((double)this.horizontal.y) > 1.0E-6 || FastMath.abs((double)this.vertical.y) > 1.0E-6);
    }

    private boolean isTracking() {
        return this.trackingObject != null && this.trackingName != null;
    }
}

