/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.camera;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.input.GestureDetector;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.input.SpacecraftGamepadListener;
import gaiasky.input.SpacecraftMouseKbdListener;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.AbstractCamera;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.view.FocusView;
import gaiasky.scene.view.SpacecraftView;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.coord.SpacecraftCoordinates;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.time.ITimeFrameProvider;
import net.jafama.FastMath;

public class SpacecraftCamera
extends AbstractCamera
implements IObserver {
    private final SpacecraftMouseKbdListener spacecraftMouseKbdListener;
    private final Vector3D aux1;
    private final Vector3D aux2;
    private final Vector3Q aux1b;
    private final Vector3Q toDesired;
    private final Vector3Q desired;
    private final Vector3D scThrust;
    private final Vector3D scForce;
    private final Vector3D scAccel;
    private final Vector3D scVel;
    private final Vector3D scDir;
    private final Vector3D scUp;
    private final Pair<Vector3D, Vector3D> dirUp;
    public Vector3D direction = new Vector3D(1.0, 0.0, 0.0);
    public Vector3D up = new Vector3D(0.0, 1.0, 0.0);
    public Vector3Q relPos = new Vector3Q();
    private Entity sc;
    private final SpacecraftView view;
    private final SpacecraftGamepadListener gamepadListener;
    private final FocusView secondClosest;
    private final FocusView auxView;
    private Vector3Q scpos;
    private double targetDistance;

    public SpacecraftCamera(CameraManager parent) {
        super(parent);
        this.toDesired = new Vector3Q();
        this.desired = new Vector3Q();
        this.aux1 = new Vector3D();
        this.aux2 = new Vector3D();
        this.aux1b = new Vector3Q();
        this.scThrust = new Vector3D();
        this.scForce = new Vector3D();
        this.scAccel = new Vector3D();
        this.scVel = new Vector3D();
        this.scpos = new Vector3Q();
        this.scDir = new Vector3D();
        this.scUp = new Vector3D();
        this.dirUp = new Pair<Vector3D, Vector3D>(this.scDir, this.scUp);
        this.view = new SpacecraftView();
        this.secondClosest = new FocusView();
        this.auxView = new FocusView();
        this.camera = new PerspectiveCamera(40.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
        this.camera.near = (float)this.CAM_NEAR;
        this.camera.far = (float)this.CAM_FAR;
        this.cameras = new PerspectiveCamera[]{this.camera, this.camLeft, this.camRight};
        PerspectiveCamera guiCam = new PerspectiveCamera(30.0f, 300.0f, 300.0f);
        guiCam.near = (float)this.CAM_NEAR;
        guiCam.far = (float)this.CAM_FAR;
        this.ar = (float)Gdx.graphics.getWidth() / (float)Gdx.graphics.getHeight();
        this.fovFactor = this.camera.fieldOfView / 40.0f;
        this.spacecraftMouseKbdListener = new SpacecraftMouseKbdListener(this, (GestureDetector.GestureListener)new GestureDetector.GestureAdapter());
        this.gamepadListener = new SpacecraftGamepadListener(this, Settings.settings.controls.gamepad.mappingsFile);
        EventManager.instance.subscribe((IObserver)this, Event.FOV_CHANGED_CMD, Event.SPACECRAFT_LOADED, Event.SPACECRAFT_MACHINE_SELECTION_INFO);
    }

    @Override
    public void doneLoading(AssetManager manager) {
    }

    public Entity getSpacecraft() {
        return this.sc;
    }

    public SpacecraftView getSpacecraftView() {
        return this.view;
    }

    @Override
    public PerspectiveCamera getCamera() {
        return this.camera;
    }

    @Override
    public void setCamera(PerspectiveCamera perspectiveCamera) {
        this.camera = perspectiveCamera;
    }

    @Override
    public PerspectiveCamera[] getFrontCameras() {
        return new PerspectiveCamera[]{this.camera};
    }

    @Override
    public Vector3D getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(Vector3D dir) {
        this.direction.set(dir);
    }

    @Override
    public Vector3D getUp() {
        return this.up;
    }

    @Override
    public Vector3D[] getDirections() {
        return new Vector3D[]{this.direction};
    }

    @Override
    public int getNCameras() {
        return 1;
    }

    @Override
    public void update(double dt, ITimeFrameProvider time) {
        this.spacecraftMouseKbdListener.update();
        this.gamepadListener.update();
        this.scThrust.set(this.view.thrust());
        this.scForce.set(this.view.force());
        this.scAccel.set(this.view.accel());
        this.scVel.set(this.view.vel());
        this.scpos.set(this.view.pos());
        this.scpos = ((SpacecraftCoordinates)this.view.getCoordinates()).computePosition(dt, this.secondClosest, this.view.currentEnginePower(), this.scThrust, this.view.direction(), this.scForce, this.scAccel, this.scVel, this.scpos);
        this.scDir.set(this.view.direction());
        this.scUp.set(this.view.up());
        this.view.computeDirectionUp(dt, this.dirUp);
        this.updateHard(dt);
        this.distance = this.pos.lenDouble();
        this.updatePerspectiveCamera();
        String closestName = null;
        double closestDistance = -1.0;
        if (this.closestStar != null) {
            double closestStarDist = this.closestStar.getClosestDistToCamera();
            String closestStarName = this.closestStar.getClosestName();
            if (this.secondClosest != null && this.secondClosest.isValid()) {
                if (this.secondClosest.getDistToCamera() < closestStarDist) {
                    closestName = this.secondClosest.getName();
                    closestDistance = this.secondClosest.getDistToCamera();
                } else {
                    closestName = closestStarName;
                    closestDistance = closestStarDist;
                }
            } else {
                closestName = closestStarName;
                closestDistance = closestStarDist;
            }
        }
        EventManager.publish(Event.SPACECRAFT_NEAREST_INFO, this, closestName, closestDistance);
    }

    public void updateHard(double dt) {
        if (this.sc != null) {
            double tDistOverFov = this.targetDistance / (double)this.fovFactor;
            this.desired.set(this.scDir).nor().scl(-tDistOverFov);
            this.aux1b.set(this.scUp).nor().scl(tDistOverFov * 0.125);
            this.desired.add(this.aux1b);
            this.toDesired.set(this.desired).sub(this.relPos);
            this.toDesired.scl(dt * this.view.getResponsiveness()).scl(1.0E-6);
            this.relPos.add(this.toDesired);
            this.pos.set(this.scpos).add(this.relPos);
            this.aux1.set(this.scUp).nor().scl(this.targetDistance);
            this.aux2.set(this.scDir).nor().scl(tDistOverFov * 50.0).add(this.aux1);
            this.aux1b.set(this.scpos).add(this.aux2).sub(this.pos).nor();
            this.aux1b.put(this.direction);
            this.desired.set(this.scUp);
            this.toDesired.set(this.desired).sub(this.up);
            this.toDesired.scl(dt * this.view.getResponsiveness()).scl(1.0E-8);
            this.up.add(this.toDesired).nor();
        }
    }

    protected void updatePerspectiveCamera() {
        this.camera.fieldOfView = 40.0f;
        this.fovFactor = this.camera.fieldOfView / 40.0f;
        this.camera.position.set(0.0f, 0.0f, 0.0f);
        this.direction.put(this.camera.direction);
        this.up.put(this.camera.up);
        this.camera.update();
        this.posInv.set(this.pos).scl(-1.0);
    }

    @Override
    public void updateMode(ICamera previousCam, CameraManager.CameraMode previousMode, CameraManager.CameraMode mode, boolean centerFocus) {
        InputProcessor ip = Gdx.input.getInputProcessor();
        if (ip instanceof InputMultiplexer) {
            InputMultiplexer im = (InputMultiplexer)ip;
            if (mode == CameraManager.CameraMode.SPACECRAFT_MODE && this.sc != null && previousMode != CameraManager.CameraMode.SPACECRAFT_MODE) {
                GaiaSky.postRunnable(() -> {
                    if (!im.getProcessors().contains((Object)this.spacecraftMouseKbdListener, true)) {
                        im.addProcessor((InputProcessor)this.spacecraftMouseKbdListener);
                    }
                    this.addGamepadListener();
                    Controllers.clearListeners();
                    this.view.stopAllMovement();
                    this.view.pos().set(previousCam.getPos());
                    this.view.direction().set(previousCam.getDirection());
                    this.view.up().set(this.view.pos()).crs(this.view.direction());
                    this.pos.set(this.view.pos());
                    this.direction.set(this.view.direction());
                    this.up.set(this.view.up());
                    this.updateAngleEdge(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
                });
            } else if (this.view != null && this.view.getEntity() != null) {
                GaiaSky.postRunnable(() -> {
                    im.removeProcessor((InputProcessor)this.spacecraftMouseKbdListener);
                    this.removeGamepadListener();
                    this.view.stopAllMovement();
                });
            }
        }
    }

    @Override
    public CameraManager.CameraMode getMode() {
        return this.parent.mode;
    }

    @Override
    public double getSpeed() {
        return this.parent.getSpeed();
    }

    @Override
    public IFocus getFocus() {
        return null;
    }

    @Override
    public boolean hasFocus() {
        return false;
    }

    @Override
    public boolean isFocus(Entity entity) {
        return false;
    }

    public void addGamepadListener() {
        Settings.settings.controls.gamepad.addControllerListener(this.gamepadListener);
        this.gamepadListener.activate();
    }

    public void removeGamepadListener() {
        Settings.settings.controls.gamepad.removeControllerListener(this.gamepadListener);
        this.gamepadListener.deactivate();
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case SPACECRAFT_LOADED: {
                this.sc = (Entity)data[0];
                this.view.setEntity(this.sc);
                this.updateTargetDistance();
                break;
            }
            case SPACECRAFT_MACHINE_SELECTION_INFO: {
                this.updateTargetDistance();
                break;
            }
        }
    }

    private void updateTargetDistance() {
        this.targetDistance = (double)this.view.size() * 3.5;
    }

    @Override
    public void checkClosestBody(IFocus cb) {
        FocusView fv;
        super.checkClosestBody(cb);
        if (this.sc != null && cb instanceof FocusView && (fv = (FocusView)cb).getEntity() != this.sc && cb.getDistToCamera() < this.secondClosest.getDistToCamera()) {
            this.secondClosest.setEntity(fv.getEntity());
        }
    }

    @Override
    public void checkClosestBody(Entity cb) {
        super.checkClosestBody(cb);
        if (this.sc != null && cb != null) {
            this.auxView.setEntity(cb);
            if (this.secondClosest.isEmpty() || cb != this.sc && this.auxView.getDistToCamera() < this.secondClosest.getDistToCamera()) {
                this.secondClosest.setEntity(cb);
            }
        }
    }

    @Override
    public IFocus getSecondClosestBody() {
        return this.secondClosest;
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public Vector3D getVelocity() {
        return this.scVel;
    }

    @Override
    public double speedScaling() {
        return FastMath.max((double)0.001, (double)this.scVel.len());
    }
}

