/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import com.badlogic.gdx.math.Matrix4;
import gaiasky.scene.record.ITransform;
import gaiasky.scene.record.MatrixTransform;
import gaiasky.scene.record.QuaternionTransform;
import gaiasky.scene.record.RotateTransform;
import gaiasky.scene.record.ScaleTransform;
import gaiasky.scene.record.TranslateTransform;
import gaiasky.util.Constants;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import java.util.Vector;

public class AffineTransformations
implements Component {
    public Vector<ITransform> transformations;

    public synchronized void setTransformations(Object[] transformations) {
        this.initialize();
        for (Object transformation : transformations) {
            this.transformations.add((ITransform)transformation);
        }
    }

    public synchronized void setTransformations(Vector<ITransform> transformations) {
        this.transformations = new Vector<ITransform>(transformations);
    }

    public synchronized void initialize() {
        if (this.transformations == null) {
            this.transformations = new Vector(3, 2);
        }
    }

    public synchronized void clear() {
        if (this.transformations != null) {
            this.transformations.clear();
        }
    }

    public boolean isEmpty() {
        return this.transformations == null || this.transformations.isEmpty();
    }

    public void replace(ITransform newTransform, int index) {
        if (this.transformations != null && !this.transformations.isEmpty() && index >= 0 && index < this.transformations.size()) {
            this.transformations.set(index, newTransform);
        }
    }

    public synchronized void setMatrix(double[] matrix) {
        this.initialize();
        MatrixTransform mt = new MatrixTransform(matrix);
        this.transformations.add(mt);
    }

    public synchronized void setTransformMatrix(double[] matrix) {
        this.setMatrix(matrix);
    }

    public synchronized void setTranslate(double[] translation) {
        this.initialize();
        TranslateTransform tt = new TranslateTransform();
        tt.setVector(translation);
        this.transformations.add(tt);
    }

    public synchronized void setTranslatePc(double[] translation) {
        double[] iu = new double[]{translation[0] * Constants.PC_TO_U, translation[1] * Constants.PC_TO_U, translation[2] * Constants.PC_TO_U};
        this.setTranslate(iu);
    }

    public synchronized void setTranslateKm(double[] translation) {
        double[] iu = new double[]{translation[0] * Constants.KM_TO_U, translation[1] * Constants.KM_TO_U, translation[2] * Constants.KM_TO_U};
        this.setTranslate(iu);
    }

    public synchronized void setQuaternion(double[] axis, double angle) {
        this.initialize();
        QuaternionTransform qt = new QuaternionTransform();
        qt.setQuaternion(new Vector3D(axis), angle);
        this.transformations.add(qt);
    }

    public synchronized void setQuaternion(QuaternionDouble q) {
        this.initialize();
        QuaternionTransform qt = new QuaternionTransform();
        qt.setQuaternion(q);
        this.transformations.add(qt);
    }

    public synchronized void setRotate(double[] axisDegrees) {
        this.initialize();
        RotateTransform rt = new RotateTransform();
        rt.setAxis(new double[]{axisDegrees[0], axisDegrees[1], axisDegrees[2]});
        rt.setAngle(axisDegrees[3]);
        this.transformations.add(rt);
    }

    public synchronized void setScale(double[] sc) {
        this.initialize();
        ScaleTransform st = new ScaleTransform();
        st.setScale(sc);
        this.transformations.add(st);
    }

    public synchronized void setScale(Double sc) {
        this.initialize();
        ScaleTransform st = new ScaleTransform();
        st.setScale(new double[]{sc, sc, sc});
        this.transformations.add(st);
    }

    public synchronized Matrix4 apply(Matrix4 mat) {
        if (this.transformations != null) {
            for (ITransform tr : this.transformations) {
                tr.apply(mat);
            }
        }
        return mat;
    }

    public synchronized Matrix4D apply(Matrix4D mat) {
        if (this.transformations != null) {
            for (ITransform tr : this.transformations) {
                tr.apply(mat);
            }
        }
        return mat;
    }

    public synchronized ScaleTransform getScaleTransform() {
        if (this.transformations != null) {
            for (ITransform t : this.transformations) {
                if (!(t instanceof ScaleTransform)) continue;
                return (ScaleTransform)t;
            }
        }
        return null;
    }

    public synchronized RotateTransform getRotateTransform() {
        if (this.transformations != null) {
            for (ITransform t : this.transformations) {
                if (!(t instanceof RotateTransform)) continue;
                return (RotateTransform)t;
            }
        }
        return null;
    }

    public synchronized TranslateTransform getTranslateTransform() {
        if (this.transformations != null) {
            for (ITransform t : this.transformations) {
                if (!(t instanceof TranslateTransform)) continue;
                return (TranslateTransform)t;
            }
        }
        return null;
    }

    public synchronized AffineTransformations deepCopy() {
        AffineTransformations copy = new AffineTransformations();
        if (this.transformations != null) {
            copy.transformations = new Vector(this.transformations.size(), 2);
            for (ITransform trf : this.transformations) {
                copy.transformations.add(trf.copy());
            }
        }
        return copy;
    }
}

