/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import gaiasky.data.api.OrientationServer;
import gaiasky.data.util.OrientationServerLoader;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import java.time.Instant;

public class AttitudeComponent {
    public String provider;
    public String orientationSource;
    public OrientationServer orientationServer;
    public Vector3D nonRotatedPos;

    public void setOrientationProvider(String provider) {
        this.provider = provider;
    }

    public void setProvider(String provider) {
        this.setOrientationProvider(provider);
    }

    public AttitudeComponent copy() {
        AttitudeComponent copy = new AttitudeComponent();
        copy.provider = this.provider;
        copy.orientationSource = this.orientationSource;
        copy.orientationServer = this.orientationServer;
        copy.nonRotatedPos = new Vector3D(this.nonRotatedPos);
        return copy;
    }

    public void initialize(AssetManager manager) {
        this.nonRotatedPos = new Vector3D();
        if (this.orientationSource != null && !this.orientationSource.isBlank()) {
            manager.load(this.orientationSource, OrientationServer.class, (AssetLoaderParameters)new OrientationServerLoader.OrientationServerParameters(this.provider));
        }
    }

    public void setUp(AssetManager manager) {
        if (this.isReady(manager)) {
            this.orientationServer = (OrientationServer)manager.get(this.orientationSource);
        }
    }

    public void updateOrientation(Instant instant) {
        if (this.orientationServer != null) {
            this.orientationServer.updateOrientation(instant);
        }
    }

    public QuaternionDouble getCurrentQuaternion() {
        if (this.orientationServer != null) {
            return this.orientationServer.getCurrentOrientation();
        }
        return null;
    }

    public boolean isReady(AssetManager manager) {
        return this.orientationSource != null && manager.isLoaded(this.orientationSource);
    }
}

