/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.GaiaSky;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Archetype;
import gaiasky.scene.component.ICopy;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.MathUtilsDouble;
import java.util.Locale;

public class Base
implements Component,
ICopy {
    public Archetype archetype;
    public long id = -1L;
    public String[] names;
    public int localizedNameIndex = 0;
    public long lastStateChangeTimeMs = 0L;
    public float opacity = 1.0f;
    public ComponentTypes ct;
    public boolean computed = true;
    public boolean visible = true;
    public boolean copy = false;
    public boolean initialUpdate = false;
    public ObjectMap<String, Object> attributes;

    public String getName() {
        return this.names != null ? this.names[0] : null;
    }

    public void setName(String name) {
        if (this.names != null) {
            this.names[0] = name;
        } else {
            this.names = new String[]{name};
        }
        this.updateLocalizedName();
    }

    public void setNames(String[] names) {
        this.names = names;
        this.updateLocalizedName();
    }

    public void setName(String name, int index) {
        if (this.names != null && index >= 0 && index < this.names.length) {
            this.names[index] = name;
        }
    }

    public boolean hasName(String candidate) {
        return this.hasName(candidate, false);
    }

    public boolean hasName(String candidate, boolean matchCase) {
        if (this.names == null) {
            return false;
        }
        for (String name : this.names) {
            if (!(matchCase ? name.equals(candidate) : name.equalsIgnoreCase(candidate))) continue;
            return true;
        }
        return false;
    }

    public int addName(String name) {
        if (!this.hasName(name)) {
            if (this.names != null) {
                String[] newNames = new String[this.names.length + 1];
                System.arraycopy(this.names, 0, newNames, 0, this.names.length);
                newNames[this.names.length] = name;
                int idx = this.names.length;
                this.names = newNames;
                return idx;
            }
            this.names = new String[]{name};
            return 0;
        }
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public String getLocalizedName() {
        if (this.localizedNameIndex >= 0 && this.names.length > this.localizedNameIndex) {
            return this.names[this.localizedNameIndex];
        }
        return this.getName();
    }

    public void updateLocalizedName() {
        String localizedName;
        String base;
        if (this.names != null && this.names.length > 0 && I18n.hasObject(base = this.names[0].toLowerCase(Locale.ROOT).replace(' ', '_')) && !(localizedName = I18n.obj(base)).equalsIgnoreCase(this.names[this.localizedNameIndex])) {
            if (this.localizedNameIndex == 0) {
                this.localizedNameIndex = this.addName(localizedName);
            } else {
                this.setName(localizedName, this.localizedNameIndex);
            }
        }
    }

    public void setAltname(String altname) {
        this.setAltName(altname);
    }

    public void setAltName(String altname) {
        this.addName(altname);
    }

    public boolean hasCt(ComponentTypes.ComponentType ct) {
        return ct != null && this.ct.isEnabled(ct);
    }

    public void setComponentType(String ct) {
        this.setCt(ct);
    }

    public void setCt(String ct) {
        this.ct = new ComponentTypes();
        if (!ct.isEmpty()) {
            this.ct.set(ComponentTypes.ComponentType.valueOf(ct).ordinal());
        }
    }

    public void setComponentTypes(String[] cts) {
        this.setCt(cts);
    }

    public void setComponentType(String[] cts) {
        this.setCt(cts);
    }

    public void setCt(String[] cts) {
        this.ct = new ComponentTypes();
        for (String s : cts) {
            if (s.isEmpty()) continue;
            this.ct.set(ComponentTypes.ComponentType.valueOf(s).ordinal());
        }
    }

    public void setComponentType(ComponentTypes.ComponentType ct) {
        this.ct = new ComponentTypes(ct);
    }

    public boolean isVisible() {
        return this.visible || this.msSinceStateChange() <= Settings.settings.scene.fadeMs;
    }

    public long msSinceStateChange() {
        return (long)(GaiaSky.instance.getT() * 1000.0) - this.lastStateChangeTimeMs;
    }

    public float getVisibilityOpacityFactor() {
        long msSinceStateChange = this.msSinceStateChange();
        if (msSinceStateChange > Settings.settings.scene.fadeMs) {
            return this.visible ? 1.0f : 0.0f;
        }
        float opacity = MathUtilsDouble.lint(msSinceStateChange, 0L, Settings.settings.scene.fadeMs, 0.0f, 1.0f);
        if (!this.visible) {
            opacity = 1.0f - opacity;
        }
        return opacity;
    }

    public void addExtraAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new ObjectMap();
        }
        this.attributes.put((Object)name, value);
    }

    public ObjectMap<String, Object> getExtraAttributes() {
        return this.attributes;
    }

    public boolean hasExtraAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    @Override
    public Component getCopy(Engine engine) {
        Base copy = (Base)engine.createComponent(this.getClass());
        copy.copy = true;
        copy.names = this.names;
        copy.archetype = this.archetype;
        copy.visible = this.visible;
        copy.ct = this.ct;
        copy.id = this.id;
        copy.lastStateChangeTimeMs = this.lastStateChangeTimeMs;
        copy.localizedNameIndex = this.localizedNameIndex;
        copy.opacity = this.opacity;
        return copy;
    }
}

