/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import gaiasky.scene.component.ICopy;
import gaiasky.util.Constants;
import gaiasky.util.GlobalResources;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3Q;

public class Body
implements Component,
ICopy {
    public Vector3Q pos = new Vector3Q();
    public Vector3Q posEpoch = new Vector3Q();
    public Vector2D posSph = new Vector2D();
    public float size;
    public boolean sizeInUnitsFlag = false;
    public boolean sizeIsRadiusFlag = true;
    public double distToCamera;
    public double solidAngle;
    public double solidAngleApparent;
    public float[] color;
    public float[] labelColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    public boolean cameraCollision = true;
    public boolean positionSetInScript = false;

    public void setPos(Vector3Q pos) {
        this.pos.set(pos);
        this.updatePosEpoch();
    }

    public void setPos(double[] pos) {
        this.setPosition(pos);
    }

    public void setPosition(double[] pos) {
        this.pos.set(pos[0] * Constants.DISTANCE_SCALE_FACTOR, pos[1] * Constants.DISTANCE_SCALE_FACTOR, pos[2] * Constants.DISTANCE_SCALE_FACTOR);
        this.updatePosEpoch();
    }

    public void setPosKm(double[] pos) {
        this.setPositionKm(pos);
    }

    public void setPositionKm(double[] pos) {
        this.pos.set(pos[0] * Constants.KM_TO_U, pos[1] * Constants.KM_TO_U, pos[2] * Constants.KM_TO_U);
        this.updatePosEpoch();
    }

    public void setPosPc(double[] pos) {
        this.setPositionPc(pos);
    }

    public void setPositionPc(double[] pos) {
        this.pos.set(pos[0] * Constants.PC_TO_U, pos[1] * Constants.PC_TO_U, pos[2] * Constants.PC_TO_U);
        this.updatePosEpoch();
    }

    public void setPosition(int[] pos) {
        this.setPosition(new double[]{(double)pos[0] * Constants.DISTANCE_SCALE_FACTOR, (double)pos[1] * Constants.DISTANCE_SCALE_FACTOR, (double)pos[2] * Constants.DISTANCE_SCALE_FACTOR});
    }

    public void updatePosEpoch() {
        this.posEpoch.set(this.pos);
    }

    public void setSize(Double size) {
        this.size = size.floatValue();
    }

    public void setSizeKm(Double sizeKm) {
        this.size = (float)(sizeKm * Constants.KM_TO_U);
        this.sizeInUnitsFlag = true;
    }

    public void setSizepc(Double sizePc) {
        this.setSizePc(sizePc);
    }

    public void setSizePc(Double sizePc) {
        this.size = (float)(sizePc * Constants.PC_TO_U);
        this.sizeInUnitsFlag = true;
    }

    public void setSizeM(Double sizeM) {
        this.size = (float)(sizeM * Constants.M_TO_U);
        this.sizeInUnitsFlag = true;
    }

    public void setSizeAU(Double sizeAU) {
        this.size = (float)(sizeAU * Constants.AU_TO_U);
        this.sizeInUnitsFlag = true;
    }

    public void setRadius(Double radius) {
        this.setSize(radius * 2.0);
        this.sizeIsRadiusFlag = false;
    }

    public void setRadiusKm(Double radiusKm) {
        this.setSizeKm(radiusKm * 2.0);
        this.sizeIsRadiusFlag = false;
    }

    public void setRadiusPc(Double radiusPc) {
        this.setSizePc(radiusPc * 2.0);
        this.sizeIsRadiusFlag = false;
    }

    public void setDiameter(Double diameter) {
        this.setSize(diameter);
        this.sizeIsRadiusFlag = false;
    }

    public void setDiameterKm(Double diameterKm) {
        this.setDiameter(diameterKm * Constants.KM_TO_U);
    }

    public void setDiameterPc(Double diameterPc) {
        this.setDiameter(diameterPc * Constants.PC_TO_U);
    }

    public void setColor(double[] color) {
        this.color = GlobalResources.toFloatArray(color);
    }

    public void setColor(float[] color) {
        this.color = color;
    }

    public void setLabelColor(double[] color) {
        this.labelColor = GlobalResources.toFloatArray(color);
    }

    @Deprecated
    public void setLabelcolor(double[] color) {
        this.setLabelColor(color);
    }

    public void setLabelColor(float[] color) {
        this.labelColor = color;
    }

    @Deprecated
    public void setLabelcolor(float[] color) {
        this.setLabelColor(color);
    }

    @Override
    public Component getCopy(Engine engine) {
        Body copy = (Body)engine.createComponent(this.getClass());
        copy.solidAngle = this.solidAngle;
        copy.solidAngleApparent = this.solidAngleApparent;
        copy.size = this.size;
        copy.distToCamera = this.distToCamera;
        copy.pos.set(this.pos);
        copy.posEpoch.set(this.posEpoch);
        return copy;
    }
}

