/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import gaiasky.util.Constants;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Vector3D;
import java.util.ArrayList;
import java.util.List;
import net.jafama.FastMath;

public class Boundaries
implements Component {
    public List<List<Vector3D>> boundaries;

    public void setBoundaries(List<List<Vector3D>> boundaries) {
        this.boundaries = boundaries;
    }

    public void setBoundaries(double[][][] ids) {
        this.boundaries = new ArrayList<List<Vector3D>>(ids.length);
        for (double[][] dd : ids) {
            ArrayList<Vector3D> ii = new ArrayList<Vector3D>(dd.length);
            for (double[] v : dd) {
                Vector3D vec = new Vector3D(v);
                ii.add(vec);
            }
            this.boundaries.add(ii);
        }
    }

    public void setBoundariesEquatorial(double[][][] ids) {
        this.boundaries = new ArrayList<List<Vector3D>>(ids.length);
        for (double[][] dd : ids) {
            ArrayList<Vector3D> ii = new ArrayList<Vector3D>(dd.length);
            for (double[] v : dd) {
                double raRadians = FastMath.toRadians((double)v[0]);
                double decRadians = FastMath.toRadians((double)v[1]);
                Vector3D vec = Coordinates.sphericalToCartesian(raRadians, decRadians, 10.0 * Constants.AU_TO_U, new Vector3D());
                ii.add(vec);
            }
            this.boundaries.add(ii);
        }
    }
}

