/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import gaiasky.util.CatalogInfo;
import gaiasky.util.parse.Parser;
import java.util.Map;

public class DatasetDescription
implements Component {
    public CatalogInfo catalogInfo = null;
    public String description;
    public float previousAlpha = 1.0f;
    public boolean addDataset = true;

    public void setCatalogInfoBare(CatalogInfo info) {
        this.catalogInfo = info;
    }

    public void setCatalogInfo(CatalogInfo info) {
        this.catalogInfo = info;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCatalogInfo(Map<String, Object> map) {
        String name = (String)map.get("name");
        String desc = (String)map.get("description");
        String source = (String)map.get("source");
        CatalogInfo.CatalogInfoSource type = map.containsKey("type") ? CatalogInfo.CatalogInfoSource.valueOf((String)map.get("type")) : CatalogInfo.CatalogInfoSource.INTERNAL;
        float size = this.getFloat(map, "size", 1.0f);
        long sizeBytes = this.getLong(map, "sizebytes", -1L);
        long nParticles = this.getLong(map, "nParticles", -1L);
        if (nParticles <= 0L) {
            nParticles = this.getLong(map, "nobjects", -1L);
        }
        this.catalogInfo = new CatalogInfo(name, desc, source, type, size);
        this.catalogInfo.sizeBytes = sizeBytes;
        this.catalogInfo.nParticles = nParticles;
    }

    public void setCataloginfo(Map<String, Object> map) {
        this.setCatalogInfo(map);
    }

    public void setDatasetInfo(Map<String, Object> map) {
        this.setCatalogInfo(map);
    }

    public float getFloat(Map<String, Object> map, String key, float defaultValue) {
        if (map.containsKey(key)) {
            Object value = map.get(key);
            if (value instanceof Float || value instanceof Double) {
                return ((Float)value).floatValue();
            }
            if (value instanceof String) {
                return Parser.parseFloat((String)value);
            }
        }
        return defaultValue;
    }

    public long getLong(Map<String, Object> map, String key, long defaultValue) {
        if (map.containsKey(key)) {
            Object value = map.get(key);
            if (value instanceof Long || value instanceof Integer) {
                return (Long)value;
            }
            if (value instanceof String) {
                return Parser.parseLong((String)value);
            }
        }
        return defaultValue;
    }

    public void setAddToDatasetManager(Boolean b) {
        this.addDataset = b;
    }
}

