/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.ICopy;
import gaiasky.scene.system.update.GraphUpdater;
import gaiasky.util.Consumers;
import gaiasky.util.Functions;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3Q;

public class GraphNode
implements Component,
ICopy {
    public Consumers.Consumer4<GraphUpdater, Entity, Body, GraphNode> positionUpdaterConsumer = GraphUpdater::updatePositionDefault;
    public Functions.Function3<GraphUpdater, Entity, GraphNode, Boolean> mustUpdateFunction;
    public String parentName = null;
    public Entity parent;
    public Array<Entity> children;
    public Vector3Q translation;
    public Matrix4 localTransform;
    public Matrix4D orientation;
    public int numChildren;

    public void setParent(String parentName) {
        this.parentName = parentName;
    }

    public int getSceneGraphDepth() {
        if (this.parent == null) {
            return 0;
        }
        return ((GraphNode)Mapper.graph.get(this.parent)).getSceneGraphDepth() + 1;
    }

    public void initChildren(int size) {
        this.children = new Array(false, size);
    }

    public final void addChild(Entity me, Entity child, boolean updateAncestorCount, int numChildren) {
        if (this.children == null) {
            this.initChildren(numChildren);
        }
        this.children.add((Object)child);
        GraphNode childGraph = (GraphNode)Mapper.graph.get(child);
        if (childGraph.parent != null) {
            ((GraphNode)Mapper.graph.get(childGraph.parent)).removeChild(child, true);
        }
        childGraph.parent = me;
        ++this.numChildren;
        if (updateAncestorCount) {
            Entity ancestor = this.parent;
            while (ancestor != null) {
                GraphNode ancestorGraph = (GraphNode)Mapper.graph.get(ancestor);
                ++ancestorGraph.numChildren;
                ancestor = ancestorGraph.parent;
            }
        }
    }

    public final void removeChild(Entity child, boolean updateAncestorCount) {
        if (this.children.contains((Object)child, true)) {
            this.children.removeValue((Object)child, true);
            GraphNode childGraph = (GraphNode)Mapper.graph.get(child);
            childGraph.parent = null;
            --this.numChildren;
            if (updateAncestorCount) {
                Entity ancestor = this.parent;
                while (ancestor != null) {
                    GraphNode ancestorGraph = (GraphNode)Mapper.graph.get(ancestor);
                    --ancestorGraph.numChildren;
                    ancestor = ancestorGraph.parent;
                }
            }
        }
    }

    public Entity getRoot(Entity me) {
        if (this.parent == null) {
            return me;
        }
        GraphNode parentGraph = (GraphNode)Mapper.graph.get(this.parent);
        if (parentGraph == null) {
            return this.parent;
        }
        return parentGraph.getRoot(this.parent);
    }

    @Override
    public Component getCopy(Engine engine) {
        GraphNode copy = (GraphNode)engine.createComponent(this.getClass());
        copy.parent = null;
        copy.parentName = this.parentName;
        copy.translation = new Vector3Q(this.translation);
        if (copy.children != null) {
            copy.children.clear();
        }
        if (this.localTransform != null) {
            if (copy.localTransform == null) {
                copy.localTransform = new Matrix4();
            }
            copy.localTransform.set(this.localTransform);
        }
        if (this.orientation != null) {
            if (copy.orientation == null) {
                copy.orientation = new Matrix4D();
            }
            copy.orientation.set(this.orientation);
        }
        return copy;
    }

    public Entity getChildByName(String name) {
        int size = this.children.size;
        for (int i = 0; i < size; ++i) {
            Base base;
            Entity child = (Entity)this.children.get(i);
            if (child == null || !(base = (Base)Mapper.base.get(child)).getName().equalsIgnoreCase(name)) continue;
            return child;
        }
        return null;
    }
}

