/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import gaiasky.render.RenderingContext;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.system.render.draw.TextRenderer;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.LabelView;
import gaiasky.util.Constants;
import gaiasky.util.Consumers;
import gaiasky.util.gdx.g2d.ExtSpriteBatch;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.math.Vector3Q;
import java.util.function.Consumer;
import java.util.function.Function;

public class Label
implements Component {
    public boolean forceLabel = false;
    public boolean renderLabel = true;
    public float labelFactor = 0.0f;
    public float labelMax;
    public float textScale = -1.0f;
    public float solidAnglePow = 1.0f;
    public float labelBias = 1.0f;
    public Vector3Q labelPosition;
    public boolean label;
    public Function<LabelView, Boolean> renderFunction;
    public Consumer<LabelView> depthBufferConsumer = LabelView::defaultTextDepthBuffer;
    public Consumers.Consumer7<LabelEntityRenderSystem, LabelView, ExtSpriteBatch, ExtShaderProgram, TextRenderer, RenderingContext, ICamera> renderConsumer;

    public void setForceLabel(Boolean force) {
        this.forceLabel = force;
    }

    public void setRenderLabel(Boolean render) {
        this.renderLabel = render;
    }

    public void setLabelPositionPc(double[] labelPositionPc) {
        if (labelPositionPc != null) {
            this.labelPosition = new Vector3Q(labelPositionPc[0] * Constants.PC_TO_U, labelPositionPc[1] * Constants.PC_TO_U, labelPositionPc[2] * Constants.PC_TO_U);
        }
    }

    public void setLabelPositionKm(double[] labelPositionKm) {
        if (this.labelPosition != null) {
            this.labelPosition = new Vector3Q(labelPositionKm[0] * Constants.KM_TO_U, labelPositionKm[1] * Constants.KM_TO_U, labelPositionKm[2] * Constants.KM_TO_U);
        }
    }

    public void setLabelposition(double[] labelPosition) {
        this.setLabelPosition(labelPosition);
    }

    public void setLabelPosition(double[] labelPositionPc) {
        this.setLabelPositionPc(labelPositionPc);
    }

    public void setLabelFactor(Double labelFactor) {
        this.labelFactor = labelFactor.floatValue();
    }

    public void setLabelMax(Double labelMax) {
        this.labelMax = labelMax.floatValue();
    }

    public void setLabelBias(Double labelBias) {
        this.labelBias = labelBias.floatValue();
    }

    public void setTextScale(Double textScale) {
        this.textScale = textScale.floatValue();
    }

    public void setLabel2d(Boolean b) {
    }
}

