/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import gaiasky.scene.api.ISpacecraft;
import gaiasky.scene.component.ICopy;
import gaiasky.scene.record.MachineDefinition;
import gaiasky.util.Constants;
import gaiasky.util.Pair;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3D;
import java.util.stream.Stream;
import net.jafama.FastMath;

public class MotorEngine
implements Component,
ISpacecraft,
ICopy {
    public static final double[] thrustFactor = new double[14];
    public static final double thrustBase = 1.0E12;
    private static final double relativisticSpeedCap = Constants.C_US * 0.99999;
    public String machineName;
    public double fullPowerTime;
    public Vector3D force;
    public Vector3D accel;
    public Vector3D vel;
    public Vector3D direction;
    public Vector3D up;
    public Pair<Vector3D, Vector3D> dirup;
    public Vector3 posf;
    public Vector3 directionf;
    public Vector3 upf;
    public double currentEnginePower;
    public Vector3D thrust;
    public double thrustMagnitude;
    public double mass;
    public double responsiveness;
    public double drag;
    public Matrix4 rotationMatrix;
    public int thrustFactorIndex = 0;
    public double yawp;
    public double pitchp;
    public double rollp;
    public double yawf;
    public double pitchf;
    public double rollf;
    public double yawa;
    public double pitcha;
    public double rolla;
    public double yawv;
    public double pitchv;
    public double rollv;
    public double yaw;
    public double pitch;
    public double roll;
    public boolean leveling;
    public boolean stopping;
    public Quaternion qf;
    public int currentMachine = 0;
    public MachineDefinition[] machines;
    public boolean render;

    public void setMachines(Object[] machines) {
        this.machines = (MachineDefinition[])Stream.of(machines).toArray(MachineDefinition[]::new);
    }

    public void setCurrentEnginePower(double currentEnginePower) {
        this.currentEnginePower = MathUtilsDouble.clamp(currentEnginePower, -1.0, 1.0);
    }

    public void setYawPower(double yawp) {
        this.yawp = MathUtilsDouble.clamp(yawp, -1.0, 1.0);
    }

    public void setPitchPower(double pitchp) {
        this.pitchp = MathUtilsDouble.clamp(pitchp, -1.0, 1.0);
    }

    public void setRollPower(double rollp) {
        this.rollp = MathUtilsDouble.clamp(rollp, -1.0, 1.0);
    }

    @Override
    public void stopAllMovement() {
        this.setCurrentEnginePower(0.0);
        this.setYawPower(0.0);
        this.setPitchPower(0.0);
        this.setRollPower(0.0);
        this.leveling = false;
        this.stopping = false;
    }

    @Override
    public Vector3D force() {
        return this.force;
    }

    @Override
    public Vector3D accel() {
        return this.accel;
    }

    @Override
    public Vector3D vel() {
        return this.vel;
    }

    @Override
    public Vector3D direction() {
        return this.direction;
    }

    @Override
    public Vector3D up() {
        return this.up;
    }

    @Override
    public Vector3D thrust() {
        return this.thrust;
    }

    @Override
    public double currentEnginePower() {
        return this.currentEnginePower;
    }

    @Override
    public void currentEnginePower(double power) {
        this.setCurrentEnginePower(power);
    }

    @Override
    public double thrustMagnitude() {
        return this.thrustMagnitude;
    }

    @Override
    public double[] thrustFactor() {
        return thrustFactor;
    }

    @Override
    public double relativisticSpeedCap() {
        return relativisticSpeedCap;
    }

    @Override
    public double drag() {
        return this.drag;
    }

    @Override
    public double mass() {
        return this.mass;
    }

    @Override
    public int thrustFactorIndex() {
        return this.thrustFactorIndex;
    }

    @Override
    public boolean leveling() {
        return this.leveling;
    }

    @Override
    public boolean stopping() {
        return this.stopping;
    }

    @Override
    public Component getCopy(Engine engine) {
        MotorEngine copy = (MotorEngine)engine.createComponent(this.getClass());
        copy.force = new Vector3D(this.force);
        copy.accel = new Vector3D(this.accel);
        copy.vel = new Vector3D(this.vel);
        copy.fullPowerTime = this.fullPowerTime;
        copy.posf = new Vector3(this.posf);
        copy.direction = new Vector3D(this.direction);
        copy.directionf = new Vector3(this.directionf);
        copy.up = new Vector3D(this.up);
        copy.upf = new Vector3(this.upf);
        copy.thrust = new Vector3D(this.thrust);
        copy.mass = this.mass;
        copy.rotationMatrix = new Matrix4(this.rotationMatrix);
        copy.thrustFactorIndex = this.thrustFactorIndex;
        copy.currentEnginePower = this.currentEnginePower;
        copy.yawp = this.yawp;
        copy.yawf = this.yawf;
        copy.yawa = this.yawa;
        copy.yawv = this.yawv;
        copy.pitchp = this.pitchp;
        copy.pitchf = this.pitchf;
        copy.pitcha = this.pitcha;
        copy.pitchv = this.pitchv;
        copy.rollp = this.rollp;
        copy.rollf = this.rollf;
        copy.rolla = this.rolla;
        copy.rollv = this.rollv;
        copy.leveling = this.leveling;
        copy.stopping = this.stopping;
        return copy;
    }

    static {
        double val = 0.01;
        for (int i = 0; i < 14; ++i) {
            MotorEngine.thrustFactor[i] = val * FastMath.pow((double)10.0, (double)i);
        }
    }
}

