/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.gdx.assets.AssetManager;
import gaiasky.scene.component.AttitudeComponent;
import gaiasky.scene.component.ICopy;
import gaiasky.scene.record.RotationComponent;
import gaiasky.util.math.Vector3D;

public class Orientation
implements Component,
ICopy {
    public RotationComponent rotationComponent;
    public AttitudeComponent attitudeComponent;

    public void setRotation(RotationComponent rigidRotation) {
        this.rotationComponent = rigidRotation;
    }

    public void setRigidRotation(RotationComponent rotationComponent) {
        this.setRotation(rotationComponent);
    }

    public void updateRotation(RotationComponent rigidRotation) {
        if (this.rotationComponent != null) {
            this.rotationComponent.updateWith(rigidRotation);
        } else {
            this.rotationComponent = rigidRotation;
        }
    }

    public void updateRigidRotation(RotationComponent rigidRotation) {
        this.updateRotation(rigidRotation);
    }

    public void setOrientationProvider(String provider) {
        if (this.attitudeComponent == null) {
            this.attitudeComponent = new AttitudeComponent();
        }
        this.attitudeComponent.setProvider(provider);
    }

    public void setProvider(String provider) {
        this.setOrientationProvider(provider);
    }

    public void setAttitudeProvider(String provider) {
        this.setOrientationProvider(provider);
    }

    public void setOrientationSource(String source) {
        if (this.attitudeComponent == null) {
            this.attitudeComponent = new AttitudeComponent();
        }
        this.attitudeComponent.orientationSource = source;
    }

    public void setAttitudeLocation(String source) {
        this.setOrientationSource(source);
    }

    @Override
    public Component getCopy(Engine engine) {
        Orientation copy = (Orientation)engine.createComponent(Orientation.class);
        copy.rotationComponent = this.rotationComponent;
        if (this.attitudeComponent != null) {
            copy.attitudeComponent = this.attitudeComponent.copy();
        }
        return copy;
    }

    public void initialize(AssetManager manager) {
        if (this.attitudeComponent != null) {
            this.attitudeComponent.initialize(manager);
        }
    }

    public void setUp(AssetManager manager) {
        if (this.attitudeComponent != null) {
            this.attitudeComponent.setUp(manager);
        }
    }

    public Vector3D getNonRotatedPos() {
        if (this.attitudeComponent != null) {
            return this.attitudeComponent.nonRotatedPos;
        }
        return null;
    }
}

