/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.TextureArray;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.IntSet;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.component.IDisposable;
import gaiasky.scene.component.Render;
import gaiasky.scene.task.ParticleSetUpdaterTask;
import gaiasky.scene.view.FilterView;
import gaiasky.util.Constants;
import gaiasky.util.FastObjectIntMap;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.camera.Proximity;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.jafama.FastMath;
import uk.ac.starlink.table.ColumnInfo;

public class ParticleSet
implements Component,
IDisposable {
    private static long idSeq = 0L;
    protected final Vector3Q B31 = new Vector3Q();
    protected final Vector3Q B32 = new Vector3Q();
    protected final Vector3D D31 = new Vector3D();
    protected final Vector3D D32 = new Vector3D();
    public List<IParticleRecord> pointData;
    public List<ColumnInfo> columnInfoList;
    public boolean renderParticles = true;
    public boolean isStars;
    public boolean isExtended;
    public boolean renderSetLabel = true;
    public boolean renderParticleLabels = true;
    public int numLabels = -1;
    public String provider;
    public Map<String, Object> providerParams;
    public String datafile;
    public String modelFile;
    public IntModel model;
    public String modelType = "quad";
    public Map<String, Object> modelParams;
    public int modelPrimitive = 4;
    public String proximityDescriptorsLocation;
    public Path proximityDescriptorsPath;
    public double proximityThreshold = 0.064;
    public boolean proximityLoadingFlag = false;
    public IntSet proximityLoaded;
    public IntSet proximityMissing;
    public float profileDecay = 0.2f;
    public float colorNoise = 0.0f;
    public boolean colorFromTexture = false;
    public double fixedAngularSize = -1.0;
    public double[] particleSizeLimitsPoint = new double[]{2.0, 50.0};
    public double[] particleSizeLimits = new double[]{Math.tan(Math.toRadians(0.07)), FastMath.tan((double)Math.toRadians(6.0))};
    public String textureAttribute;
    public String[] textureFiles = null;
    public TextureArray textureArray;
    public ShadingStyle shadingStyle = ShadingStyle.DEFAULT;
    public Vector3D meanPosition;
    public Double factor = null;
    public float[] ccMin = null;
    public float[] ccMax = null;
    public IntSet forceLabel;
    public IntMap<float[]> labelColors;
    public double lastSortTime;
    public boolean generateIndex = false;
    public boolean allowStreaks = true;
    public double meanDistance;
    public double maxDistance;
    public double minDistance;
    public double epochJd;
    public double currDeltaYears = 0.0;
    public IParticleRecord focus;
    public int focusIndex = -1;
    public int candidateFocusIndex = -1;
    public Vector3Q focusPosition;
    public Vector2D focusPositionSph;
    public double focusDistToCamera;
    public double focusSolidAngle;
    public double focusSolidAngleApparent;
    public double focusSize;
    public Proximity proximity;
    public boolean disposed = false;
    public FastObjectIntMap<String> index;
    private final Object indexSync = new Object();
    public double[] metadata;
    public int[] indices;
    public IntSet invisibilityArray;
    public Entity entity;
    public ParticleSetUpdaterTask updaterTask;
    public Vector3Q lastSortCameraPos;
    public Vector3Q cPosD;
    protected final Matrix4D mat = new Matrix4D();

    public static synchronized long getNextSequence() {
        return idSeq++;
    }

    public float[] getColorMin() {
        return this.ccMin;
    }

    public void setColorMin(double[] colorMin) {
        this.ccMin = GlobalResources.toFloatArray(colorMin);
    }

    public void setColorMin(float[] colorMin) {
        this.ccMin = colorMin;
    }

    public float[] getColorMax() {
        return this.ccMax;
    }

    public void setColorMax(double[] colorMax) {
        this.ccMax = GlobalResources.toFloatArray(colorMax);
    }

    public void setColorMax(float[] colorMax) {
        this.ccMax = colorMax;
    }

    public double getMeanDistance() {
        return this.meanDistance;
    }

    public double getMinDistance() {
        return this.minDistance;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public List<IParticleRecord> data() {
        return this.pointData;
    }

    public void setData(List<IParticleRecord> pointData) {
        this.setData(pointData, this.generateIndex);
    }

    public void setData(List<IParticleRecord> pointData, boolean regenerateIndex) {
        this.pointData = pointData;
        if (regenerateIndex) {
            this.regenerateIndex();
        }
        this.invisibilityArray = new IntSet();
    }

    public void setColumnInfoList(List<ColumnInfo> columnInfoList) {
        this.columnInfoList = columnInfoList;
    }

    public void regenerateIndex() {
        this.index = this.generateIndex(this.data());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastObjectIntMap<String> generateIndex(List<IParticleRecord> pointData) {
        FastObjectIntMap<String> index = new FastObjectIntMap<String>((int)((float)pointData.size() * 1.25f), String.class);
        Object object = this.indexSync;
        synchronized (object) {
            int n = pointData.size();
            for (int i = 0; i < n; ++i) {
                IParticleRecord pb = pointData.get(i);
                if (pb.names() == null) continue;
                int idx = i;
                for (String name : pb.names()) {
                    String loc;
                    String nlc = name.toLowerCase(Locale.ROOT);
                    index.put(nlc, idx);
                    if (!I18n.hasLocalizedVersion(nlc) || (loc = I18n.localize(nlc)).equals(nlc)) continue;
                    index.put(I18n.localize(nlc).toLowerCase(Locale.ROOT), idx);
                }
            }
        }
        return index;
    }

    public void setMeanPosition(double[] pos) {
        this.meanPosition = new Vector3D(pos[0], pos[1], pos[2]);
    }

    public void setPosition(double[] pos) {
        this.setMeanPosition(pos);
    }

    public void setPosKm(double[] pos) {
        this.setPositionKm(pos);
    }

    public void setMeanPositionKm(double[] pos) {
        this.meanPosition = new Vector3D(pos[0] * Constants.KM_TO_U, pos[1] * Constants.KM_TO_U, pos[2] * Constants.KM_TO_U);
    }

    public void setPositionKm(double[] pos) {
        this.setMeanPositionKm(pos);
    }

    public void setPosPc(double[] pos) {
        this.setPositionPc(pos);
    }

    public void setMeanPositionPc(double[] pos) {
        this.meanPosition = new Vector3D(pos[0] * Constants.PC_TO_U, pos[1] * Constants.PC_TO_U, pos[2] * Constants.PC_TO_U);
    }

    public void setPositionPc(double[] pos) {
        this.setMeanPositionPc(pos);
    }

    public void setPosition(int[] pos) {
        this.setPosition(new double[]{pos[0], pos[1], pos[2]});
    }

    public void setDataFile(String dataFile) {
        this.datafile = dataFile;
    }

    public void setDatafile(String dataFile) {
        this.setDataFile(dataFile);
    }

    public void setProviderParams(Map<String, Object> params) {
        this.providerParams = params;
    }

    public void setProviderparams(Map<String, Object> params) {
        this.setProviderParams(params);
    }

    public void setFactor(Double factor) {
        this.factor = factor * Constants.DISTANCE_SCALE_FACTOR;
    }

    @Deprecated
    public void setProfiledecay(Double profiledecay) {
        this.setProfileDecay(profiledecay);
    }

    public void setProfileDecay(Double profileDecay) {
        this.profileDecay = profileDecay.floatValue();
    }

    @Deprecated
    public void setColornoise(Double colorNoise) {
        this.setColorNoise(colorNoise);
    }

    public void setColorNoise(Double colorNoise) {
        this.colorNoise = colorNoise.floatValue();
    }

    public void setColorFromTexture(boolean colorFromTexture) {
        this.colorFromTexture = colorFromTexture;
    }

    public void setGenerateIndex(boolean generateIndex) {
        this.generateIndex = generateIndex;
    }

    public void setFixedAngularSize(Double fixedAngularSize) {
        this.setFixedAngularSizeRad(fixedAngularSize);
    }

    public void setFixedAngularSizeRad(Double fixedAngularSizeRad) {
        this.fixedAngularSize = fixedAngularSizeRad;
    }

    public void setFixedAngularSizeDeg(Double fixedAngularSizeDeg) {
        this.setFixedAngularSizeRad(Math.toRadians(fixedAngularSizeDeg));
    }

    public void setParticleSizeLimitsDeg(double[] sizeLimits) {
        sizeLimits[0] = MathUtilsDouble.clamp(sizeLimits[0], 0.0, 90.0);
        sizeLimits[1] = MathUtilsDouble.clamp(sizeLimits[1], 0.0, 90.0);
        if (sizeLimits[0] > sizeLimits[1]) {
            sizeLimits[0] = sizeLimits[1];
        }
        sizeLimits[0] = FastMath.toRadians((double)sizeLimits[0]);
        sizeLimits[1] = FastMath.toRadians((double)sizeLimits[1]);
        this.particleSizeLimits = sizeLimits;
    }

    public void setParticleSizeLimits(double[] sizeLimits) {
        sizeLimits[0] = MathUtilsDouble.clamp(sizeLimits[0], 0.0, 1.57);
        sizeLimits[1] = MathUtilsDouble.clamp(sizeLimits[1], 0.0, 1.57);
        if (sizeLimits[0] > sizeLimits[1]) {
            sizeLimits[0] = sizeLimits[1];
        }
        this.particleSizeLimits = sizeLimits;
    }

    public void setParticlesizelimits(double[] sizeLimits) {
        this.setParticleSizeLimits(sizeLimits);
    }

    public void setTextureAttribute(String textureAttribute) {
        this.textureAttribute = textureAttribute;
    }

    public void setTexture(String texture) {
        this.textureFiles = new String[]{texture};
    }

    public void setTextures(String[] textures) {
        this.textureFiles = textures;
    }

    public void setShadingStyle(String style) {
        try {
            this.shadingStyle = ShadingStyle.valueOf(style.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger(this.getClass().getSimpleName()).error("Error setting shading style: " + style, e);
        }
    }

    public void setRenderParticles(Boolean renderParticles) {
        this.renderParticles = renderParticles;
    }

    public void setRenderSetLabel(Boolean renderSetLabel) {
        this.renderSetLabel = renderSetLabel;
    }

    public void setExtended(Boolean extended) {
        this.isExtended = extended;
    }

    public void setNumLabels(Long numLabels) {
        this.numLabels = FastMath.toIntExact((long)numLabels);
    }

    public void updateNumLabelsValue(int n, Entity e) {
        int newNumLabels = FastMath.min((int)n, (int)this.pointData.size());
        if (newNumLabels != this.numLabels) {
            this.setNumLabels(Long.valueOf(newNumLabels));
            this.indices = new int[newNumLabels];
            this.updaterTask = new ParticleSetUpdaterTask(e, this);
        }
    }

    public IParticleRecord get(int index) {
        return this.pointData.get(index);
    }

    public String getFirstParticleName() {
        if (this.pointData != null) {
            for (IParticleRecord pb : this.pointData) {
                if (pb.names() == null || pb.names().length <= 0) continue;
                return pb.names()[0];
            }
        }
        return null;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public void setModelParams(Map<String, Object> params) {
        this.modelParams = params;
    }

    public void setModelPrimitive(String modelPrimitive) {
        this.modelPrimitive = switch (modelPrimitive) {
            case "GL_TRIANGLE_STRIP", "gl_triangle_strip" -> 5;
            case "GL_LINES", "gl_lines" -> 1;
            case "GL_LINE_LOOP", "gl_line_loop" -> 2;
            case "GL_LINE_STRIP", "gl_line_strip" -> 3;
            default -> 4;
        };
    }

    public void setProximityDescriptorsLocation(String loc) {
        this.proximityDescriptorsLocation = loc;
    }

    public void setProximityDescriptors(String loc) {
        this.setProximityDescriptorsLocation(loc);
    }

    public void setDescriptorsLocation(String loc) {
        this.setProximityDescriptorsLocation(loc);
    }

    public void setProximityThreshold(Double thRadians) {
        this.proximityThreshold = thRadians;
    }

    public void setProximityThresholdRad(Double thRadians) {
        this.setProximityThreshold(thRadians);
    }

    public void setProximityThresholdDeg(Double thDegrees) {
        this.setProximityThreshold(Math.toRadians(thDegrees));
    }

    public double getSize() {
        return this.focusSize;
    }

    public double getSize(int i) {
        return this.pointData.get(i).size();
    }

    public double getFocusSize() {
        return this.isStars || this.isExtended ? (double)this.focus.size() : 100000.0 * Constants.KM_TO_U;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusIndex(String name) {
        Object object = this.indexSync;
        synchronized (object) {
            if (this.index != null) {
                this.candidateFocusIndex = this.index.get(name.toLowerCase(Locale.ROOT).trim());
            }
        }
    }

    public IParticleRecord getCandidateBean() {
        if (this.candidateFocusIndex >= 0) {
            return this.pointData.get(this.candidateFocusIndex);
        }
        return null;
    }

    public double getRadius() {
        return this.isStars ? this.getSize() * 1.31526E-6 : this.getSize();
    }

    public double getRadius(int i) {
        return this.isStars ? this.getSize(i) * 1.31526E-6 : (this.isExtended ? this.getSize(i) : this.getRadius());
    }

    public double getTEff() {
        return this.isStars ? (double)this.focus.tEff() : -1.0;
    }

    public void updateFocus(ICamera camera) {
        IParticleRecord focus = this.pointData.get(this.focusIndex);
        Vector3Q aux = this.fetchPosition(focus, this.cPosD, this.B31, this.currDeltaYears);
        this.focusPosition.set(aux).add(camera.getPos());
        this.focusDistToCamera = aux.lenDouble();
        this.focusSize = this.getFocusSize();
        this.focusSolidAngleApparent = this.focusSolidAngle = (double)((float)(this.getRadius() / this.focusDistToCamera / (double)camera.getFovFactor()));
    }

    public void updateFocusDataPos() {
        if (this.focusIndex < 0) {
            this.focus = null;
        } else {
            this.focus = this.pointData.get(this.focusIndex);
            this.updateFocus(GaiaSky.instance.getICamera());
            Vector3D posSph = Coordinates.cartesianToSpherical(this.focusPosition, this.D31);
            this.focusPositionSph.set((float)(57.29577951308232 * posSph.x), (float)(57.29577951308232 * posSph.y));
        }
    }

    public void setFocusIndex(int index) {
        if (index >= 0 && index < this.pointData.size()) {
            this.candidateFocusIndex = index;
            this.makeFocus();
        }
    }

    public void makeFocus() {
        this.focusIndex = this.candidateFocusIndex;
        this.updateFocusDataPos();
    }

    public boolean isVisible(int index) {
        return !this.invisibilityArray.contains(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean visible, String name, Render render) {
        Object object = this.indexSync;
        synchronized (object) {
            if (this.index != null && this.index.containsKey(name)) {
                this.setVisible(this.index.get(name), visible, render);
            }
        }
    }

    public void setVisible(int index, boolean visible, Render render) {
        boolean changed;
        if (index >= 0 && index < this.pointData.size() && (changed = visible ? this.invisibilityArray.remove(index) : this.invisibilityArray.add(index))) {
            this.markForUpdate(render);
        }
    }

    public void markForUpdate(Render render) {
        if (render != null) {
            GaiaSky.postRunnable(() -> EventManager.publish(Event.GPU_DISPOSE_PARTICLE_GROUP, render, new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector3Q getAbsolutePosition(String name, Instant date, Vector3Q out) {
        name = name.toLowerCase(Locale.ROOT).trim();
        Object object = this.indexSync;
        synchronized (object) {
            int idx;
            if (this.index != null && this.index.containsKey(name) && (idx = this.index.get(name)) >= 0 && idx < this.pointData.size()) {
                IParticleRecord pb = this.pointData.get(idx);
                return this.getAbsolutePosition(pb, date, out);
            }
        }
        return null;
    }

    public Vector3Q getAbsolutePosition(IParticleRecord object, Instant date, Vector3Q out) {
        if (object.hasProperMotion()) {
            double deltaYears = AstroUtils.getMsSince(date == null ? GaiaSky.instance.time.getTime() : date, this.epochJd) * 3.168808781402895E-11;
            Vector3Q aux = this.fetchPosition(object, null, this.B31, deltaYears);
            return out.set(aux);
        }
        return this.getAbsolutePosition(out);
    }

    public Vector3Q getAbsolutePosition(Instant date, Vector3Q out) {
        IParticleRecord focus = this.pointData.get(this.focusIndex);
        return this.getAbsolutePosition(focus, date, out);
    }

    public Vector3Q getAbsolutePosition(Vector3Q out) {
        if (this.entity != null && Mapper.affine.has(this.entity) && this.focusIndex >= 0 && this.focusIndex < this.pointData.size()) {
            IParticleRecord focus = this.pointData.get(this.focusIndex);
            return this.fetchPosition(focus, null, out, this.currDeltaYears);
        }
        return out.set(this.focusPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector3Q getAbsolutePosition(String name, Vector3Q out) {
        name = name.toLowerCase(Locale.ROOT).trim();
        Object object = this.indexSync;
        synchronized (object) {
            if (this.index != null && this.index.containsKey(name)) {
                int idx = this.index.get(name);
                IParticleRecord pb = this.pointData.get(idx);
                this.fetchPosition(pb, null, out, this.currDeltaYears);
                return out;
            }
            return null;
        }
    }

    public Vector3D getAbsolutePosition(String name, Vector3D out) {
        Vector3Q result = this.getAbsolutePosition(name, this.B32);
        if (result != null) {
            out.set(result);
            return out;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector3D fetchPositionDouble(IParticleRecord pb, Vector3Q camPos, Vector3D out, double deltaYears) {
        AffineTransformations affine;
        Vector3D pm = this.D32.set(0.0, 0.0, 0.0);
        if (pb.hasProperMotion()) {
            pm.set(pb.vx(), pb.vy(), pb.vz()).scl(deltaYears);
        }
        Vector3D destination = out.set(pb.x(), pb.y(), pb.z());
        if (this.entity != null && (affine = (AffineTransformations)Mapper.affine.get(this.entity)) != null && !affine.isEmpty()) {
            Matrix4D matrix4D = this.mat;
            synchronized (matrix4D) {
                affine.apply(this.mat.idt());
                destination.mul(this.mat);
            }
        }
        if (camPos != null && !camPos.hasNaN()) {
            destination.sub(camPos).add(pm);
        } else {
            destination.add(pm);
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector3Q fetchPosition(IParticleRecord pb, Vector3Q camPos, Vector3Q out, double deltaYears) {
        AffineTransformations affine;
        Vector3D pm = this.D32;
        if (pb.hasProperMotion()) {
            pm.set(pb.vx(), pb.vy(), pb.vz()).scl(deltaYears);
        } else {
            pm.set(0.0, 0.0, 0.0);
        }
        out.set(pb.x(), pb.y(), pb.z());
        if (this.entity != null && Mapper.affine.has(this.entity) && (affine = (AffineTransformations)Mapper.affine.get(this.entity)) != null && !affine.isEmpty()) {
            Matrix4D matrix4D = this.mat;
            synchronized (matrix4D) {
                affine.apply(this.mat.idt());
                out.mul(this.mat);
            }
        }
        if (camPos != null && !camPos.hasNaN()) {
            out.sub(camPos);
        }
        if (!pm.isZero()) {
            out.add(pm);
        }
        return out;
    }

    public void setEpoch(Double epochJd) {
        this.setEpochJd(epochJd);
    }

    public void setEpochJd(Double epochJd) {
        this.epochJd = epochJd;
    }

    public double getDeltaYears() {
        return this.currDeltaYears;
    }

    public long getId() {
        return 123L;
    }

    public String getName() {
        if (this.focus != null && this.focus.names() != null) {
            return this.focus.names()[0];
        }
        return null;
    }

    public String[] getNames() {
        if (this.focus != null && this.focus.names() != null) {
            return this.focus.names();
        }
        return null;
    }

    public boolean hasName(String candidate) {
        return this.hasName(candidate, false);
    }

    public boolean hasName(String candidate, boolean matchCase) {
        String[] names;
        if (this.focus == null || this.focus.names() == null) {
            return false;
        }
        for (String name : names = this.focus.names()) {
            if (!(matchCase ? name.equals(candidate) : name.equalsIgnoreCase(candidate))) continue;
            return true;
        }
        return false;
    }

    public String getLocalizedName() {
        return I18n.localize(this.getName());
    }

    public long getCandidateId() {
        return this.pointData.get(this.candidateFocusIndex).id();
    }

    public String getCandidateName() {
        return this.pointData.get(this.candidateFocusIndex).names() != null ? this.pointData.get(this.candidateFocusIndex).names()[0] : this.getName();
    }

    public double getCandidateSolidAngleApparent() {
        return this.getSolidAngleApparent(this.candidateFocusIndex);
    }

    public double getSolidAngleApparent(int idx) {
        if (idx >= 0 && idx < this.pointData.size()) {
            IParticleRecord candidate = this.pointData.get(idx);
            Vector3D aux = candidate.pos(this.D31);
            ICamera camera = GaiaSky.instance.getICamera();
            float size = candidate.hasSize() ? candidate.size() : 50.0f;
            return (float)((double)size / aux.sub(camera.getPos()).len() / (double)camera.getFovFactor());
        }
        return -1.0;
    }

    public String getClosestName() {
        return this.proximity.updating[0].name;
    }

    public String getClosestLocalizedName() {
        return I18n.localize(this.getClosestName());
    }

    public boolean canSelect(FilterView view) {
        return this.candidateFocusIndex < 0 || this.candidateFocusIndex >= this.pointData.size() || view.filter(this.candidateFocusIndex);
    }

    public Vector2D getPosSph() {
        return this.focusPositionSph;
    }

    public double getAlpha() {
        return this.focusPositionSph.x;
    }

    public double getDelta() {
        return this.focusPositionSph.y;
    }

    public double getDistToCamera() {
        return this.focusDistToCamera;
    }

    public double getSolidAngle() {
        return this.focusSolidAngle;
    }

    public double getSolidAngleApparent() {
        return this.focusSolidAngleApparent;
    }

    public boolean isWireframe() {
        return this.modelPrimitive >= 1 && this.modelPrimitive <= 3;
    }

    public boolean isBillboard() {
        return this.model == null && this.modelType.equalsIgnoreCase("quad");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForceLabel(Boolean forceLabel, String name) {
        name = name.toLowerCase(Locale.ROOT).trim();
        Object object = this.indexSync;
        synchronized (object) {
            if (this.index != null && this.index.containsKey(name)) {
                int idx = this.index.get(name);
                if (this.forceLabel.contains(idx)) {
                    if (!forceLabel.booleanValue()) {
                        this.forceLabel.remove(idx);
                    }
                } else if (forceLabel.booleanValue()) {
                    this.forceLabel.add(idx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isForceLabel(String name) {
        name = name.toLowerCase(Locale.ROOT).trim();
        Object object = this.indexSync;
        synchronized (object) {
            if (this.index != null && this.index.containsKey(name)) {
                int idx = this.index.get(name);
                return this.forceLabel.contains(idx);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabelColor(float[] color, String name) {
        name = name.toLowerCase(Locale.ROOT).trim();
        Object object = this.indexSync;
        synchronized (object) {
            if (this.index != null && this.index.containsKey(name)) {
                int idx = this.index.get(name);
                this.labelColors.put(idx, (Object)color);
            }
        }
    }

    @Override
    public void dispose(Entity entity) {
        if (this.updaterTask != null) {
            this.updaterTask.dispose();
        }
        this.disposed = true;
        this.markForUpdate((Render)Mapper.render.get(entity));
        this.pointData = null;
    }

    public static enum ShadingStyle {
        DEFAULT,
        TWINKLE;

    }
}

