/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.gdx.math.Vector3;
import gaiasky.scene.component.ICopy;
import gaiasky.util.coord.AstroUtils;

public class ProperMotion
implements Component,
ICopy {
    public double epochJd = AstroUtils.JD_J2015_5;
    public Vector3 pm;
    public Vector3 pmSph;
    public boolean hasPm;

    public void setEpochJd(Double epochJd) {
        this.epochJd = epochJd;
    }

    public void setEpochYear(Double epochYear) {
        this.epochJd = AstroUtils.getJulianDate(epochYear);
    }

    public void initPm() {
        if (this.pmSph == null) {
            this.pmSph = new Vector3();
        }
        if (this.pm == null) {
            this.pm = new Vector3();
        }
    }

    public void setMuAlpha(Double muAlpha) {
        this.setMuAlphaMasYr(muAlpha);
    }

    public void setMuAlphaMasYr(Double muAlpha) {
        this.initPm();
        this.pmSph.x = muAlpha.floatValue();
    }

    public void setMuDelta(Double muDelta) {
        this.setMuDeltaMasYr(muDelta);
    }

    public void setMuDeltaMasYr(Double muDelta) {
        this.initPm();
        this.pmSph.y = muDelta.floatValue();
    }

    public void setVr(Double rv) {
        this.setRadialVelocityKms(rv);
    }

    public void setVrKms(Double rv) {
        this.setRadialVelocityKms(rv);
    }

    public void setRadialVelocity(Double rv) {
        this.setRadialVelocityKms(rv);
    }

    public void setRadialVelocityKms(Double rv) {
        this.initPm();
        this.pmSph.z = rv.floatValue();
    }

    @Override
    public Component getCopy(Engine engine) {
        ProperMotion copy = (ProperMotion)engine.createComponent(this.getClass());
        copy.pm = new Vector3(this.pm);
        copy.pmSph = new Vector3(this.pmSph);
        copy.hasPm = this.hasPm;
        return copy;
    }
}

