/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Method;
import gaiasky.util.Logger;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Matrix4D;

public class RefSysTransform
implements Component {
    private static final Logger.Log logger = Logger.getLogger(RefSysTransform.class);
    public String transformName;
    public Matrix4D matrix;
    public Matrix4 matrixf;
    public boolean floatVersion = false;

    public void setTransformFunction(String transformFunction) {
        this.setTransformName(transformFunction);
    }

    public void setTransformName(String transformFunction) {
        this.setMatrix(transformFunction);
    }

    public void setMatrix(String transformName) {
        this.transformName = transformName;
        if (transformName != null && !transformName.isEmpty()) {
            try {
                Method m = ClassReflection.getMethod(Coordinates.class, (String)transformName, (Class[])new Class[0]);
                Object obj = m.invoke(null, new Object[0]);
                Matrix4D trf = null;
                if (obj instanceof Matrix4) {
                    trf = new Matrix4D(((Matrix4)obj).val);
                } else if (obj instanceof Matrix4D) {
                    trf = new Matrix4D((Matrix4D)obj);
                }
                this.matrix = trf;
                if (this.floatVersion && this.matrix != null) {
                    this.matrixf = this.matrix.putIn(new Matrix4());
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
        } else {
            if (this.matrix != null) {
                this.matrix.idt();
            }
            if (this.matrixf != null) {
                this.matrixf.idt();
            }
        }
    }

    public void setTransformMatrix(double[] matrixValues) {
        this.matrix = new Matrix4D(matrixValues);
        this.matrixf = this.matrix.putIn(new Matrix4());
    }

    public void setTransformMatrix(Matrix4D m) {
        this.matrix = new Matrix4D(m);
        this.matrixf = m.putIn(new Matrix4());
    }

    public void setTransformMatrix(Matrix4 m) {
        this.matrixf = new Matrix4(m);
        this.matrix = new Matrix4D(m.val);
    }

    public void setTransformValues(double[] transformValues) {
        this.setTransformMatrix(transformValues);
    }
}

