/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.Render;
import gaiasky.util.Settings;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;

public class StarSet
extends ParticleSet {
    public double variabilityEpochJd;
    public double modelDist;
    public boolean variableStars = false;
    public int numBillboards = -1;

    @Override
    public void updateFocus(ICamera camera) {
        IParticleRecord focus = (IParticleRecord)this.pointData.get(this.focusIndex);
        Vector3D aux = this.fetchPositionDouble(focus, this.cPosD, this.D31, this.currDeltaYears);
        this.focusPosition.set(aux).add(this.cPosD);
        this.focusDistToCamera = aux.len();
        this.focusSize = this.getFocusSize();
        this.focusSolidAngle = (float)(this.getRadius() / this.focusDistToCamera / (double)camera.getFovFactor());
        this.focusSolidAngleApparent = this.focusSolidAngle * (double)Settings.settings.scene.star.brightness;
    }

    public void setVariabilityEpoch(Double epochJd) {
        this.setVariabilityEpochJd(epochJd);
    }

    public void setVariabilityEpochJd(Double epochJd) {
        this.variabilityEpochJd = epochJd;
    }

    public int getHip() {
        if (this.focus != null && this.focus.hip() > 0) {
            return this.focus.hip();
        }
        return -1;
    }

    @Override
    public long getId() {
        if (this.focus != null) {
            return this.focus.id();
        }
        return -1L;
    }

    @Override
    public double getCandidateSolidAngleApparent() {
        return this.getSolidAngleApparent(this.candidateFocusIndex);
    }

    @Override
    public double getSolidAngleApparent(int index) {
        if (index >= 0) {
            IParticleRecord candidate = (IParticleRecord)this.pointData.get(index);
            Vector3D aux = candidate.pos(this.D31);
            ICamera camera = GaiaSky.instance.getICamera();
            double va = (float)(candidate.radius() / aux.sub(camera.getPos()).len() / (double)camera.getFovFactor());
            return va * (double)Settings.settings.scene.star.brightness;
        }
        return -1.0;
    }

    public double getClosestDistToCamera() {
        return this.proximity.updating[0].distToCamera;
    }

    public double getClosestSize() {
        return this.proximity.updating[0].size;
    }

    public Vector3D getClosestPos(Vector3D out) {
        return out.set(this.proximity.updating[0].pos);
    }

    public Vector3Q getClosestAbsolutePos(Vector3Q out) {
        return out.set(this.proximity.updating[0].absolutePos);
    }

    public float[] getClosestCol() {
        return this.proximity.updating[0].col;
    }

    @Override
    public void markForUpdate(Render render) {
        if (this.variableStars) {
            GaiaSky.postRunnable(() -> EventManager.publish(Event.GPU_DISPOSE_VARIABLE_GROUP, render, new Object[0]));
        } else {
            GaiaSky.postRunnable(() -> EventManager.publish(Event.GPU_DISPOSE_STAR_GROUP, render, new Object[0]));
        }
    }
}

