/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.math.MathUtils;
import gaiasky.data.api.IOrbitDataProvider;
import gaiasky.data.util.OrbitDataLoader;
import gaiasky.scene.record.OrbitComponent;
import gaiasky.util.Constants;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import java.util.Locale;
import net.jafama.FastMath;

public class Trajectory
implements Component {
    public static final Logger.Log logger = Logger.getLogger(Trajectory.class);
    public Entity body;
    public Vector3D curr;
    public double alpha;
    public Matrix4D localTransformD = new Matrix4D();
    public String provider;
    public Double multiplier = 1.0;
    public Class<? extends IOrbitDataProvider> providerClass;
    public IOrbitDataProvider providerInstance;
    public OrbitComponent oc;
    public OrbitBodyRepresentation bodyRepresentation = OrbitBodyRepresentation.BODY_AND_ORBIT;
    public boolean newMethod = false;
    public double coord;
    public OrbitOrientationModel model = OrbitOrientationModel.DEFAULT;
    public boolean isInOrbitalElementsGroup = false;
    public boolean refreshing = false;
    public int numSamples = 100;
    public OrbitSamplingStrategy sampling = OrbitSamplingStrategy.TIME;
    public long orbitStartMs;
    public long orbitEndMs;
    public boolean mustRefresh;
    public boolean closedLoop = true;
    public boolean orbitTrail = true;
    public float trailMap = 0.0f;
    public float trailMinOpacity = 0.0f;
    public OrbitDataLoader.OrbitDataLoaderParameters params;
    public float[] bodyColor;
    public float pointSize = 1.0f;
    public float distUp = 200.0f;
    public float distDown = 20.0f;
    public double refreshRate = -1.0;

    public void setOrientationModel(String model) {
        model = model.toUpperCase().trim();
        try {
            this.model = OrbitOrientationModel.valueOf(model);
        }
        catch (IllegalArgumentException e) {
            logger.error(I18n.msg("notif.error", e.getLocalizedMessage()));
        }
    }

    public void setModel(String model) {
        this.setOrientationModel(model);
    }

    public void setPointSize(Long pointSize) {
        this.pointSize = pointSize.longValue();
    }

    public void setPointsize(Long pointSize) {
        this.setPointSize(pointSize);
    }

    public void setPointSize(Double pointSize) {
        this.pointSize = pointSize.floatValue();
    }

    public void setPointsize(Double pointSize) {
        this.setPointSize(pointSize);
    }

    public void setBodyColor(double[] color) {
        this.bodyColor = GlobalResources.toFloatArray(color);
    }

    public void setPointColor(double[] color) {
        this.setBodyColor(color);
    }

    public void setPointcolor(double[] color) {
        this.setPointColor(color);
    }

    public void setClosedLoop(Boolean closedLoop) {
    }

    public void setOrbitProvider(String provider) {
        this.provider = provider.replace("gaia.cu9.ari.gaiaorbit", "gaiasky");
    }

    public void setProvider(String provider) {
        this.setOrbitProvider(provider);
    }

    public void setOrbit(OrbitComponent oc) {
        this.oc = oc;
    }

    public void setOrbitScaleFactor(Double scaleFactor) {
        this.multiplier = scaleFactor;
    }

    public void setMultiplier(Double scaleFactor) {
        this.setOrbitScaleFactor(scaleFactor);
    }

    @Deprecated
    public void setOnlyBody(Boolean onlyBody) {
        this.bodyRepresentation = onlyBody != false ? OrbitBodyRepresentation.ONLY_BODY : OrbitBodyRepresentation.BODY_AND_ORBIT;
    }

    @Deprecated
    public void setOnlybody(Boolean onlyBody) {
        this.setOnlyBody(onlyBody);
    }

    public boolean isOnlyBody() {
        return this.bodyRepresentation.isOnlyBody();
    }

    public void setBodyRepresentation(String representation) {
        representation = representation.toUpperCase().trim();
        try {
            this.bodyRepresentation = OrbitBodyRepresentation.valueOf(representation);
        }
        catch (IllegalArgumentException e) {
            logger.error(I18n.msg("notif.error", e.getLocalizedMessage()));
        }
    }

    public void setNewmethod(Boolean newMethod) {
        this.newMethod = newMethod;
    }

    public void setTrail(Boolean trail) {
        this.orbitTrail = trail;
    }

    public void setTrailMap(Double trailMap) {
        this.trailMap = MathUtils.clamp((float)trailMap.floatValue(), (float)0.0f, (float)1.0f);
    }

    public void setTrailMinOpacity(Double trailMin) {
        this.trailMinOpacity = MathUtils.clamp((float)trailMin.floatValue(), (float)0.0f, (float)1.0f);
    }

    public void setOrbittrail(Boolean trail) {
        this.orbitTrail = trail;
    }

    public void setNumSamples(Long numSamples) {
        this.numSamples = FastMath.toIntExact((long)numSamples);
    }

    public void setSampling(String sampling) {
        try {
            this.sampling = OrbitSamplingStrategy.valueOf(sampling.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            logger.error("Unknown orbit sampling value: " + sampling, e);
        }
    }

    public void setFadeDistanceUp(Double distUp) {
        this.distUp = distUp.floatValue();
    }

    public void setFadeDistanceDown(Double distDown) {
        this.distDown = distDown.floatValue();
    }

    public void setRefreshRate(Double refhreshRate) {
        this.refreshRate = refhreshRate;
    }

    public void setBody(Entity entity, double radius) {
        this.setBody(entity, radius, 20.0f, 200.0f);
    }

    public void setBody(Entity entity, double radius, float distDown, float distUp) {
        this.body = entity;
        this.distUp = (float)FastMath.max((double)(radius * (double)distUp), (double)(500.0 * Constants.KM_TO_U));
        this.distDown = (float)FastMath.max((double)(radius * (double)distDown), (double)(50.0 * Constants.KM_TO_U));
    }

    public static enum OrbitBodyRepresentation {
        ONLY_ORBIT,
        ONLY_BODY,
        BODY_AND_ORBIT;


        public boolean isOnlyBody() {
            return this.equals((Object)ONLY_BODY);
        }

        public boolean isOnlyOrbit() {
            return this.equals((Object)ONLY_ORBIT);
        }

        public boolean isBodyAndOrbit() {
            return this.equals((Object)BODY_AND_ORBIT);
        }

        public boolean isOrbit() {
            return this.isOnlyOrbit() || this.isBodyAndOrbit();
        }

        public boolean isBody() {
            return this.isOnlyBody() || this.isBodyAndOrbit();
        }
    }

    public static enum OrbitOrientationModel {
        DEFAULT,
        EXTRASOLAR_SYSTEM;


        public boolean isDefault() {
            return this.equals((Object)DEFAULT);
        }

        public boolean isExtrasolar() {
            return this.equals((Object)EXTRASOLAR_SYSTEM);
        }
    }

    public static enum OrbitSamplingStrategy {
        TIME,
        NU;

    }
}

