/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.component;

import com.badlogic.ashley.core.Component;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.util.math.Vector3D;
import gaiasky.vr.openxr.input.XrControllerDevice;

public class VRDevice
implements Component,
IObserver {
    public XrControllerDevice device;
    public IntModelInstance intersectionModel;
    public Vector3D intersection;
    public Vector3D beamP0 = new Vector3D();
    public Vector3D beamP1 = new Vector3D();
    public Vector3D beamP2 = new Vector3D();
    public Vector3D beamPn = new Vector3D();
    private static final Color normal = ColorUtils.gRedC;
    private static final Color select = ColorUtils.gGreenC;
    public float[] colorP0;
    public float[] colorP1;
    public float[] colorP2;
    public boolean hitUI;
    public boolean interacting;

    public VRDevice() {
        this.colorP0 = new float[]{VRDevice.normal.r, VRDevice.normal.g, VRDevice.normal.b, 0.8f};
        this.colorP1 = new float[]{VRDevice.normal.r, VRDevice.normal.g, VRDevice.normal.b, 0.1f};
        this.colorP2 = new float[]{VRDevice.normal.r, VRDevice.normal.g, VRDevice.normal.b, 0.0f};
        this.hitUI = false;
        this.interacting = false;
        EventManager.instance.subscribe((IObserver)this, Event.VR_SELECTING_STATE);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        XrControllerDevice dev;
        if (event == Event.VR_SELECTING_STATE && (dev = (XrControllerDevice)data[2]) != null && dev == this.device) {
            Boolean selecting = (Boolean)data[0];
            Double completion = (Double)data[1];
            if (selecting.booleanValue()) {
                this.colorP0[0] = VRDevice.select.r;
                this.colorP0[1] = VRDevice.select.g;
                this.colorP0[2] = VRDevice.select.b;
                this.colorP0[3] = (float)MathUtils.clamp((double)(completion + (double)0.2f), (double)0.0, (double)1.0);
                this.colorP1[0] = VRDevice.select.r;
                this.colorP1[1] = VRDevice.select.g;
                this.colorP1[2] = VRDevice.select.b;
                this.colorP1[3] = (float)MathUtils.clamp((double)(completion + (double)0.1f), (double)0.0, (double)1.0);
                this.colorP2[0] = VRDevice.select.r;
                this.colorP2[1] = VRDevice.select.g;
                this.colorP2[2] = VRDevice.select.b;
                this.colorP2[3] = completion.floatValue();
            } else {
                this.colorP0[0] = VRDevice.normal.r;
                this.colorP0[1] = VRDevice.normal.g;
                this.colorP0[2] = VRDevice.normal.b;
                this.colorP0[3] = 0.8f;
                this.colorP1[0] = VRDevice.normal.r;
                this.colorP1[1] = VRDevice.normal.g;
                this.colorP1[2] = VRDevice.normal.b;
                this.colorP1[3] = 0.1f;
                this.colorP2[0] = VRDevice.normal.r;
                this.colorP2[1] = VRDevice.normal.g;
                this.colorP2[2] = VRDevice.normal.b;
                this.colorP2[3] = 0.0f;
            }
        }
    }
}

