/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.entity;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.IntMap;
import gaiasky.event.Event;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.component.Constel;
import gaiasky.scene.entity.EntityRadio;
import gaiasky.util.tree.IPosition;

public class ConstellationRadio
extends EntityRadio {
    public ConstellationRadio(Entity entity) {
        super(entity);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.CONSTELLATION_UPDATE_CMD) {
            Scene scene = (Scene)data[0];
            this.setUp(scene);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp(Scene scene) {
        Constel constel;
        Constel constel2 = constel = (Constel)Mapper.constel.get(this.entity);
        synchronized (constel2) {
            if (!constel.allLoaded) {
                int nPairs = constel.ids.size;
                IntMap<IPosition> hipMap = scene.index().getHipMap();
                constel.allLoaded = true;
                for (int i = 0; i < nPairs; ++i) {
                    int[] pair = (int[])constel.ids.get(i);
                    IPosition s1 = (IPosition)hipMap.get(pair[0]);
                    IPosition s2 = (IPosition)hipMap.get(pair[1]);
                    if (constel.lines[i] == null && s1 != null && s2 != null) {
                        constel.lines[i] = new IPosition[]{s1, s2};
                        continue;
                    }
                    if (s1 != null && s2 != null) continue;
                    constel.allLoaded = false;
                }
            }
        }
    }
}

