/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.entity;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Coordinates;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.ModelScaffolding;
import gaiasky.scene.component.ParticleExtra;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.component.Verts;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;

public class EntityUtils {
    public static Vector3Q getAbsolutePosition(Entity entity, Vector3Q out) {
        if (entity != null) {
            Body body = (Body)Mapper.body.get(entity);
            out.set(body.pos);
            Entity e = entity;
            GraphNode graph = (GraphNode)Mapper.graph.get(e);
            while (graph.parent != null) {
                e = graph.parent;
                graph = (GraphNode)Mapper.graph.get(e);
                out.add(((Body)Mapper.body.get((Entity)e)).pos);
            }
        }
        return out;
    }

    public static Vector3D getAbsolutePosition(Entity entity, Vector3D out) {
        if (entity != null) {
            Body body = (Body)Mapper.body.get(entity);
            body.pos.put(out);
            Entity e = entity;
            GraphNode graph = (GraphNode)Mapper.graph.get(e);
            while (graph.parent != null) {
                e = graph.parent;
                graph = (GraphNode)Mapper.graph.get(e);
                out.add(((Body)Mapper.body.get((Entity)e)).pos);
            }
        }
        return out;
    }

    public static Vector3Q getAbsolutePosition(Entity entity, String name, Vector3Q out) {
        if (Mapper.particleSet.has(entity)) {
            return ((ParticleSet)Mapper.particleSet.get(entity)).getAbsolutePosition(name, out);
        }
        if (Mapper.starSet.has(entity)) {
            return ((StarSet)Mapper.starSet.get(entity)).getAbsolutePosition(name, out);
        }
        return EntityUtils.getAbsolutePosition(entity, out);
    }

    public static Vector3D getAbsolutePosition(Entity entity, String name, Vector3D out) {
        if (Mapper.particleSet.has(entity)) {
            return ((ParticleSet)Mapper.particleSet.get(entity)).getAbsolutePosition(name, out);
        }
        if (Mapper.starSet.has(entity)) {
            return ((StarSet)Mapper.starSet.get(entity)).getAbsolutePosition(name, out);
        }
        return EntityUtils.getAbsolutePosition(entity, out);
    }

    public static boolean isCoordinatesTimeOverflow(Entity entity) {
        return Mapper.coordinates.has(entity) && ((Coordinates)Mapper.coordinates.get((Entity)entity)).timeOverflow;
    }

    public static void blend(Verts verts) {
        if (verts.blend) {
            Gdx.gl20.glEnable(3042);
            if (verts.additive) {
                Gdx.gl20.glBlendFunc(1, 1);
            } else {
                Gdx.gl20.glBlendFunc(770, 771);
            }
        } else {
            Gdx.gl20.glDisable(3042);
        }
    }

    public static void depth(Verts verts) {
        Gdx.gl20.glDepthMask(verts.depth);
        if (verts.depth) {
            Gdx.gl20.glEnable(2929);
        } else {
            Gdx.gl20.glDisable(2929);
        }
    }

    public static boolean isVisibilityOn(Entity entity) {
        return GaiaSky.instance.isOn(((Base)Mapper.base.get((Entity)entity)).ct);
    }

    public static double getRadius(Entity entity) {
        ParticleSet set = EntityUtils.getSet(entity);
        if (set != null) {
            return set.getRadius();
        }
        ParticleExtra extra = (ParticleExtra)Mapper.extra.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        return extra != null ? extra.radius : (double)body.size / 2.0;
    }

    public static double getModelSpan(Entity entity) {
        ParticleSet set = EntityUtils.getSet(entity);
        if (set != null) {
            return set.getRadius() * (set.model != null ? set.model.span : 1.0);
        }
        ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        return (double)(scaffolding != null ? body.size * scaffolding.sizeScaleFactor : body.size) * (model.model.instance != null ? model.model.instance.span : 1.0);
    }

    private static ParticleSet getSet(Entity entity) {
        if (Mapper.particleSet.has(entity)) {
            return (ParticleSet)Mapper.particleSet.get(entity);
        }
        if (Mapper.starSet.has(entity)) {
            return (ParticleSet)Mapper.starSet.get(entity);
        }
        return null;
    }
}

