/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.entity;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.scene.view.FilterView;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Functions;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.math.IntersectorDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.util.List;
import net.jafama.FastMath;

public class FocusHit {
    private final Vector3 F31 = new Vector3();
    private final Vector3D D31 = new Vector3D();
    private final Vector3D D32 = new Vector3D();
    private final Vector3D D33 = new Vector3D();
    private final Vector3Q B31 = new Vector3Q();
    private final FilterView filter = new FilterView();

    boolean hitConditionOverflow(FocusView view) {
        return this.hitCondition(view) && !view.isCoordinatesTimeOverflow();
    }

    boolean hitCondition(FocusView view) {
        return GaiaSky.instance.isOn(view.base.ct) && view.getOpacity() > 0.0f;
    }

    protected boolean checkClickDistance(int screenX, int screenY, Vector3 pos, NaturalCamera camera, float viewportWidth, double pixelSize) {
        return (double)pos.dst((float)screenX % viewportWidth, (float)screenY, pos.z) <= pixelSize;
    }

    private double computeHitSolidAngleCelestial(FocusView view, float fovFactor) {
        return view.getSolidAngle();
    }

    public void addHitCoordinateCelestial(FocusView view, int screenX, int screenY, int w, int h, int pixelDist, NaturalCamera camera, Array<Entity> hits) {
        this.addHitCoordinateCelestial(view, screenX, screenY, w, h, pixelDist, 1.0f, this::computeHitSolidAngleCelestial, camera, hits);
    }

    private void addHitCoordinateCelestial(FocusView view, int screenX, int screenY, int w, int h, int pixelDist, float solidAngleFactor, Functions.Function2<FocusView, Float, Double> solidAngleFunction, NaturalCamera camera, Array<Entity> hits) {
        if (this.hitConditionOverflow(view)) {
            Entity entity = view.getEntity();
            Vector3 pos = this.F31;
            Vector3D posDouble = EntityUtils.getAbsolutePosition(entity, this.D31).add(camera.getInversePos());
            pos.set(posDouble.valuesF());
            if (camera.direction.dot(posDouble) > 0.0) {
                PerspectiveCamera perspectiveCamera;
                double angle = solidAngleFunction.apply(view, Float.valueOf(camera.fovFactor)) * (double)solidAngleFactor;
                if (Settings.settings.program.modeStereo.active) {
                    perspectiveCamera = (float)screenX < (float)w / 2.0f ? camera.getCameraStereoLeft() : camera.getCameraStereoRight();
                    perspectiveCamera.update();
                } else {
                    perspectiveCamera = camera.camera;
                }
                float backBufferScale = (float)Settings.settings.graphics.backBufferScale;
                float viewportHeight = perspectiveCamera.viewportHeight / backBufferScale;
                float viewportWidth = perspectiveCamera.viewportWidth / backBufferScale;
                angle = (float)FastMath.toDegrees((double)(angle * (double)camera.getFovFactor())) * (40.0f / perspectiveCamera.fieldOfView);
                double pixelSize = FastMath.max((double)pixelDist, (double)(angle * (double)viewportHeight / (double)perspectiveCamera.fieldOfView / 2.0));
                perspectiveCamera.project(pos);
                pos.y = viewportHeight - pos.y;
                if (Settings.settings.program.modeStereo.active) {
                    pos.x /= 2.0f;
                }
                if (this.checkClickDistance(screenX, screenY, pos, camera, viewportWidth, pixelSize)) {
                    hits.add((Object)entity);
                }
            }
        }
    }

    public void addHitRayCelestial(FocusView view, Vector3D p0, Vector3D p1, NaturalCamera camera, Array<Entity> hits) {
        Entity entity;
        Vector3Q posb;
        if (this.hitConditionOverflow(view) && camera.direction.dot(posb = EntityUtils.getAbsolutePosition(entity = view.getEntity(), this.B31).add(camera.getInversePos())) > 0.0) {
            double dist = posb.lenDouble();
            double distToLine = IntersectorDouble.distanceLinePoint(p0, p1, posb.put(this.D31));
            double value = distToLine / dist;
            if (value < 0.01) {
                hits.add((Object)entity);
            }
        }
    }

    public void addHitCoordinateModel(FocusView view, int screenX, int screenY, int w, int h, int pixelDist, NaturalCamera camera, Array<Entity> hits) {
        if (this.hitConditionOverflow(view)) {
            Entity entity = view.getEntity();
            SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
            if (view.getSolidAngleApparent() < sa.thresholdQuad * (double)camera.getFovFactor()) {
                this.addHitCoordinateCelestial(view, screenX, screenY, w, h, pixelDist, camera, hits);
            } else {
                GraphNode graph = (GraphNode)Mapper.graph.get(entity);
                Vector3 auxf = this.F31;
                Vector3D aux1d = this.D31;
                Vector3D aux2d = this.D32;
                Vector3D aux3d = this.D33;
                aux1d.set(graph.translation);
                auxf.set(aux1d.valuesF());
                if (camera.direction.dot(aux1d) > 0.0) {
                    auxf.set((float)screenX, (float)screenY, 2.0f);
                    camera.camera.unproject(auxf).nor();
                    aux2d.set(auxf.x, auxf.y, auxf.z);
                    aux3d.set(0.0, 0.0, 0.0);
                    boolean intersect = IntersectorDouble.checkIntersectRaySpehre(aux3d, aux2d, aux1d, view.getRadius());
                    if (intersect) {
                        hits.add((Object)entity);
                    }
                }
            }
        }
    }

    public void addHitRayModel(FocusView view, Vector3D p0, Vector3D p1, NaturalCamera camera, Array<Entity> hits) {
        if (this.hitConditionOverflow(view)) {
            Entity entity = view.getEntity();
            SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
            if (view.getSolidAngleApparent() < sa.thresholdQuad * (double)camera.getFovFactor()) {
                this.addHitRayCelestial(view, p0, p1, camera, hits);
            } else {
                GraphNode graph = (GraphNode)Mapper.graph.get(entity);
                Vector3D aux1d = this.D31;
                aux1d.set(graph.translation);
                boolean intersect = IntersectorDouble.checkIntersectRaySpehre(p0, p1, aux1d, view.getRadius());
                if (intersect) {
                    hits.add((Object)entity);
                }
            }
        }
    }

    private double computeHitSolidAngleStar(FocusView view, float fovFactor) {
        double solidAngle = view.getSolidAngle();
        if (solidAngle > 5.0E-7 / (double)fovFactor && solidAngle < 0.01 / (double)fovFactor) {
            return 9.999999999999999E-6 / (double)fovFactor;
        }
        return solidAngle;
    }

    public void addHitCoordinateStar(FocusView view, int screenX, int screenY, int w, int h, int pixelDist, NaturalCamera camera, Array<Entity> hits) {
        this.addHitCoordinateCelestial(view, screenX, screenY, w, h, pixelDist, Settings.settings.scene.star.brightness, this::computeHitSolidAngleStar, camera, hits);
    }

    public void addHitCoordinateParticleSet(FocusView view, int screenX, int screenY, int w, int h, int pixelDist, NaturalCamera camera, Array<Entity> hits) {
        ParticleSet set = view.getSet();
        List<IParticleRecord> pointData = set.pointData;
        int n = pointData.size();
        if (this.hitCondition(view)) {
            Entity entity = view.getEntity();
            this.filter.setEntity(entity);
            Array temporalHits = new Array();
            for (int i = 0; i < n; ++i) {
                PerspectiveCamera perspectiveCamera;
                if (!this.filter.filter(i)) continue;
                IParticleRecord pb = pointData.get(i);
                Vector3 posFloat = this.F31;
                Vector3D pos = set.fetchPositionDouble(pb, camera.getPos(), this.D31, set.getDeltaYears());
                posFloat.set(pos.valuesF());
                if (!(camera.direction.dot(pos) > 0.0)) continue;
                double dist = pos.len();
                double angle = set.getRadius(i) / dist / (double)camera.getFovFactor();
                if (set.proximityLoadingFlag && set.proximityLoaded.contains(i) && angle >= set.proximityThreshold) continue;
                if (Settings.settings.program.modeStereo.active) {
                    perspectiveCamera = (float)screenX < (float)w / 2.0f ? camera.getCameraStereoLeft() : camera.getCameraStereoRight();
                    perspectiveCamera.update();
                } else {
                    perspectiveCamera = camera.camera;
                }
                float backBufferScale = (float)Settings.settings.graphics.backBufferScale;
                float viewportHeight = perspectiveCamera.viewportHeight / backBufferScale;
                float viewportWidth = perspectiveCamera.viewportWidth / backBufferScale;
                angle = (float)FastMath.toDegrees((double)(angle * (double)camera.fovFactor)) * (40.0f / perspectiveCamera.fieldOfView);
                double pixelSize = FastMath.max((double)pixelDist, (double)(angle * (double)viewportHeight / (double)perspectiveCamera.fieldOfView / 2.0));
                perspectiveCamera.project(posFloat);
                posFloat.y = viewportHeight - posFloat.y;
                if (Settings.settings.program.modeStereo.active) {
                    posFloat.x /= 2.0f;
                }
                if (!((double)posFloat.dst((float)screenX % viewportWidth, (float)screenY, posFloat.z) <= pixelSize)) continue;
                temporalHits.add(new Pair<Integer, Double>(i, angle));
            }
            Pair best = null;
            for (Pair hit : temporalHits) {
                if (best == null) {
                    best = hit;
                    continue;
                }
                if (!((Double)hit.getSecond() > (Double)best.getSecond())) continue;
                best = hit;
            }
            if (best != null) {
                set.candidateFocusIndex = (Integer)best.getFirst();
                set.updateFocusDataPos();
                hits.add((Object)entity);
                return;
            }
        }
        set.candidateFocusIndex = -1;
        set.updateFocusDataPos();
    }

    public void addHitRayParticleSet(FocusView view, Vector3D p0, Vector3D p1, NaturalCamera camera, Array<Entity> hits) {
        ParticleSet set = view.getSet();
        List<IParticleRecord> pointData = set.pointData;
        int n = pointData.size();
        if (this.hitCondition(view)) {
            Entity entity = view.getEntity();
            Vector3D beamDir = new Vector3D();
            this.filter.setEntity(entity);
            Array temporalHits = new Array();
            for (int i = 0; i < n; ++i) {
                if (!this.filter.filter(i)) continue;
                IParticleRecord pb = pointData.get(i);
                Vector3D posd = set.fetchPositionDouble(pb, set.cPosD, this.D31, set.getDeltaYears());
                beamDir.set(p1).sub(p0);
                if (!(camera.direction.dot(posd) > 0.0)) continue;
                double dist = posd.len();
                double angle = set.getRadius(i) / dist / (double)camera.getFovFactor();
                double distToLine = IntersectorDouble.distanceLinePoint(p0, p1, posd.put(this.D31));
                double value = distToLine / dist;
                if (!(value < 0.01)) continue;
                temporalHits.add(new Pair<Integer, Double>(i, angle));
            }
            Pair best = null;
            for (Pair hit : temporalHits) {
                if (best == null) {
                    best = hit;
                    continue;
                }
                if (!((Double)hit.getSecond() > (Double)best.getSecond())) continue;
                best = hit;
            }
            if (best != null) {
                set.candidateFocusIndex = (Integer)best.getFirst();
                set.updateFocusDataPos();
                hits.add((Object)entity);
                return;
            }
        }
        set.candidateFocusIndex = -1;
        set.updateFocusDataPos();
    }

    public void addHitCoordinateCluster(FocusView view, int screenX, int screenY, int w, int h, int pixelDist, NaturalCamera camera, Array<Entity> hits) {
        if (this.hitCondition(view)) {
            Entity entity = view.getEntity();
            Vector3 pos = this.F31;
            Vector3Q posb = EntityUtils.getAbsolutePosition(entity, this.B31).add(camera.posInv);
            pos.set(posb.valuesF());
            if (camera.direction.dot(posb) > 0.0) {
                PerspectiveCamera perspectiveCamera;
                double angle = view.getSolidAngle();
                if (Settings.settings.program.modeStereo.active) {
                    perspectiveCamera = (float)screenX < (float)w / 2.0f ? camera.getCameraStereoLeft() : camera.getCameraStereoRight();
                    perspectiveCamera.update();
                } else {
                    perspectiveCamera = camera.camera;
                }
                float backBufferScale = (float)Settings.settings.graphics.backBufferScale;
                float viewportHeight = perspectiveCamera.viewportHeight / backBufferScale;
                float viewportWidth = perspectiveCamera.viewportWidth / backBufferScale;
                angle = (float)FastMath.toDegrees((double)(angle * (double)camera.getFovFactor())) * (40.0f / perspectiveCamera.fieldOfView);
                double pixelSize = angle * (double)viewportHeight / (double)perspectiveCamera.fieldOfView / 2.0;
                perspectiveCamera.project(pos);
                pos.y = viewportHeight - pos.y;
                if (Settings.settings.program.modeStereo.active) {
                    pos.x /= 2.0f;
                }
                if (this.checkClickDistance(screenX, screenY, pos, camera, viewportWidth, pixelSize)) {
                    hits.add((Object)entity);
                }
            }
        }
    }

    public void addHitRayCluster(FocusView view, Vector3D p0, Vector3D p1, NaturalCamera camera, Array<Entity> hits) {
        Vector3Q aux;
        Entity entity;
        Vector3Q posb;
        if (this.hitCondition(view) && camera.direction.dot(posb = EntityUtils.getAbsolutePosition(entity = view.getEntity(), aux = this.B31).add(camera.getInversePos())) > 0.0) {
            double dist = posb.lenDouble();
            double distToLine = IntersectorDouble.distanceLinePoint(p0, p1, posb.tov3d(this.D32));
            double value = distToLine / dist;
            if (value < 0.01) {
                hits.add((Object)entity);
            }
        }
    }
}

