/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.entity;

import com.badlogic.ashley.core.Entity;
import gaiasky.event.Event;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GridRecursive;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.entity.EntityRadio;
import gaiasky.util.Settings;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;

public class GridRecursiveRadio
extends EntityRadio {
    public GridRecursiveRadio(Entity entity) {
        super(entity);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        ComponentTypes.ComponentType ct;
        if (event == Event.TOGGLE_VISIBILITY_CMD && (ct = ComponentTypes.ComponentType.getFromKey((String)data[0])) != null && Settings.settings.scene.visibility.get(ct.toString()).booleanValue()) {
            Body body = (Body)Mapper.body.get(this.entity);
            Model model = (Model)Mapper.model.get(this.entity);
            RefSysTransform transform = (RefSysTransform)Mapper.transform.get(this.entity);
            GridRecursive gr = (GridRecursive)Mapper.gridRec.get(this.entity);
            if (ct.equals((Object)ComponentTypes.ComponentType.Equatorial)) {
                transform.setTransformName(null);
                body.color = gr.ccEq;
                body.labelColor = gr.ccEq;
            } else if (ct.equals((Object)ComponentTypes.ComponentType.Ecliptic)) {
                transform.setTransformName("eclipticToEquatorial");
                body.color = gr.ccEcl;
                body.labelColor = gr.ccEcl;
            } else if (ct.equals((Object)ComponentTypes.ComponentType.Galactic)) {
                transform.setTransformName("galacticToEquatorial");
                body.color = gr.ccGal;
                body.labelColor = gr.ccGal;
            }
            model.model.setColorAttribute(ColorAttribute.Diffuse, body.color);
            model.model.setColorAttribute(ColorAttribute.Emissive, ColorUtils.getRgbaComplimentary(body.color));
        }
    }
}

