/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.entity;

import com.badlogic.ashley.core.Entity;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.component.Arrow;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Verts;
import gaiasky.scene.component.tag.TagNoProcess;
import gaiasky.util.math.Vector3Q;

public class KeyframeUtils {
    public KeyframeUtils(Scene scene) {
    }

    public Entity newVerts(Scene scene, String name, ComponentTypes ct, String className, float[] color, RenderGroup rg, boolean closedLoop, float primitiveSize, boolean arrowCaps) {
        Entity entity = scene.archetypes().get(className).createEntity();
        Base base = (Base)Mapper.base.get(entity);
        base.setName(name);
        base.ct = ct;
        Body body = (Body)Mapper.body.get(entity);
        body.setColor(color);
        Verts verts = (Verts)Mapper.verts.get(entity);
        verts.renderGroup = rg;
        verts.primitiveSize = primitiveSize;
        verts.glPrimitive = rg.isPoint() ? 0 : 3;
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        graph.translation = new Vector3Q();
        scene.initializeEntity(entity);
        entity.add(scene.engine.createComponent(TagNoProcess.class));
        Arrow arrow = (Arrow)Mapper.arrow.get(entity);
        if (arrow != null) {
            arrow.arrowCap = arrowCaps;
        }
        return entity;
    }

    public Entity newVerts(Scene scene, String name, ComponentTypes ct, String className, float[] color, RenderGroup rg, boolean closedLoop, float primitiveSize) {
        return this.newVerts(scene, name, ct, className, color, rg, closedLoop, primitiveSize, false);
    }

    public Entity newVerts(Scene scene, String name, ComponentTypes ct, String className, float[] color, RenderGroup rg, boolean closedLoop, float primitiveSize, boolean blend, boolean depth) {
        Entity entity = this.newVerts(scene, name, ct, className, color, rg, closedLoop, primitiveSize);
        Verts verts = (Verts)Mapper.verts.get(entity);
        verts.blend = blend;
        verts.depth = depth;
        return entity;
    }
}

