/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.entity;

import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.math.Vector3;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Model;
import gaiasky.util.Constants;
import gaiasky.util.TLV3;
import gaiasky.util.camera.Proximity;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3Q;
import net.jafama.FastMath;

public class LightingUtils {
    private static final double LIGHT_X0 = 0.1 * Constants.AU_TO_U;
    private static final double LIGHT_X1 = 500.0 * Constants.AU_TO_U;
    private static final ThreadLocal<Vector3> F31 = new TLV3();

    public static void updateLights(Model model, Body body, GraphNode graph, ICamera camera) {
        if (model.model != null && !model.model.isStaticLight() && body.distToCamera <= LIGHT_X1) {
            for (int i = 0; i < 3; ++i) {
                IFocus lightSource = camera.getCloseLightSource(i);
                if (lightSource != null) {
                    if (!(lightSource instanceof Proximity.NearbyRecord)) continue;
                    Proximity.NearbyRecord nr = (Proximity.NearbyRecord)lightSource;
                    PointLight pointLight = model.model.pointLight(i);
                    if (pointLight == null) continue;
                    if (nr.isStar() || nr.isStarGroup()) {
                        float[] col = nr.getColor();
                        double closestDist = nr.getClosestDistToCamera();
                        float colFactor = (float)FastMath.pow((double)MathUtilsDouble.flint(closestDist, LIGHT_X0, LIGHT_X1, 1.0, 0.0), (double)2.0);
                        pointLight.position.set(nr.pos.put(F31.get()));
                        pointLight.color.set(col[0] * colFactor, col[1] * colFactor, col[2] * colFactor, colFactor);
                        pointLight.intensity = 1.0f;
                        continue;
                    }
                    Vector3Q campos = camera.getPos();
                    pointLight.position.set(campos.x.floatValue(), campos.y.floatValue(), campos.z.floatValue());
                    pointLight.color.set(0.0f, 0.0f, 0.0f, 0.0f);
                    pointLight.intensity = 0.0f;
                    continue;
                }
                PointLight pointLight = model.model.pointLight(i);
                if (pointLight == null) continue;
                pointLight.color.set(0.0f, 0.0f, 0.0f, 0.0f);
                pointLight.intensity = 0.0f;
            }
        }
    }
}

